/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class DirectNode {
    public final DirectNodeType type;
    public final String id;
    public BasicBlockStatement block;
    public final Statement statement;
    public List<Exprent> exprents = new ArrayList<Exprent>();
    private final Map<DirectEdgeType, List<DirectEdge>> successors = new HashMap<DirectEdgeType, List<DirectEdge>>();
    private final Map<DirectEdgeType, List<DirectEdge>> predecessors = new HashMap<DirectEdgeType, List<DirectEdge>>();

    private DirectNode(DirectNodeType type, Statement statement) {
        this.type = type;
        this.statement = statement;
        this.id = type.makeId(statement.id);
    }

    public static DirectNode forStat(DirectNodeType type, Statement statement) {
        return new DirectNode(type, statement);
    }

    public boolean hasSuccessors(DirectEdgeType type) {
        return this.successors.containsKey((Object)type) && !this.successors.get((Object)type).isEmpty();
    }

    public List<DirectEdge> getSuccessors(DirectEdgeType type) {
        return this.successors.computeIfAbsent(type, t -> new ArrayList());
    }

    public boolean hasPredecessors(DirectEdgeType type) {
        return this.predecessors.containsKey((Object)type) && !this.predecessors.get((Object)type).isEmpty();
    }

    public List<DirectEdge> getPredecessors(DirectEdgeType type) {
        return this.predecessors.computeIfAbsent(type, t -> new ArrayList());
    }

    public void addSuccessor(DirectEdge edge) {
        if (!this.getSuccessors(edge.getType()).contains(edge)) {
            this.getSuccessors(edge.getType()).add(edge);
        }
        if (!edge.getDestination().getPredecessors(edge.getType()).contains(edge)) {
            edge.getDestination().getPredecessors(edge.getType()).add(edge);
        }
    }

    @Deprecated
    public List<DirectNode> succs() {
        return this.getSuccessors(DirectEdgeType.REGULAR).stream().map(DirectEdge::getDestination).collect(Collectors.toList());
    }

    @Deprecated
    public List<DirectNode> preds() {
        return this.getPredecessors(DirectEdgeType.REGULAR).stream().map(DirectEdge::getSource).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectNode that = (DirectNode)o;
        return this.type == that.type && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id});
    }

    public String toString() {
        return this.id;
    }
}

