/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.java.decompiler.api.GraphFlattener;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class FlattenStatementsHelper
implements GraphFlattener {
    private static final int SWITCH_CONST = 1000000;
    private final Map<Integer, String[]> mapDestinationNodes = new HashMap<Integer, String[]>();
    private final List<Edge> listEdges = new ArrayList<Edge>();
    private final Map<String, List<String[]>> mapShortRangeFinallyPathIds = new HashMap<String, List<String[]>>();
    private final Map<String, List<String[]>> mapLongRangeFinallyPathIds = new HashMap<String, List<String[]>>();
    private final Map<String, Integer> mapPosIfBranch = new HashMap<String, Integer>();
    private final ListStack<List<DirectNode>> tryNodesStack = new ListStack();
    private DirectGraph graph;
    private RootStatement root;

    @Override
    public DirectGraph buildDirectGraph(RootStatement root) {
        this.root = root;
        this.graph = new DirectGraph();
        this.flattenStatement();
        DummyExitStatement dummyexit = root.getDummyExit();
        DirectNode node = this.createDirectNode(dummyexit);
        this.mapDestinationNodes.put(dummyexit.id, new String[]{node.id, null});
        this.setEdges();
        this.graph.first = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(root.id)[0]);
        this.graph.sortReversePostOrder();
        this.graph.mapDestinationNodes.putAll(this.mapDestinationNodes);
        return this.graph;
    }

    private DirectNode createDirectNode(Statement stat) {
        DirectNode directNode = this.createDirectNode(stat, DirectNodeType.DIRECT);
        if (stat instanceof BasicBlockStatement) {
            directNode.block = (BasicBlockStatement)stat;
        }
        return directNode;
    }

    private DirectNode createDirectNode(Statement stat, DirectNodeType type) {
        DirectNode node = DirectNode.forStat(type, stat);
        this.graph.nodes.addWithKey(node, node.id);
        if (!this.tryNodesStack.isEmpty()) {
            this.tryNodesStack.peek().add(node);
        }
        return node;
    }

    private void flattenStatement() {
        LinkedList<StatementStackEntry> lstStackStatements = new LinkedList<StatementStackEntry>();
        class StatementStackEntry {
            public final Statement statement;
            public final LinkedList<StackEntry> stackFinally;
            public final List<Exprent> tailExprents;
            public int statementIndex;
            public int edgeIndex;
            public List<StatEdge> succEdges;

            StatementStackEntry(Statement statement, LinkedList<StackEntry> stackFinally, List<Exprent> tailExprents) {
                this.statement = statement;
                this.stackFinally = stackFinally;
                this.tailExprents = tailExprents;
            }
        }
        lstStackStatements.add(new StatementStackEntry(this.root, new LinkedList<StackEntry>(), null));
        block16: while (!lstStackStatements.isEmpty()) {
            StatementStackEntry statEntry = (StatementStackEntry)lstStackStatements.removeFirst();
            Statement stat = statEntry.statement;
            LinkedList<StackEntry> stackFinally = statEntry.stackFinally;
            int statementBreakIndex = statEntry.statementIndex;
            List<Object> lstSuccEdges = new ArrayList();
            DirectNode sourcenode = null;
            if (statEntry.succEdges == null) {
                block0 : switch (stat.type) {
                    case BASIC_BLOCK: {
                        StatEdge predEdge;
                        List<StatEdge> basicPreds;
                        DirectNode node = this.createDirectNode(stat);
                        if (stat.getExprents() != null) {
                            node.exprents = stat.getExprents();
                        }
                        this.mapDestinationNodes.put(stat.id, new String[]{node.id, null});
                        lstSuccEdges.addAll(stat.getSuccessorEdges(0x40000000));
                        sourcenode = node;
                        List<Exprent> tailExprentList = statEntry.tailExprents;
                        if (tailExprentList != null) {
                            DirectNode tail = this.createDirectNode(stat, DirectNodeType.TAIL);
                            this.graph.nodes.putWithKey(tail, tail.id);
                            tail.exprents = tailExprentList;
                            this.mapDestinationNodes.put(-stat.id, new String[]{tail.id, null});
                            this.listEdges.add(new Edge(node.id, -stat.id, 1));
                            sourcenode = tail;
                        }
                        if (stat.getLastBasicType() == Statement.LastBasicType.IF) {
                            if (lstSuccEdges.isEmpty()) {
                                throw new IllegalStateException("Empty successor list for node " + sourcenode.id);
                            }
                            this.mapPosIfBranch.put(sourcenode.id, ((StatEdge)lstSuccEdges.get((int)0)).getDestination().id);
                        }
                        if ((basicPreds = stat.getAllPredecessorEdges()).size() != 1 || (predEdge = basicPreds.get(0)).getType() != 1 || !(predEdge.getSource() instanceof SequenceStatement)) break;
                        this.addEdgeIfPossible(predEdge.getSource().getBasichead().id, stat);
                        break;
                    }
                    case CATCH_ALL: 
                    case TRY_CATCH: {
                        if (statementBreakIndex == 0) {
                            CatchStatement catchStat;
                            Object resources;
                            DirectNode firstnd = this.createDirectNode(stat, DirectNodeType.TRY);
                            if (stat instanceof CatchStatement && !(resources = (catchStat = (CatchStatement)stat).getResources()).isEmpty()) {
                                firstnd.exprents = resources;
                            }
                            this.mapDestinationNodes.put(stat.id, new String[]{firstnd.id, null});
                            LinkedList<StatementStackEntry> lst = new LinkedList<StatementStackEntry>();
                            resources = stat.getStats().iterator();
                            while (resources.hasNext()) {
                                Statement st = (Statement)resources.next();
                                this.listEdges.add(new Edge(firstnd.id, st.id, 1));
                                LinkedList<StackEntry> stack = stackFinally;
                                if (stat instanceof CatchAllStatement && ((CatchAllStatement)stat).isFinally()) {
                                    stack = new LinkedList<StackEntry>(stackFinally);
                                    if (st == stat.getFirst()) {
                                        stack.add(new StackEntry((CatchAllStatement)stat, false));
                                    } else {
                                        stack.add(new StackEntry((CatchAllStatement)stat, true, 4, this.root.getDummyExit(), st, st, firstnd, firstnd, true));
                                    }
                                }
                                lst.add(new StatementStackEntry(st, stack, null));
                                if (st != stat.getFirst()) continue;
                                lst.add(statEntry);
                                statEntry.statementIndex = 1;
                            }
                            lstStackStatements.addAll(0, lst);
                            this.tryNodesStack.add(new ArrayList());
                            break;
                        }
                        List<DirectNode> tryNodes = this.tryNodesStack.pop();
                        VBStyleCollection<Statement, Integer> statements = stat.getStats();
                        int end = stat instanceof CatchAllStatement && ((CatchAllStatement)stat).isFinally() ? statements.size() - 1 : statements.size();
                        for (int i = 1; i < end; ++i) {
                            for (DirectNode tryNode : tryNodes) {
                                this.listEdges.add(new Edge(tryNode.id, ((Statement)statements.get((int)i)).id, 2));
                            }
                        }
                        if (this.tryNodesStack.isEmpty()) break;
                        this.tryNodesStack.peek().addAll(tryNodes);
                        break;
                    }
                    case DO: {
                        DirectNode node;
                        if (statementBreakIndex == 0) {
                            List<StatEdge> prededges;
                            Statement dest;
                            statEntry.statementIndex = 1;
                            lstStackStatements.addFirst(statEntry);
                            lstStackStatements.addFirst(new StatementStackEntry(stat.getFirst(), stackFinally, null));
                            if (stat.hasBasicSuccEdge() || !stat.hasSuccessor(1) || (dest = stat.getSuccessorEdges(1).get(0).getDestination()).getAllPredecessorEdges().size() != 1 || (prededges = stat.getPredecessorEdges(1)).isEmpty()) continue block16;
                            StatEdge prededge = prededges.get(0);
                            this.addEdgeIfPossible(prededge.getSource().id, dest);
                            continue block16;
                        }
                        DirectNode nd = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(stat.getFirst().id)[0]);
                        DoStatement dostat = (DoStatement)stat;
                        DoStatement.Type looptype = dostat.getLooptype();
                        if (looptype == DoStatement.Type.INFINITE) {
                            this.mapDestinationNodes.put(stat.id, new String[]{nd.id, nd.id});
                            break;
                        }
                        lstSuccEdges.add(stat.getSuccessorEdges(0x40000000).get(0));
                        switch (looptype) {
                            case WHILE: 
                            case DO_WHILE: {
                                node = this.createDirectNode(stat, DirectNodeType.CONDITION);
                                node.exprents = dostat.getConditionExprentList();
                                this.listEdges.add(new Edge(node.id, stat.getFirst().id, 1));
                                if (looptype == DoStatement.Type.WHILE) {
                                    this.mapDestinationNodes.put(stat.id, new String[]{node.id, node.id});
                                } else {
                                    this.mapDestinationNodes.put(stat.id, new String[]{nd.id, node.id});
                                    boolean found = false;
                                    for (Edge edge : this.listEdges) {
                                        if (!edge.statid.equals(stat.id) || edge.edgetype != 8) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        this.listEdges.add(new Edge(nd.id, stat.id, 8));
                                    }
                                }
                                sourcenode = node;
                                break block0;
                            }
                            case FOR: {
                                DirectNode nodeinit = this.createDirectNode(stat, DirectNodeType.INIT);
                                if (dostat.getInitExprent() != null) {
                                    nodeinit.exprents = dostat.getInitExprentList();
                                }
                                DirectNode nodecond = this.createDirectNode(stat, DirectNodeType.CONDITION);
                                nodecond.exprents = dostat.getConditionExprentList();
                                DirectNode nodeinc = this.createDirectNode(stat, DirectNodeType.INCREMENT);
                                nodeinc.exprents = dostat.getIncExprentList();
                                this.mapDestinationNodes.put(stat.id, new String[]{nodeinit.id, nodeinc.id});
                                this.mapDestinationNodes.put(-stat.id, new String[]{nodecond.id, null});
                                this.listEdges.add(new Edge(nodecond.id, stat.getFirst().id, 1));
                                this.listEdges.add(new Edge(nodeinit.id, -stat.id, 1));
                                this.listEdges.add(new Edge(nodeinc.id, -stat.id, 1));
                                boolean found = false;
                                for (Edge edge : this.listEdges) {
                                    if (!edge.statid.equals(stat.id) || edge.edgetype != 8) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    this.listEdges.add(new Edge(nd.id, stat.id, 8));
                                }
                                sourcenode = nodecond;
                                break block0;
                            }
                            case FOR_EACH: {
                                DirectNode inc = this.createDirectNode(stat, DirectNodeType.INCREMENT);
                                inc.exprents = dostat.getIncExprentList();
                                DirectNode init = this.createDirectNode(stat, DirectNodeType.FOREACH_VARDEF);
                                init.exprents = dostat.getInitExprentList();
                                this.mapDestinationNodes.put(stat.id, new String[]{inc.id, init.id});
                                this.mapDestinationNodes.put(-stat.id, new String[]{init.id, null});
                                this.listEdges.add(new Edge(init.id, stat.getFirst().id, 1));
                                this.listEdges.add(new Edge(inc.id, -stat.id, 1));
                                boolean found = false;
                                for (Edge edge : this.listEdges) {
                                    if (!edge.statid.equals(stat.id) || edge.edgetype != 8) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    this.listEdges.add(new Edge(nd.id, stat.id, 8));
                                }
                                sourcenode = init;
                                break block0;
                            }
                        }
                        break;
                    }
                    case SYNCHRONIZED: 
                    case SWITCH: 
                    case IF: 
                    case SEQUENCE: 
                    case ROOT: {
                        Edge newEdge;
                        DirectNode srcnd;
                        StatEdge edge;
                        Statement source;
                        int statsize = stat.getStats().size();
                        if (stat instanceof SynchronizedStatement) {
                            statsize = 2;
                        }
                        if (statementBreakIndex > statsize) break;
                        List<Exprent> tailexprlst = null;
                        switch (stat.type) {
                            case SYNCHRONIZED: {
                                tailexprlst = ((SynchronizedStatement)stat).getHeadexprentList();
                                break;
                            }
                            case SWITCH: {
                                tailexprlst = ((SwitchStatement)stat).getHeadexprentList();
                                break;
                            }
                            case IF: {
                                tailexprlst = ((IfStatement)stat).getHeadexprentList();
                            }
                        }
                        int i = statementBreakIndex;
                        if (i < statsize) {
                            statEntry.statementIndex = i + 1;
                            lstStackStatements.addFirst(statEntry);
                            lstStackStatements.addFirst(new StatementStackEntry((Statement)stat.getStats().get(i), stackFinally, i == 0 && tailexprlst != null && tailexprlst.get(0) != null ? tailexprlst : null));
                            continue block16;
                        }
                        DirectNode node = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(stat.getFirst().id)[0]);
                        this.mapDestinationNodes.put(stat.id, new String[]{node.id, null});
                        if (stat instanceof SwitchStatement) {
                            SwitchStatement switchSt = (SwitchStatement)stat;
                            Statement first = stat.getFirst();
                            ArrayList<Edge> headEdges = new ArrayList<Edge>();
                            for (Edge edge2 : this.listEdges) {
                                if (!edge2.sourceid.equals(first.id + "_tail") || !switchSt.getStats().containsKey(edge2.statid)) continue;
                                headEdges.add(edge2);
                            }
                            if (!headEdges.isEmpty()) {
                                for (Edge edge2 : headEdges) {
                                    Statement caseSt = switchSt.findCaseBranchContaining(edge2.statid);
                                    int index = switchSt.getCaseStatements().indexOf(caseSt);
                                    if (index == -1) continue;
                                    List<Exprent> values = switchSt.getCaseValues().get(index);
                                    ArrayList<Exprent> finalVals = null;
                                    if (values != null) {
                                        finalVals = new ArrayList<Exprent>();
                                        for (Exprent value : values) {
                                            if (value == null) continue;
                                            finalVals.add(value);
                                        }
                                    }
                                    DirectNode casend = DirectNode.forStat(DirectNodeType.CASE, caseSt);
                                    casend.exprents = finalVals;
                                    this.graph.nodes.addWithKey(casend, casend.id);
                                    this.mapDestinationNodes.put(caseSt.id - 1000000, new String[]{casend.id, null});
                                    this.listEdges.remove(edge2);
                                    this.listEdges.add(new Edge(edge2.sourceid, caseSt.id - 1000000, 1));
                                    this.listEdges.add(new Edge(casend.id, edge2.statid, 1));
                                }
                            }
                        }
                        if (stat instanceof IfStatement && ((IfStatement)stat).iftype == 0 && !stat.getAllSuccessorEdges().isEmpty()) {
                            lstSuccEdges.add(stat.getSuccessorEdges(0x40000000).get(0));
                            DirectNode directNode = sourcenode = tailexprlst.get(0) == null ? node : this.graph.nodes.getWithKey(node.id + "_tail");
                        }
                        if (!(stat instanceof IfStatement) || ((IfStatement)stat).iftype != 0 || stat.getPredecessorEdges(1).isEmpty() || !stat.getFirst().getPredecessorEdges(1).isEmpty() || !((source = (edge = stat.getPredecessorEdges(1).get(0)).getSource()) instanceof IfStatement) || ((IfStatement)source).iftype != 0 || source.getAllSuccessorEdges().isEmpty() || (srcnd = this.graph.nodes.getWithKey(source.getFirst().id + "_tail")) == null || this.listEdges.contains(newEdge = new Edge(srcnd.id, stat.id, edge.getType()))) break;
                        this.listEdges.add(newEdge);
                    }
                }
            }
            if (sourcenode == null) continue;
            if (statEntry.succEdges != null) {
                lstSuccEdges = statEntry.succEdges;
            }
            for (int edgeindex = statEntry.edgeIndex; edgeindex < lstSuccEdges.size(); ++edgeindex) {
                boolean created;
                StatEdge edge = (StatEdge)lstSuccEdges.get(edgeindex);
                LinkedList<StackEntry> stack = new LinkedList<StackEntry>(stackFinally);
                int edgetype = edge.getType();
                Statement destination = edge.getDestination();
                DirectNode finallyShortRangeSource = sourcenode;
                DirectNode finallyLongRangeSource = sourcenode;
                Statement finallyShortRangeEntry = null;
                Statement finallyLongRangeEntry = null;
                boolean isFinallyMonitorExceptionPath = false;
                boolean isFinallyExit = false;
                do {
                    StackEntry entry = null;
                    if (!stack.isEmpty()) {
                        entry = stack.getLast();
                    }
                    created = true;
                    if (entry == null) {
                        this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        continue;
                    }
                    CatchAllStatement catchall = entry.catchstatement;
                    if (entry.state) {
                        if (edgetype == 32) {
                            stack.removeLast();
                            destination = entry.destination;
                            edgetype = entry.edgetype;
                            finallyShortRangeSource = entry.finallyShortRangeSource;
                            finallyLongRangeSource = entry.finallyLongRangeSource;
                            finallyShortRangeEntry = entry.finallyShortRangeEntry;
                            finallyLongRangeEntry = entry.finallyLongRangeEntry;
                            isFinallyExit = true;
                            isFinallyMonitorExceptionPath = catchall.getMonitor() != null & entry.isFinallyExceptionPath;
                            created = false;
                            continue;
                        }
                        if (!catchall.containsStatementStrict(destination)) {
                            stack.removeLast();
                            created = false;
                            continue;
                        }
                        this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        continue;
                    }
                    if (!catchall.containsStatementStrict(destination)) {
                        this.listEdges.add(new Edge(sourcenode.id, destination.id, edgetype));
                        this.saveEdge(sourcenode, catchall.getHandler(), 1, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        stack.removeLast();
                        stack.add(new StackEntry(catchall, true, edgetype, destination, catchall.getHandler(), finallyLongRangeEntry == null ? catchall.getHandler() : finallyLongRangeEntry, sourcenode, finallyLongRangeSource, false));
                        statEntry.edgeIndex = edgeindex + 1;
                        statEntry.succEdges = lstSuccEdges;
                        lstStackStatements.addFirst(statEntry);
                        lstStackStatements.addFirst(new StatementStackEntry(catchall.getHandler(), stack, null));
                        continue block16;
                    }
                    this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                } while (!created);
            }
        }
    }

    private void addEdgeIfPossible(Integer predEdge, Statement stat) {
        String[] lastbasicdests = this.mapDestinationNodes.get(predEdge);
        if (lastbasicdests != null) {
            this.listEdges.add(new Edge(this.graph.nodes.getWithKey((String)lastbasicdests[0]).id, stat.id, 1));
        }
    }

    private boolean hasAnyEdgeTo(List<Edge> listEdges, Statement stat) {
        for (Edge edge : listEdges) {
            if (edge.statid != stat.id) continue;
            return true;
        }
        return false;
    }

    private void saveEdge(DirectNode sourcenode, Statement destination, int edgetype, DirectNode finallyShortRangeSource, DirectNode finallyLongRangeSource, Statement finallyShortRangeEntry, Statement finallyLongRangeEntry, boolean isFinallyMonitorExceptionPath) {
        if (edgetype != 32) {
            this.listEdges.add(new Edge(sourcenode.id, destination.id, edgetype));
        }
        if (finallyShortRangeSource != null) {
            boolean isContinueEdge = edgetype == 8;
            this.mapShortRangeFinallyPathIds.computeIfAbsent(sourcenode.id, k -> new ArrayList()).add(new String[]{finallyShortRangeSource.id, String.valueOf(destination.id), String.valueOf(finallyShortRangeEntry.id), isFinallyMonitorExceptionPath ? "1" : null, isContinueEdge ? "1" : null});
            this.mapLongRangeFinallyPathIds.computeIfAbsent(sourcenode.id, k -> new ArrayList()).add(new String[]{finallyLongRangeSource.id, String.valueOf(destination.id), String.valueOf(finallyLongRangeEntry.id), isContinueEdge ? "1" : null});
        }
    }

    private void setEdges() {
        for (Edge edge : this.listEdges) {
            String sourceid = edge.sourceid;
            Integer statid = edge.statid;
            DirectNode source = this.graph.nodes.getWithKey(sourceid);
            String[] strings = this.mapDestinationNodes.get(statid);
            if (strings == null) {
                DotExporter.toDotFile(this.graph, this.root.mt, "errorDGraph");
                throw new IllegalStateException("Could not find destination nodes for stat id " + statid + " from source " + sourceid);
            }
            DirectNode dest = this.graph.nodes.getWithKey(strings[edge.edgetype == 8 ? 1 : 0]);
            DirectEdge diedge = edge.edgetype == 2 ? DirectEdge.exception(source, dest) : DirectEdge.of(source, dest);
            source.addSuccessor(diedge);
            if (!this.mapPosIfBranch.containsKey(sourceid) || statid.equals(this.mapPosIfBranch.get(sourceid))) continue;
            this.graph.mapNegIfBranch.put(sourceid, dest.id);
        }
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<String, List<String[]>> ent : (i == 0 ? this.mapShortRangeFinallyPathIds : this.mapLongRangeFinallyPathIds).entrySet()) {
                ArrayList<FinallyPathWrapper> newLst = new ArrayList<FinallyPathWrapper>();
                List<String[]> lst = ent.getValue();
                for (String[] arr : lst) {
                    boolean isContinueEdge = arr[i == 0 ? 4 : 3] != null;
                    DirectNode dest = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(Integer.parseInt(arr[1]))[isContinueEdge ? 1 : 0]);
                    DirectNode enter = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(Integer.parseInt(arr[2]))[0]);
                    newLst.add(new FinallyPathWrapper(arr[0], dest.id, enter.id));
                    if (i != 0 || arr[3] == null) continue;
                    this.graph.mapFinallyMonitorExceptionPathExits.put(ent.getKey(), dest.id);
                }
                if (newLst.isEmpty()) continue;
                (i == 0 ? this.graph.mapShortRangeFinallyPaths : this.graph.mapLongRangeFinallyPaths).put(ent.getKey(), new ArrayList(new HashSet(newLst)));
            }
        }
    }

    public Map<Integer, String[]> getMapDestinationNodes() {
        return this.mapDestinationNodes;
    }

    private static class Edge {
        public final String sourceid;
        public final Integer statid;
        public final int edgetype;

        Edge(String sourceid, Integer statid, int edgetype) {
            this.sourceid = sourceid;
            this.statid = statid;
            this.edgetype = edgetype;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.edgetype == edge.edgetype && Objects.equals(this.sourceid, edge.sourceid) && Objects.equals(this.statid, edge.statid);
        }

        public String toString() {
            return "Source: " + this.sourceid + " Stat: " + this.statid + " Edge: " + this.edgetype;
        }
    }

    private static class StackEntry {
        public final CatchAllStatement catchstatement;
        public final boolean state;
        public final int edgetype;
        public final boolean isFinallyExceptionPath;
        public final Statement destination;
        public final Statement finallyShortRangeEntry;
        public final Statement finallyLongRangeEntry;
        public final DirectNode finallyShortRangeSource;
        public final DirectNode finallyLongRangeSource;

        StackEntry(CatchAllStatement catchstatement, boolean state, int edgetype, Statement destination, Statement finallyShortRangeEntry, Statement finallyLongRangeEntry, DirectNode finallyShortRangeSource, DirectNode finallyLongRangeSource, boolean isFinallyExceptionPath) {
            this.catchstatement = catchstatement;
            this.state = state;
            this.edgetype = edgetype;
            this.isFinallyExceptionPath = isFinallyExceptionPath;
            this.destination = destination;
            this.finallyShortRangeEntry = finallyShortRangeEntry;
            this.finallyLongRangeEntry = finallyLongRangeEntry;
            this.finallyShortRangeSource = finallyShortRangeSource;
            this.finallyLongRangeSource = finallyLongRangeSource;
        }

        StackEntry(CatchAllStatement catchstatement, boolean state) {
            this(catchstatement, state, -1, null, null, null, null, null, false);
        }
    }

    public static final class FinallyPathWrapper {
        public final String source;
        public final String destination;
        public final String entry;

        private FinallyPathWrapper(String source, String destination, String entry) {
            this.source = source;
            this.destination = destination;
            this.entry = entry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FinallyPathWrapper)) {
                return false;
            }
            FinallyPathWrapper fpw = (FinallyPathWrapper)o;
            return (this.source + ":" + this.destination + ":" + this.entry).equals(fpw.source + ":" + fpw.destination + ":" + fpw.entry);
        }

        public int hashCode() {
            return (this.source + ":" + this.destination + ":" + this.entry).hashCode();
        }

        public String toString() {
            return this.source + "->(" + this.entry + ")->" + this.destination;
        }
    }
}

