/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.api.SFormsCreator;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.VarMapHolder;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionEdge;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public abstract class SFormsConstructor
implements SFormsCreator {
    private final boolean incrementOnUsage;
    private final boolean simplePhi;
    private final boolean trackFieldVars;
    private final boolean trackPhantomPPNodes;
    private final boolean trackPhantomExitNodes;
    private final boolean trackSsuVersions;
    private final boolean doLiveVariableAnalysisRound;
    private final boolean trackDirectAssignments;
    private final boolean blockFieldPropagation;
    @Deprecated
    private final boolean ssau;
    final HashMap<String, SFormsFastMapDirect> inVarVersions = new HashMap();
    final HashMap<String, SFormsFastMapDirect> outVarVersions = new HashMap();
    final HashMap<String, SFormsFastMapDirect> outNegVarVersions = new HashMap();
    final HashMap<String, SFormsFastMapDirect> extraVarVersions = new HashMap();
    final HashMap<String, SFormsFastMapDirect> catchableVersions = new HashMap();
    final HashMap<Integer, Integer> lastversion = new HashMap();
    FastSparseSetFactory<Integer> factory;
    private final HashMap<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> phi;
    private final Map<VarVersionPair, Integer> mapVersionFirstRange;
    private final Map<VarVersionPair, VarVersionPair> phantomppnodes;
    private final Map<String, HashMap<VarVersionPair, VarVersionPair>> phantomexitnodes;
    private final VarVersionsGraph ssuversions;
    private final Map<Integer, Integer> mapFieldVars;
    private int fieldvarcounter = -1;
    private final HashMap<VarVersionPair, VarVersionPair> varAssignmentMap;
    private SFormsFastMapDirect currentCatchableMap = null;
    private RootStatement root;
    private StructMethod mt;
    private DirectGraph dgraph;

    public SFormsConstructor(boolean incrementOnUsage, boolean simplePhi, boolean trackFieldVars, boolean trackPhantomPPNodes, boolean trackPhantomExitNodes, boolean trackSsuVersions, boolean doLiveVariableAnalysisRound, boolean trackDirectAssignments, boolean blockFieldPropagation, boolean ssau) {
        this.incrementOnUsage = incrementOnUsage;
        this.simplePhi = simplePhi;
        this.trackFieldVars = trackFieldVars;
        this.trackPhantomPPNodes = trackPhantomPPNodes;
        this.trackPhantomExitNodes = trackPhantomExitNodes;
        this.trackSsuVersions = trackSsuVersions;
        this.doLiveVariableAnalysisRound = doLiveVariableAnalysisRound;
        this.trackDirectAssignments = trackDirectAssignments;
        this.blockFieldPropagation = blockFieldPropagation;
        this.ssau = ssau;
        this.phi = simplePhi ? new HashMap() : null;
        this.mapVersionFirstRange = ssau ? new HashMap() : null;
        this.phantomppnodes = trackPhantomPPNodes ? new HashMap() : null;
        this.phantomexitnodes = trackPhantomExitNodes ? new HashMap() : null;
        this.ssuversions = trackSsuVersions ? new VarVersionsGraph() : null;
        this.mapFieldVars = trackFieldVars ? new HashMap() : null;
        this.varAssignmentMap = trackDirectAssignments ? new HashMap() : null;
        ValidationHelper.assertTrue(!this.doLiveVariableAnalysisRound || this.trackSsuVersions, "doLiveVariableAnalysisRound -> trackSsuVersions: We need ssu versions to do live variable analysis");
        ValidationHelper.assertTrue(!this.incrementOnUsage || this.trackSsuVersions, "incrementOnUsage -> trackSsuVersions: We need ssu versions to be able to increment on usage");
        ValidationHelper.assertTrue(this.incrementOnUsage || this.simplePhi, "!incrementOnUsage -> simplePhi: We need to know if when nodes are already a phi node or not.");
    }

    @Override
    public void splitVariables(RootStatement root, StructMethod mt) {
        DirectGraph dgraph;
        this.root = root;
        this.mt = mt;
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        this.dgraph = dgraph = flatthelper.buildDirectGraph(root);
        ValidationHelper.validateDGraph(dgraph, root);
        ValidationHelper.validateAllVarVersionsAreNull(dgraph, root);
        DotExporter.toDotFile(dgraph, mt, "ssaSplitVariables");
        ArrayList<Integer> setInit = new ArrayList<Integer>();
        for (int i = 0; i < 64; ++i) {
            setInit.add(i);
        }
        this.factory = new FastSparseSetFactory(setInit);
        this.extraVarVersions.put(dgraph.first.id, this.createFirstMap());
        this.setCatchMaps(root, dgraph, flatthelper);
        int iteration = 1;
        HashSet<String> updated = new HashSet<String>();
        do {
            this.ssaStatements(dgraph, updated, false, mt, iteration++);
        } while (!updated.isEmpty());
        if (this.doLiveVariableAnalysisRound) {
            this.ssaStatements(dgraph, updated, true, mt, iteration);
            this.ssuversions.initDominators();
        }
        if (this.trackSsuVersions && this.trackDirectAssignments) {
            ValidationHelper.validateVarVersionsGraph(this.ssuversions, root, this.varAssignmentMap);
        }
    }

    private void ssaStatements(DirectGraph dgraph, HashSet<String> updated, boolean calcLiveVars, StructMethod mt, int iteration) {
        DotExporter.toDotFile(dgraph, mt, "ssaStatements_" + iteration, this.outVarVersions);
        for (DirectNode node : dgraph.nodes) {
            updated.remove(node.id);
            this.mergeInVarMaps(node, dgraph);
            SFormsFastMapDirect varmap = this.inVarVersions.get(node.id);
            VarMapHolder varmaps = VarMapHolder.ofNormal(varmap);
            this.currentCatchableMap = null;
            if (node.hasSuccessors(DirectEdgeType.EXCEPTION)) {
                this.currentCatchableMap = new SFormsFastMapDirect(varmap);
                this.currentCatchableMap.removeAllStacks();
                this.currentCatchableMap.removeAllFields();
                this.catchableVersions.put(node.id, this.currentCatchableMap);
            }
            if (node.type == DirectNodeType.FOREACH_VARDEF && node.exprents.get(0) instanceof VarExprent) {
                this.updateVarExprent((VarExprent)node.exprents.get(0), node.statement, varmaps.getNormal(), calcLiveVars);
            } else if (node.exprents != null) {
                for (Exprent expr : node.exprents) {
                    varmaps.toNormal();
                    this.processExprent(expr, varmaps, node.statement, calcLiveVars);
                }
            }
            if (this.blockFieldPropagation && node.hasSuccessors(DirectEdgeType.REGULAR)) {
                List<DirectEdge> successors = node.getSuccessors(DirectEdgeType.REGULAR);
                if (successors.size() != 1) {
                    varmaps.removeAllFields();
                } else if (successors.get(0).getDestination().hasPredecessors(DirectEdgeType.REGULAR) && successors.get(0).getDestination().getPredecessors(DirectEdgeType.REGULAR).size() != 1) {
                    varmaps.removeAllFields();
                }
            }
            if (!this.hasUpdated(node, varmaps)) continue;
            this.outVarVersions.put(node.id, varmaps.getIfTrue());
            if (dgraph.mapNegIfBranch.containsKey(node.id)) {
                this.outNegVarVersions.put(node.id, varmaps.getIfFalse());
            }
            if (dgraph.extraNodes.contains(node)) continue;
            for (DirectEdge nd : node.getSuccessors(DirectEdgeType.REGULAR)) {
                updated.add(nd.getDestination().id);
            }
            for (DirectEdge nd : node.getSuccessors(DirectEdgeType.EXCEPTION)) {
                updated.add(nd.getDestination().id);
            }
        }
    }

    private void processExprent(Exprent expr, VarMapHolder varMaps, Statement stat, boolean calcLiveVars) {
        if (expr == null) {
            return;
        }
        varMaps.assertIsNormal();
        block0 : switch (expr.type) {
            case IF: {
                IfExprent ifexpr = (IfExprent)expr;
                this.processExprent(ifexpr.getCondition(), varMaps, stat, calcLiveVars);
                return;
            }
            case ASSIGNMENT: {
                AssignmentExprent assexpr = (AssignmentExprent)expr;
                if (assexpr.getCondType() != null) {
                    throw new IllegalStateException("Didn't expect compound assignment yet");
                }
                Exprent dest = assexpr.getLeft();
                switch (dest.type) {
                    case VAR: {
                        VarExprent destVar = (VarExprent)dest;
                        this.processExprent(assexpr.getRight(), varMaps, stat, calcLiveVars);
                        this.updateVarExprent(destVar, stat, varMaps.getNormal(), calcLiveVars);
                        if (this.trackDirectAssignments) {
                            switch (assexpr.getRight().type) {
                                case VAR: {
                                    VarVersionPair rightpaar = ((VarExprent)assexpr.getRight()).getVarVersionPair();
                                    this.varAssignmentMap.put(destVar.getVarVersionPair(), rightpaar);
                                    break;
                                }
                                case FIELD: {
                                    int index = this.mapFieldVars.get(assexpr.getRight().id);
                                    VarVersionPair rightpaar = new VarVersionPair(index, 0);
                                    this.varAssignmentMap.put(destVar.getVarVersionPair(), rightpaar);
                                    break;
                                }
                            }
                        }
                        return;
                    }
                    case FIELD: {
                        this.processExprent(assexpr.getLeft(), varMaps, stat, calcLiveVars);
                        varMaps.assertIsNormal();
                        this.processExprent(assexpr.getRight(), varMaps, stat, calcLiveVars);
                        varMaps.toNormal();
                        if (this.trackFieldVars) {
                            varMaps.getNormal().removeAllFields();
                        }
                        return;
                    }
                }
                this.processExprent(assexpr.getLeft(), varMaps, stat, calcLiveVars);
                varMaps.assertIsNormal();
                this.processExprent(assexpr.getRight(), varMaps, stat, calcLiveVars);
                varMaps.toNormal();
                return;
            }
            case FUNCTION: {
                FunctionExprent func = (FunctionExprent)expr;
                switch (func.getFuncType()) {
                    case TERNARY: {
                        this.processExprent(func.getLstOperands().get(0), varMaps, stat, calcLiveVars);
                        VarMapHolder bVarMaps = VarMapHolder.ofNormal(varMaps.getIfTrue());
                        this.processExprent(func.getLstOperands().get(1), bVarMaps, stat, calcLiveVars);
                        varMaps.setNormal(varMaps.getIfFalse());
                        this.processExprent(func.getLstOperands().get(2), varMaps, stat, calcLiveVars);
                        if (bVarMaps.isNormal() && varMaps.isNormal()) {
                            varMaps.mergeNormal(bVarMaps.getNormal());
                        } else if (!varMaps.isNormal()) {
                            varMaps.mergeIfTrue(bVarMaps.getIfTrue());
                            varMaps.mergeIfFalse(bVarMaps.getIfFalse());
                        } else {
                            bVarMaps.mergeIfTrue(varMaps.getNormal());
                            bVarMaps.mergeIfFalse(varMaps.getNormal());
                            varMaps.set(bVarMaps);
                        }
                        return;
                    }
                    case BOOLEAN_AND: {
                        this.processExprent(func.getLstOperands().get(0), varMaps, stat, calcLiveVars);
                        varMaps.makeFullyMutable();
                        SFormsFastMapDirect ifFalse = varMaps.getIfFalse();
                        varMaps.setNormal(varMaps.getIfTrue());
                        this.processExprent(func.getLstOperands().get(1), varMaps, stat, calcLiveVars);
                        varMaps.mergeIfFalse(ifFalse);
                        return;
                    }
                    case BOOLEAN_OR: {
                        this.processExprent(func.getLstOperands().get(0), varMaps, stat, calcLiveVars);
                        varMaps.makeFullyMutable();
                        SFormsFastMapDirect ifTrue = varMaps.getIfTrue();
                        varMaps.setNormal(varMaps.getIfFalse());
                        this.processExprent(func.getLstOperands().get(1), varMaps, stat, calcLiveVars);
                        varMaps.mergeIfTrue(ifTrue);
                        return;
                    }
                    case BOOL_NOT: {
                        this.processExprent(func.getLstOperands().get(0), varMaps, stat, calcLiveVars);
                        varMaps.swap();
                        return;
                    }
                    case INSTANCEOF: {
                        this.processExprent(func.getLstOperands().get(0), varMaps, stat, calcLiveVars);
                        varMaps.toNormal();
                        if (func.getLstOperands().size() == 3) {
                            varMaps.makeFullyMutable();
                            VarExprent var = (VarExprent)func.getLstOperands().get(2);
                            this.updateVarExprent(var, stat, varMaps.getIfTrue(), calcLiveVars);
                        }
                        return;
                    }
                    case IMM: 
                    case MMI: 
                    case IPP: 
                    case PPI: {
                        this.processExprent(func.getLstOperands().get(0), varMaps, stat, calcLiveVars);
                        SFormsFastMapDirect varmap = varMaps.getNormal();
                        switch (func.getLstOperands().get((int)0).type) {
                            case VAR: {
                                if (!this.trackPhantomPPNodes) {
                                    return;
                                }
                                VarExprent var = (VarExprent)func.getLstOperands().get(0);
                                int varIndex = var.getIndex();
                                VarVersionPair varVersion = new VarVersionPair(varIndex, var.getVersion());
                                VarVersionPair phantomVersion = this.phantomppnodes.get(varVersion);
                                if (phantomVersion == null) {
                                    int nextver = this.getNextFreeVersion(varIndex, null);
                                    phantomVersion = new VarVersionPair(varIndex, nextver);
                                    this.ssuversions.createNode(phantomVersion);
                                    VarVersionNode verNode = this.ssuversions.nodes.getWithKey(varVersion);
                                    FastSparseSetFactory.FastSparseSet<Integer> versions = this.factory.createEmptySet();
                                    if (verNode.preds.size() == 1) {
                                        versions.add(verNode.preds.iterator().next().source.version);
                                    } else {
                                        for (VarVersionEdge edge : verNode.preds) {
                                            versions.add(edge.source.preds.iterator().next().source.version);
                                        }
                                    }
                                    versions.add(nextver);
                                    this.createOrUpdatePhiNode(varVersion, versions, stat);
                                    this.phantomppnodes.put(varVersion, phantomVersion);
                                }
                                if (calcLiveVars) {
                                    this.varMapToGraph(varVersion, varmap);
                                }
                                this.setCurrentVar(varmap, varIndex, var.getVersion());
                                return;
                            }
                            case FIELD: {
                                if (this.trackFieldVars) {
                                    varmap.removeAllFields();
                                }
                                return;
                            }
                        }
                        return;
                    }
                }
                break;
            }
            case FIELD: {
                FieldExprent field = (FieldExprent)expr;
                this.processExprent(field.getInstance(), varMaps, stat, calcLiveVars);
                if (this.trackFieldVars) {
                    int index;
                    if (this.mapFieldVars.containsKey(expr.id)) {
                        index = this.mapFieldVars.get(expr.id);
                    } else {
                        index = this.fieldvarcounter--;
                        this.mapFieldVars.put(expr.id, index);
                        if (this.trackSsuVersions) {
                            this.ssuversions.createNode(new VarVersionPair(index, 1));
                        }
                    }
                    this.setCurrentVar(varMaps.getNormal(), index, 1);
                }
                return;
            }
            case VAR: {
                VarExprent vardest = (VarExprent)expr;
                SFormsFastMapDirect varmap = varMaps.getNormal();
                int varindex = vardest.getIndex();
                int current_vers = vardest.getVersion();
                FastSparseSetFactory.FastSparseSet<Integer> vers = varmap.get(varindex);
                int cardinality = vers != null ? vers.getCardinality() : 0;
                switch (cardinality) {
                    case 0: {
                        this.updateVarExprent(vardest, stat, varmap, calcLiveVars);
                        break block0;
                    }
                    case 1: {
                        if (!this.incrementOnUsage) {
                            int it = vers.iterator().next();
                            vardest.setVersion(it);
                            break block0;
                        }
                        if (current_vers == 0) {
                            int usever = this.getNextFreeVersion(varindex, stat);
                            vardest.setVersion(usever);
                            this.setCurrentVar(varmap, varindex, usever);
                            int lastver = vers.iterator().next();
                            VarVersionNode prenode = this.ssuversions.nodes.getWithKey(new VarVersionPair(varindex, lastver));
                            VarVersionNode usenode = this.ssuversions.createNode(new VarVersionPair(varindex, usever));
                            VarVersionEdge edge = new VarVersionEdge(0, prenode, usenode);
                            prenode.addSuccessor(edge);
                            usenode.addPredecessor(edge);
                            break block0;
                        }
                        if (calcLiveVars) {
                            this.varMapToGraph(new VarVersionPair(varindex, current_vers), varmap);
                        }
                        this.setCurrentVar(varmap, varindex, current_vers);
                        break block0;
                    }
                    case 2: {
                        if (!this.incrementOnUsage) {
                            VarVersionPair varVersion = new VarVersionPair(varindex, current_vers);
                            if (current_vers != 0 && this.phi.containsKey(varVersion)) {
                                this.setCurrentVar(varmap, varindex, current_vers);
                                this.phi.get(varVersion).union(vers);
                                break block0;
                            }
                            int nextver = this.getNextFreeVersion(varindex, stat);
                            vardest.setVersion(nextver);
                            this.setCurrentVar(varmap, varindex, nextver);
                            this.phi.put(new VarVersionPair(varindex, nextver), vers);
                            break block0;
                        }
                        if (current_vers != 0) {
                            if (calcLiveVars) {
                                this.varMapToGraph(new VarVersionPair(varindex, current_vers), varmap);
                            }
                            this.setCurrentVar(varmap, varindex, current_vers);
                        } else {
                            int usever = this.getNextFreeVersion(varindex, stat);
                            vardest.setVersion(usever);
                            this.ssuversions.createNode(new VarVersionPair(varindex, usever));
                            this.setCurrentVar(varmap, varindex, usever);
                            current_vers = usever;
                        }
                        this.createOrUpdatePhiNode(new VarVersionPair(varindex, current_vers), vers, stat);
                    }
                }
            }
        }
        for (Exprent ex : expr.getAllExprents()) {
            this.processExprent(ex, varMaps, stat, calcLiveVars);
            varMaps.toNormal();
        }
        if (this.trackFieldVars && SFormsConstructor.makesFieldsDirty(expr)) {
            varMaps.getNormal().removeAllFields();
        }
    }

    private static boolean makesFieldsDirty(Exprent expr) {
        switch (expr.type) {
            case INVOCATION: {
                return true;
            }
            case NEW: {
                if (((NewExprent)expr).getNewType().type != 8) break;
                return true;
            }
        }
        return false;
    }

    private void updateVarExprent(VarExprent varassign, Statement stat, SFormsFastMapDirect varmap, boolean calcLiveVars) {
        int varindex = varassign.getIndex();
        if (varassign.getVersion() == 0) {
            int nextver = this.getNextFreeVersion(varindex, stat);
            varassign.setVersion(nextver);
            if (this.trackSsuVersions) {
                this.ssuversions.createNode(new VarVersionPair(varindex, nextver), varassign.getLVT());
            }
        } else if (calcLiveVars) {
            this.varMapToGraph(new VarVersionPair(varindex, varassign.getVersion()), varmap);
        }
        this.setCurrentVar(varmap, varindex, varassign.getVersion());
        if (this.currentCatchableMap != null && varindex < 10000 && varindex >= 0) {
            if (this.currentCatchableMap.containsKey(varindex)) {
                this.currentCatchableMap.get(varindex).add(varassign.getVersion());
            } else {
                FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.createEmptySet();
                set.add(varassign.getVersion());
                varmap.put(varindex, set);
            }
        }
    }

    private int getNextFreeVersion(int var, Statement stat) {
        Statement firstRange;
        int nextver = this.lastversion.compute(var, (k, v) -> v == null ? 1 : v + 1);
        if (this.ssau && stat != null && (firstRange = SFormsConstructor.getFirstProtectedRange(stat)) != null) {
            this.mapVersionFirstRange.put(new VarVersionPair(var, nextver), firstRange.id);
        }
        return nextver;
    }

    private void mergeInVarMaps(DirectNode node, DirectGraph dgraph) {
        SFormsFastMapDirect mapOut;
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect();
        for (DirectEdge pred : node.getPredecessors(DirectEdgeType.REGULAR)) {
            mapOut = this.getFilteredOutMap(node.id, pred.getSource().id, dgraph, node.id);
            if (mapNew.isEmpty()) {
                mapNew = mapOut.getCopy();
                continue;
            }
            VarMapHolder.mergeMaps(mapNew, mapOut);
        }
        for (DirectEdge pred : node.getPredecessors(DirectEdgeType.EXCEPTION)) {
            mapOut = this.catchableVersions.get(pred.getSource().id);
            if (mapOut == null) continue;
            if (mapNew.isEmpty()) {
                mapNew = mapOut.getCopy();
                continue;
            }
            VarMapHolder.mergeMaps(mapNew, mapOut);
        }
        if (this.extraVarVersions.containsKey(node.id)) {
            SFormsFastMapDirect mapExtra = this.extraVarVersions.get(node.id);
            if (mapNew.isEmpty()) {
                mapNew = mapExtra.getCopy();
            } else {
                VarMapHolder.mergeMaps(mapNew, mapExtra);
            }
        }
        this.inVarVersions.put(node.id, mapNew);
    }

    private SFormsFastMapDirect getFilteredOutMap(String nodeid, String predid, DirectGraph dgraph, String destid) {
        boolean isFinallyExit;
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect();
        if (nodeid.equals(dgraph.mapNegIfBranch.get(predid))) {
            if (this.outNegVarVersions.containsKey(predid)) {
                mapNew = this.outNegVarVersions.get(predid).getCopy();
            }
        } else if (this.outVarVersions.containsKey(predid)) {
            mapNew = this.outVarVersions.get(predid).getCopy();
        }
        if ((isFinallyExit = dgraph.mapShortRangeFinallyPaths.containsKey(predid)) && !mapNew.isEmpty()) {
            SFormsFastMapDirect mapNewTemp = mapNew.getCopy();
            SFormsFastMapDirect mapTrueSource = new SFormsFastMapDirect();
            String exceptionDest = dgraph.mapFinallyMonitorExceptionPathExits.get(predid);
            boolean isExceptionMonitorExit = exceptionDest != null && !nodeid.equals(exceptionDest);
            HashSet<CallSite> setLongPathWrapper = new HashSet<CallSite>();
            for (FlattenStatementsHelper.FinallyPathWrapper finwraplong : dgraph.mapLongRangeFinallyPaths.get(predid)) {
                setLongPathWrapper.add((CallSite)((Object)(finwraplong.destination + "##" + finwraplong.source)));
            }
            for (FlattenStatementsHelper.FinallyPathWrapper finwrap : dgraph.mapShortRangeFinallyPaths.get(predid)) {
                boolean isFalsePath;
                boolean recFinally = dgraph.mapShortRangeFinallyPaths.containsKey(finwrap.source);
                SFormsFastMapDirect map = recFinally ? this.getFilteredOutMap(finwrap.entry, finwrap.source, dgraph, destid) : (finwrap.entry.equals(dgraph.mapNegIfBranch.get(finwrap.source)) ? this.outNegVarVersions.get(finwrap.source) : this.outVarVersions.get(finwrap.source));
                if (recFinally) {
                    isFalsePath = !finwrap.destination.equals(nodeid);
                } else {
                    boolean bl = isFalsePath = !setLongPathWrapper.contains(destid + "##" + finwrap.source);
                }
                if (isFalsePath) {
                    mapNewTemp.complement(map);
                    continue;
                }
                if (mapTrueSource.isEmpty()) {
                    if (map == null) continue;
                    mapTrueSource = map.getCopy();
                    continue;
                }
                VarMapHolder.mergeMaps(mapTrueSource, map);
            }
            if (isExceptionMonitorExit) {
                mapNew = mapTrueSource;
            } else {
                mapNewTemp.union(mapTrueSource);
                SFormsFastMapDirect oldInMap = this.inVarVersions.get(nodeid);
                if (oldInMap != null) {
                    mapNewTemp.union(oldInMap);
                }
                mapNew.intersection(mapNewTemp);
            }
        }
        return mapNew;
    }

    public static Statement getFirstProtectedRange(Statement stat) {
        Statement parent;
        while ((parent = stat.getParent()) != null) {
            if (parent instanceof CatchAllStatement || parent instanceof CatchStatement ? parent.getFirst() == stat : parent instanceof SynchronizedStatement && ((SynchronizedStatement)parent).getBody() == stat) {
                return parent;
            }
            stat = parent;
        }
        return null;
    }

    private void setCatchMaps(Statement stat, DirectGraph dgraph, FlattenStatementsHelper flatthelper) {
        switch (stat.type) {
            case CATCH_ALL: 
            case TRY_CATCH: {
                List<VarExprent> lstVars = stat instanceof CatchAllStatement ? ((CatchAllStatement)stat).getVars() : ((CatchStatement)stat).getVars();
                for (int i = 1; i < stat.getStats().size(); ++i) {
                    int varindex = lstVars.get(i - 1).getIndex();
                    int version = this.getNextFreeVersion(varindex, stat);
                    SFormsFastMapDirect map = new SFormsFastMapDirect();
                    this.setCurrentVar(map, varindex, version);
                    this.extraVarVersions.put(dgraph.nodes.getWithKey((String)flatthelper.getMapDestinationNodes().get((Object)Integer.valueOf((int)((Statement)stat.getStats().get((int)i)).id))[0]).id, map);
                    if (!this.trackSsuVersions) continue;
                    this.ssuversions.createNode(new VarVersionPair(varindex, version));
                }
                break;
            }
        }
        for (Statement st : stat.getStats()) {
            this.setCatchMaps(st, dgraph, flatthelper);
        }
    }

    private SFormsFastMapDirect createFirstMap() {
        boolean thisvar = !this.mt.hasModifier(8);
        MethodDescriptor md = MethodDescriptor.parseDescriptor(this.mt.getDescriptor());
        int paramcount = md.params.length + (thisvar ? 1 : 0);
        int varindex = 0;
        SFormsFastMapDirect map = new SFormsFastMapDirect();
        for (int i = 0; i < paramcount; ++i) {
            int version = this.getNextFreeVersion(varindex, this.root);
            FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.createEmptySet();
            set.add(version);
            map.put(varindex, set);
            if (this.trackSsuVersions) {
                this.ssuversions.createNode(new VarVersionPair(varindex, version));
            }
            if (thisvar) {
                if (i == 0) {
                    ++varindex;
                    continue;
                }
                varindex += md.params[i - 1].stackSize;
                continue;
            }
            varindex += md.params[i].stackSize;
        }
        return map;
    }

    public HashMap<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> getPhi() {
        return this.phi;
    }

    private void createOrUpdatePhiNode(VarVersionPair phivar, FastSparseSetFactory.FastSparseSet<Integer> vers, Statement stat) {
        HashSet<Integer> removed = new HashSet<Integer>();
        int ppvers = this.phantomppnodes.containsKey(phivar) ? this.phantomppnodes.get((Object)phivar).version : -1;
        VarVersionNode phinode = this.ssuversions.nodes.getWithKey(phivar);
        ArrayList<VarVersionEdge> lstPreds = new ArrayList<VarVersionEdge>(phinode.preds);
        if (lstPreds.size() == 1) {
            VarVersionEdge edge = (VarVersionEdge)lstPreds.get(0);
            edge.source.removeSuccessor(edge);
            phinode.removePredecessor(edge);
        } else {
            for (VarVersionEdge edge : lstPreds) {
                int verssrc = edge.source.preds.iterator().next().source.version;
                if (!vers.contains(verssrc) && verssrc != ppvers) {
                    edge.source.removeSuccessor(edge);
                    phinode.removePredecessor(edge);
                    continue;
                }
                removed.add(verssrc);
            }
        }
        ArrayList<VarVersionNode> colnodes = new ArrayList<VarVersionNode>();
        ArrayList<VarVersionPair> colpaars = new ArrayList<VarVersionPair>();
        for (int ver : vers) {
            if (removed.contains(ver)) continue;
            VarVersionNode prenode = this.ssuversions.nodes.getWithKey(new VarVersionPair(phivar.var, ver));
            int tempver = this.getNextFreeVersion(phivar.var, stat);
            VarVersionNode tempnode = new VarVersionNode(phivar.var, tempver);
            colnodes.add(tempnode);
            colpaars.add(new VarVersionPair(phivar.var, tempver));
            VarVersionEdge edge = new VarVersionEdge(0, prenode, tempnode);
            prenode.addSuccessor(edge);
            tempnode.addPredecessor(edge);
            edge = new VarVersionEdge(0, tempnode, phinode);
            tempnode.addSuccessor(edge);
            phinode.addPredecessor(edge);
        }
        this.ssuversions.addNodes(colnodes, colpaars);
    }

    private void varMapToGraph(VarVersionPair varVersion, SFormsFastMapDirect varMap) {
        ValidationHelper.assertTrue(this.trackSsuVersions, "Can't make an ssu graph without ssu tracked");
        VBStyleCollection<VarVersionNode, VarVersionPair> nodes = this.ssuversions.nodes;
        VarVersionNode node = nodes.getWithKey(varVersion);
        node.live = varMap.getCopy();
    }

    static boolean mapsEqual(SFormsFastMapDirect map1, SFormsFastMapDirect map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> ent2 : map2.entryList()) {
            if (InterpreterUtil.equalObjects(map1.get(ent2.getKey()), ent2.getValue())) continue;
            return false;
        }
        return true;
    }

    void setCurrentVar(SFormsFastMapDirect varmap, int var, int vers) {
        FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.createEmptySet();
        set.add(vers);
        varmap.put(var, set);
    }

    boolean hasUpdated(DirectNode node, VarMapHolder varmaps) {
        return !SFormsConstructor.mapsEqual(varmaps.getIfTrue(), this.outVarVersions.get(node.id)) || this.outNegVarVersions.containsKey(node.id) && !SFormsConstructor.mapsEqual(varmaps.getIfFalse(), this.outNegVarVersions.get(node.id));
    }

    public VarVersionsGraph getSsuVersions() {
        return this.ssuversions;
    }

    public SFormsFastMapDirect getLiveVarVersionsMap(VarVersionPair varVersion) {
        ValidationHelper.assertTrue(this.trackSsuVersions, "Can't get ssu versions if we aren't tracking ssu");
        VarVersionNode node = this.ssuversions.nodes.getWithKey(varVersion);
        if (node != null) {
            return node.live == null ? new SFormsFastMapDirect() : node.live;
        }
        return null;
    }

    public Map<VarVersionPair, Integer> getMapVersionFirstRange() {
        ValidationHelper.assertTrue(this.ssau, "This is an ssau only operation");
        return this.mapVersionFirstRange;
    }

    public Map<Integer, Integer> getMapFieldVars() {
        ValidationHelper.assertTrue(this.trackFieldVars, "Can't provide field data, if no field data was tracked");
        return this.mapFieldVars;
    }

    public Map<VarVersionPair, VarVersionPair> getVarAssignmentMap() {
        ValidationHelper.assertTrue(this.trackDirectAssignments, "Can't provide direct assignments, if no direct assignments was tracked");
        return this.varAssignmentMap;
    }
}

