/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;

public final class SimpleSSAReassign {
    public static Map<Instruction, Integer> reassignSSAForm(SSAConstructorSparseEx ssa, RootStatement root) {
        HashSet vers = new HashSet();
        SimpleSSAReassign.findAllVars(root, (VarExprent var) -> {
            int index = var.getIndex();
            if (index < 10000) {
                vers.add(index);
            }
        });
        int maxVer = DecompilerContext.getCounterContainer().getCounter(2);
        if (vers.isEmpty()) {
            return new HashMap<Instruction, Integer>();
        }
        AtomicInteger counter = new AtomicInteger(maxVer);
        HashMap newVers = new HashMap();
        SimpleSSAReassign.findAllVars(root, (VarExprent var) -> {
            VarVersionPair vvp = var.getVarVersionPair();
            if (vvp.version > 1 && vers.contains(vvp.var) && !newVers.containsKey(vvp)) {
                newVers.put(vvp, counter.incrementAndGet());
            }
        });
        HashMap<Instruction, Integer> rewriteMap = new HashMap<Instruction, Integer>();
        SimpleSSAReassign.findAllVars(root, (VarExprent var) -> {
            VarVersionPair vvp = var.getVarVersionPair();
            if (newVers.containsKey(vvp)) {
                int newIdx = (Integer)newVers.get(vvp);
                var.setIndex(newIdx);
                var.setVersion(1);
                if (var.getBackingInstr() != null) {
                    rewriteMap.put(var.getBackingInstr(), newIdx);
                }
            }
        });
        return rewriteMap;
    }

    private static void findAllVars(Statement stat, Consumer<VarExprent> action) {
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    SimpleSSAReassign.findAllVars((Statement)obj, action);
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                SimpleSSAReassign.findAllVars((Exprent)obj, action);
            }
        } else {
            for (Exprent exprent : stat.getExprents()) {
                SimpleSSAReassign.findAllVars(exprent, action);
            }
        }
    }

    private static void findAllVars(Exprent exprent, Consumer<VarExprent> action) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        for (Exprent expr : lst) {
            if (!(expr instanceof VarExprent)) continue;
            action.accept((VarExprent)expr);
        }
    }
}

