/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;

final class VarMapHolder {
    private SFormsFastMapDirect ifTrue;
    private SFormsFastMapDirect ifFalse;

    private VarMapHolder(SFormsFastMapDirect ifTrue, SFormsFastMapDirect ifFalse) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    static VarMapHolder ofNormal(SFormsFastMapDirect holder) {
        return new VarMapHolder(new SFormsFastMapDirect(holder), null);
    }

    SFormsFastMapDirect getIfTrue() {
        ValidationHelper.assertTrue(this.ifTrue != null && this.ifTrue != this.ifFalse, "VarMapHolder is in an illegal state");
        return this.ifTrue;
    }

    SFormsFastMapDirect getIfFalse() {
        ValidationHelper.assertTrue(this.ifTrue != null && this.ifTrue != this.ifFalse, "VarMapHolder is in an illegal state");
        return this.ifFalse == null ? this.ifTrue : this.ifFalse;
    }

    SFormsFastMapDirect toNormal() {
        SFormsFastMapDirect result = VarMapHolder.mergeMaps(this.ifTrue, this.ifFalse);
        this.ifFalse = null;
        return result;
    }

    SFormsFastMapDirect getNormal() {
        this.assertIsNormal();
        return this.ifTrue;
    }

    void assertIsNormal() {
        ValidationHelper.assertTrue(this.isNormal(), "VarMapHolder is not in normal state");
    }

    void setIfTrue(SFormsFastMapDirect ifTrue) {
        if (this.ifTrue != ifTrue && this.ifFalse == null) {
            this.ifFalse = this.ifTrue;
        } else if (this.ifFalse == ifTrue) {
            this.ifFalse = null;
        }
        this.ifTrue = ifTrue;
    }

    void setIfFalse(SFormsFastMapDirect ifFalse) {
        if (this.ifTrue == ifFalse) {
            this.ifTrue = null;
        } else {
            this.ifFalse = ifFalse;
        }
    }

    void setNormal(SFormsFastMapDirect normal) {
        this.ifFalse = null;
        this.ifTrue = normal;
    }

    public void set(VarMapHolder bVarMaps) {
        this.ifTrue = bVarMaps.ifTrue;
        this.ifFalse = bVarMaps.ifFalse;
    }

    void mergeIfTrue(SFormsFastMapDirect map2) {
        if (this.ifTrue == map2 || map2 == null || map2.isEmpty()) {
            return;
        }
        this.makeFullyMutable();
        this.ifTrue.union(map2);
    }

    void mergeIfFalse(SFormsFastMapDirect map2) {
        if (this.ifFalse == map2 || map2 == null || map2.isEmpty()) {
            return;
        }
        this.makeFullyMutable();
        this.ifFalse.union(map2);
    }

    void mergeNormal(SFormsFastMapDirect map2) {
        this.assertIsNormal();
        if (this.ifTrue == map2 || map2 == null || map2.isEmpty()) {
            return;
        }
        this.ifTrue.union(map2);
    }

    boolean isNormal() {
        return this.ifFalse == null;
    }

    void swap() {
        if (this.ifFalse == null) {
            return;
        }
        SFormsFastMapDirect tmp = this.ifTrue;
        this.ifTrue = this.ifFalse;
        this.ifFalse = tmp;
    }

    void makeFullyMutable() {
        if (this.ifFalse != null) {
            ValidationHelper.assertTrue(this.ifTrue != this.ifFalse, "VarMapHolder is in an illegal state");
            return;
        }
        this.ifFalse = new SFormsFastMapDirect(this.ifTrue);
    }

    static SFormsFastMapDirect mergeMaps(SFormsFastMapDirect mapTo, SFormsFastMapDirect map2) {
        if (mapTo != map2 && map2 != null && !map2.isEmpty()) {
            mapTo.union(map2);
        }
        return mapTo;
    }

    void removeAllFields() {
        if (this.ifFalse != null) {
            this.ifFalse.removeAllFields();
        }
        this.ifTrue.removeAllFields();
    }
}

