/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextBuffer;

public final class CatchStatement
extends Statement {
    private final List<List<String>> exctstrings = new ArrayList<List<String>>();
    private final List<VarExprent> vars = new ArrayList<VarExprent>();
    private final List<Exprent> resources = new ArrayList<Exprent>();

    private CatchStatement() {
        super(Statement.StatementType.TRY_CATCH);
    }

    private CatchStatement(Statement head, Statement next, Set<Statement> setHandlers) {
        this();
        this.first = head;
        this.stats.addWithKey(this.first, this.first.id);
        for (StatEdge edge : head.getSuccessorEdges(2)) {
            Statement stat = edge.getDestination();
            if (!setHandlers.contains(stat)) continue;
            this.stats.addWithKey(stat, stat.id);
            this.exctstrings.add(new ArrayList<String>(edge.getExceptions()));
            this.vars.add(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), new VarType(8, 0, edge.getExceptions().get(0)), DecompilerContext.getVarProcessor()));
        }
        if (next != null) {
            this.post = next;
        }
    }

    public static Statement isHead(Statement head) {
        if (head.getLastBasicType() != Statement.LastBasicType.GENERAL) {
            return null;
        }
        Set<Statement> setHandlers = DecHelper.getUniquePredExceptions(head);
        if (!setHandlers.isEmpty()) {
            int hnextcount = 0;
            Statement next = null;
            List<StatEdge> lstHeadSuccs = head.getSuccessorEdges(0x40000000);
            if (!lstHeadSuccs.isEmpty() && lstHeadSuccs.get(0).getType() == 1) {
                next = lstHeadSuccs.get(0).getDestination();
                hnextcount = 2;
            }
            for (StatEdge edge : head.getSuccessorEdges(2)) {
                Statement stat = edge.getDestination();
                boolean handlerok = true;
                if (edge.getExceptions() != null && setHandlers.contains(stat)) {
                    if (stat.getLastBasicType() != Statement.LastBasicType.GENERAL) {
                        handlerok = false;
                    } else {
                        List<StatEdge> lstStatSuccs = stat.getSuccessorEdges(0x40000000);
                        if (!lstStatSuccs.isEmpty() && lstStatSuccs.get(0).getType() == 1) {
                            Statement statn = lstStatSuccs.get(0).getDestination();
                            if (next == null) {
                                next = statn;
                            } else if (next != statn) {
                                handlerok = false;
                            }
                            if (handlerok) {
                                ++hnextcount;
                            }
                        }
                    }
                } else {
                    handlerok = false;
                }
                if (handlerok) continue;
                setHandlers.remove(stat);
            }
            if (hnextcount != 1 && !setHandlers.isEmpty()) {
                ArrayList<Statement> lst = new ArrayList<Statement>();
                lst.add(head);
                lst.addAll(setHandlers);
                for (Statement st : lst) {
                    if (!st.isMonitorEnter()) continue;
                    return null;
                }
                if (DecHelper.invalidHeadMerge(head)) {
                    return null;
                }
                if (DecHelper.checkStatementExceptions(lst)) {
                    return new CatchStatement(head, next, setHandlers);
                }
            }
        }
        return null;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(this.id).append(":").appendLineSeparator();
        }
        if (this.resources.isEmpty()) {
            buf.appendIndent(indent).append("try {").appendLineSeparator();
        } else {
            buf.appendIndent(indent).append("try (");
            if (this.resources.size() > 1) {
                buf.appendLineSeparator();
                buf.append(ExprProcessor.listToJava(this.resources, indent + 1));
                buf.appendIndent(indent);
            } else {
                buf.append(this.resources.get(0).toJava(indent + 1));
            }
            buf.append(") {").appendLineSeparator();
        }
        buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, true));
        buf.appendIndent(indent).append("}");
        for (int i = 1; i < this.stats.size(); ++i) {
            Integer offset;
            Statement stat = (Statement)this.stats.get(i);
            BasicBlock block = stat.getBasichead().getBlock();
            if (!block.getSeq().isEmpty() && block.getInstruction((int)0).opcode == 58 && (offset = block.getOldOffset(0)) > -1) {
                buf.addBytecodeMapping(offset);
            }
            buf.append(" catch (");
            List<String> exception_types = this.exctstrings.get(i - 1);
            if (exception_types.size() > 1) {
                for (int exc_index = 1; exc_index < exception_types.size(); ++exc_index) {
                    VarType exc_type = new VarType(8, 0, exception_types.get(exc_index));
                    String exc_type_name = ExprProcessor.getCastTypeName(exc_type);
                    buf.append(exc_type_name).append(" | ");
                }
            }
            buf.append(this.vars.get(i - 1).toJava(indent));
            buf.append(") {").appendLineSeparator();
            buf.append(ExprProcessor.jmpWrapper(stat, indent + 1, false)).appendIndent(indent).append("}");
        }
        buf.appendLineSeparator();
        return buf;
    }

    @Override
    public List<Object> getSequentialObjects() {
        ArrayList<Object> lst = new ArrayList<Object>(this.resources);
        lst.addAll(this.stats);
        lst.addAll(this.vars);
        return lst;
    }

    @Override
    public Statement getSimpleCopy() {
        CatchStatement cs = new CatchStatement();
        for (List<String> exc : this.exctstrings) {
            cs.exctstrings.add(new ArrayList<String>(exc));
            cs.vars.add(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), new VarType(8, 0, exc.get(0)), DecompilerContext.getVarProcessor()));
        }
        return cs;
    }

    @Override
    public void getOffset(BitSet values) {
        super.getOffset(values);
        for (Exprent exp : this.getResources()) {
            exp.getBytecodeRange(values);
        }
    }

    public List<List<String>> getExctStrings() {
        return this.exctstrings;
    }

    public List<VarExprent> getVars() {
        return this.vars;
    }

    public List<Exprent> getResources() {
        return this.resources;
    }

    @Override
    public List<VarExprent> getImplicitlyDefinedVars() {
        ArrayList<VarExprent> vars = new ArrayList<VarExprent>(this.getVars());
        for (Exprent exp : this.getResources()) {
            vars.add((VarExprent)((AssignmentExprent)exp).getLeft());
        }
        return vars;
    }
}

