/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.StrongConnectivityHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public abstract class Statement
implements IMatchable {
    public static final int STATEDGE_ALL = Integer.MIN_VALUE;
    public static final int STATEDGE_DIRECT_ALL = 0x40000000;
    private static final int[] EXCEPTION_EDGE_TYPES = new int[]{Integer.MIN_VALUE, 2};
    private static final int[] REGULAR_EDGE_TYPES = new int[]{Integer.MIN_VALUE, 0x40000000};
    public final StatementType type;
    public final int id;
    private final Map<Integer, List<StatEdge>> mapSuccEdges = new HashMap<Integer, List<StatEdge>>();
    private final Map<Integer, List<StatEdge>> mapPredEdges = new HashMap<Integer, List<StatEdge>>();
    protected final VBStyleCollection<Statement, Integer> stats = new VBStyleCollection();
    protected Statement parent;
    protected Statement first;
    protected List<Exprent> exprents;
    protected final HashSet<StatEdge> labelEdges = new HashSet();
    protected final List<Exprent> varDefinitions = new ArrayList<Exprent>();
    private boolean copied = false;
    protected Statement post;
    protected LastBasicType lastBasicType = LastBasicType.GENERAL;
    protected boolean isMonitorEnter;
    protected boolean isLastAthrow;
    protected boolean containsMonitorExit;
    protected HashSet<Statement> continueSet = new HashSet();
    private StartEndPair endpoints;

    protected Statement(StatementType type, int id) {
        this.type = type;
        this.id = id;
    }

    protected Statement(StatementType type) {
        this(type, DecompilerContext.getCounterContainer().getCounterAndIncrement(0));
    }

    public void clearTempInformation() {
        this.post = null;
        this.continueSet = null;
        this.copied = false;
        this.isMonitorEnter = false;
        this.containsMonitorExit = false;
        Statement.processMap(this.mapSuccEdges);
        Statement.processMap(this.mapPredEdges);
    }

    private static <T> void processMap(Map<Integer, List<T>> map) {
        map.remove(2);
        List<T> lst = map.get(0x40000000);
        if (lst != null) {
            map.put(Integer.MIN_VALUE, new ArrayList<T>(lst));
        } else {
            map.remove(Integer.MIN_VALUE);
        }
    }

    public void collapseNodesToStatement(Statement stat) {
        Statement head = stat.getFirst();
        Statement post = stat.getPost();
        VBStyleCollection<Statement, Integer> setNodes = stat.getStats();
        if (post != null) {
            for (StatEdge edge : post.getEdges(0x40000000, EdgeDirection.BACKWARD)) {
                if (!stat.containsStatementStrict(edge.getSource())) continue;
                edge.getSource().changeEdgeType(EdgeDirection.FORWARD, edge, 4);
                stat.addLabeledEdge(edge);
            }
        }
        for (StatEdge prededge : head.getAllPredecessorEdges()) {
            if (prededge.getType() != 2 && stat.containsStatementStrict(prededge.getSource())) {
                prededge.getSource().changeEdgeType(EdgeDirection.FORWARD, prededge, 8);
                stat.addLabeledEdge(prededge);
            }
            head.removePredecessor(prededge);
            prededge.getSource().changeEdgeNode(EdgeDirection.FORWARD, prededge, stat);
            stat.addPredecessor(prededge);
        }
        if (setNodes.containsKey(this.first.id)) {
            this.first = stat;
        }
        HashSet<Statement> setHandlers = new HashSet<Statement>(head.getNeighbours(2, EdgeDirection.FORWARD));
        for (Statement node : setNodes) {
            setHandlers.retainAll(node.getNeighbours(2, EdgeDirection.FORWARD));
        }
        if (!setHandlers.isEmpty()) {
            for (StatEdge edge : head.getEdges(2, EdgeDirection.FORWARD)) {
                Statement handler = edge.getDestination();
                if (!setHandlers.contains(handler) || setNodes.containsKey(handler.id)) continue;
                stat.addSuccessor(new StatEdge(stat, handler, edge.getExceptions()));
            }
            for (Statement node : setNodes) {
                for (StatEdge edge : node.getEdges(2, EdgeDirection.FORWARD)) {
                    if (!setHandlers.contains(edge.getDestination())) continue;
                    node.removeSuccessor(edge);
                }
            }
        }
        if (post != null && !stat.getNeighbours(2, EdgeDirection.FORWARD).contains(post)) {
            stat.addSuccessor(new StatEdge(1, stat, post));
        }
        for (Statement st : setNodes) {
            this.stats.removeWithKey(st.id);
        }
        this.stats.addWithKey(stat, stat.id);
        stat.setAllParent();
        stat.setParent(this);
        stat.buildContinueSet();
        stat.buildMonitorFlags();
        if (stat instanceof SwitchStatement) {
            ((SwitchStatement)stat).sortEdgesAndNodes();
        }
    }

    public void setAllParent() {
        for (Statement st : this.stats) {
            st.setParent(this);
        }
    }

    public void addLabeledEdge(StatEdge edge) {
        if (edge.closure != null) {
            edge.closure.getLabelEdges().remove(edge);
        }
        edge.closure = this;
        this.getLabelEdges().add(edge);
    }

    private void addEdgeDirectInternal(EdgeDirection direction, StatEdge edge, int edgetype) {
        Map<Integer, List<StatEdge>> mapEdges = direction == EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
        mapEdges.computeIfAbsent(edgetype, k -> new ArrayList()).add(edge);
    }

    @Deprecated
    public void addEdgeInternal(EdgeDirection direction, StatEdge edge) {
        int[] arrtypes;
        int type = edge.getType();
        if (type == 2) {
            arrtypes = EXCEPTION_EDGE_TYPES;
        } else {
            arrtypes = REGULAR_EDGE_TYPES;
            this.addEdgeDirectInternal(direction, edge, type);
        }
        for (int edgetype : arrtypes) {
            this.addEdgeDirectInternal(direction, edge, edgetype);
        }
    }

    private void removeEdgeDirectInternal(EdgeDirection direction, StatEdge edge, int edgetype) {
        int index;
        Map<Integer, List<StatEdge>> mapEdges = direction == EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
        List<StatEdge> lst = mapEdges.get(edgetype);
        if (lst != null && (index = lst.indexOf(edge)) >= 0) {
            lst.remove(index);
        }
    }

    @Deprecated
    public void removeEdgeInternal(EdgeDirection direction, StatEdge edge) {
        int[] arrtypes;
        int type = edge.getType();
        if (type == 2) {
            arrtypes = EXCEPTION_EDGE_TYPES;
        } else {
            arrtypes = REGULAR_EDGE_TYPES;
            this.removeEdgeDirectInternal(direction, edge, type);
        }
        for (int edgetype : arrtypes) {
            this.removeEdgeDirectInternal(direction, edge, edgetype);
        }
    }

    public void addPredecessor(StatEdge edge) {
        this.addEdgeInternal(EdgeDirection.BACKWARD, edge);
    }

    public void removePredecessor(StatEdge edge) {
        if (edge == null) {
            return;
        }
        this.removeEdgeInternal(EdgeDirection.BACKWARD, edge);
    }

    public void addSuccessor(StatEdge edge) {
        this.addEdgeInternal(EdgeDirection.FORWARD, edge);
        if (edge.closure != null) {
            edge.closure.getLabelEdges().add(edge);
        }
        edge.getDestination().addPredecessor(edge);
    }

    public void removeSuccessor(StatEdge edge) {
        if (edge == null) {
            return;
        }
        this.removeEdgeInternal(EdgeDirection.FORWARD, edge);
        if (edge.closure != null) {
            edge.closure.getLabelEdges().remove(edge);
        }
        if (edge.getDestination() != null) {
            edge.getDestination().removePredecessor(edge);
        }
    }

    public void removeAllSuccessors(Statement stat) {
        if (stat == null) {
            return;
        }
        for (StatEdge edge : this.getAllSuccessorEdges()) {
            if (edge.getDestination() != stat) continue;
            this.removeSuccessor(edge);
        }
    }

    public HashSet<Statement> buildContinueSet() {
        this.continueSet.clear();
        for (Statement st : this.stats) {
            this.continueSet.addAll(st.buildContinueSet());
            if (st == this.first) continue;
            this.continueSet.remove(st.getBasichead());
        }
        for (StatEdge edge : this.getEdges(8, EdgeDirection.FORWARD)) {
            this.continueSet.add(edge.getDestination().getBasichead());
        }
        if (this instanceof DoStatement) {
            this.continueSet.remove(this.first.getBasichead());
        }
        return this.continueSet;
    }

    public void buildMonitorFlags() {
        for (Statement st : this.stats) {
            st.buildMonitorFlags();
        }
        switch (this.type) {
            case BASIC_BLOCK: {
                BasicBlockStatement bblock = (BasicBlockStatement)this;
                InstructionSequence seq = bblock.getBlock().getSeq();
                if (seq == null || seq.length() <= 0) break;
                for (int i = 0; i < seq.length(); ++i) {
                    if (seq.getInstr((int)i).opcode != 195) continue;
                    this.containsMonitorExit = true;
                    break;
                }
                this.isMonitorEnter = seq.getLastInstr().opcode == 194;
                this.isLastAthrow = seq.getLastInstr().opcode == 191;
                break;
            }
            case SYNCHRONIZED: 
            case ROOT: 
            case GENERAL: {
                break;
            }
            default: {
                this.containsMonitorExit = false;
                this.isLastAthrow = false;
                for (Statement st : this.stats) {
                    this.containsMonitorExit |= st.containsMonitorExit();
                    this.isLastAthrow |= st.isLastAthrow;
                }
            }
        }
    }

    public void markMonitorexitDead() {
        BasicBlockStatement bblock;
        InstructionSequence seq;
        for (Statement st : this.stats) {
            st.markMonitorexitDead();
        }
        if (this instanceof BasicBlockStatement && (seq = (bblock = (BasicBlockStatement)this).getBlock().getSeq()) != null && !seq.isEmpty()) {
            for (int i = 0; i < seq.length(); ++i) {
                if (seq.getInstr((int)i).opcode != 195) continue;
                bblock.setRemovableMonitorexit(true);
                break;
            }
        }
    }

    public List<Statement> getReversePostOrderList() {
        return this.getReversePostOrderList(this.first);
    }

    public List<Statement> getReversePostOrderList(Statement stat) {
        ArrayList<Statement> res = new ArrayList<Statement>();
        Statement.addToReversePostOrderListIterative(stat, res);
        return res;
    }

    public List<Statement> getPostReversePostOrderList() {
        return this.getPostReversePostOrderList(null);
    }

    public List<Statement> getPostReversePostOrderList(List<Statement> lstexits) {
        ArrayList<Statement> res = new ArrayList<Statement>();
        if (lstexits == null) {
            StrongConnectivityHelper schelper = new StrongConnectivityHelper(this);
            lstexits = StrongConnectivityHelper.getExitReps(schelper.getComponents());
        }
        HashSet setVisited = new HashSet();
        for (Statement exit : lstexits) {
            Statement.addToPostReversePostOrderList(exit, res, setVisited);
        }
        if (res.size() != this.stats.size()) {
            throw new RuntimeException("computing post reverse post order failed!");
        }
        return res;
    }

    public boolean containsStatement(Statement stat) {
        return this == stat || this.containsStatementStrict(stat);
    }

    public boolean containsStatementStrict(Statement stat) {
        if (this.stats.contains(stat)) {
            return true;
        }
        for (Statement st : this.stats) {
            if (!st.containsStatementStrict(stat)) continue;
            return true;
        }
        return false;
    }

    public boolean containsStatementById(int statId) {
        return this.id == statId || this.containsStatementStrictById(statId);
    }

    public boolean containsStatementStrictById(int statId) {
        for (Statement stat : this.stats) {
            if (stat.id != statId) continue;
            return true;
        }
        for (Statement st : this.stats) {
            if (!st.containsStatementStrictById(statId)) continue;
            return true;
        }
        return false;
    }

    public TextBuffer toJava() {
        return this.toJava(0);
    }

    public TextBuffer toJava(int indent) {
        throw new RuntimeException("not implemented");
    }

    public List<Object> getSequentialObjects() {
        return new ArrayList<Object>(this.stats);
    }

    public void initExprents() {
    }

    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
    }

    public Statement getSimpleCopy() {
        throw new RuntimeException("not implemented");
    }

    public void initSimpleCopy() {
        if (!this.stats.isEmpty()) {
            this.first = (Statement)this.stats.get(0);
        }
    }

    public final void replaceWith(Statement stat) {
        this.parent.replaceStatement(this, stat);
    }

    public final BasicBlockStatement replaceWithEmpty() {
        BasicBlockStatement newStat = BasicBlockStatement.create();
        this.replaceWith(newStat);
        return newStat;
    }

    public void replaceStatement(Statement oldstat, Statement newstat) {
        if (!this.stats.containsKey(oldstat.id)) {
            throw new IllegalStateException("[" + this + "] Cannot replace " + oldstat + " with " + newstat + " because it wasn't found in " + this.stats);
        }
        for (StatEdge edge : oldstat.getAllPredecessorEdges()) {
            oldstat.removePredecessor(edge);
            edge.getSource().changeEdgeNode(EdgeDirection.FORWARD, edge, newstat);
            newstat.addPredecessor(edge);
        }
        for (StatEdge edge : oldstat.getAllSuccessorEdges()) {
            oldstat.removeSuccessor(edge);
            edge.setSource(newstat);
            newstat.addSuccessor(edge);
        }
        int statindex = this.stats.getIndexByKey(oldstat.id);
        this.stats.removeWithKey(oldstat.id);
        this.stats.addWithKeyAndIndex(statindex, newstat, newstat.id);
        newstat.setParent(this);
        newstat.post = oldstat.post;
        if (this.first == oldstat) {
            this.first = newstat;
        }
        ArrayList<StatEdge> lst = new ArrayList<StatEdge>(oldstat.getLabelEdges());
        for (int i = lst.size() - 1; i >= 0; --i) {
            StatEdge edge = (StatEdge)lst.get(i);
            if (edge.getSource() != newstat) {
                newstat.addLabeledEdge(edge);
                continue;
            }
            if (this == edge.getDestination() || this.containsStatementStrict(edge.getDestination())) {
                edge.closure = null;
                continue;
            }
            this.addLabeledEdge(edge);
        }
        Statement.replaceClosure(this, oldstat, newstat);
        oldstat.getLabelEdges().clear();
    }

    private static void replaceClosure(Statement stat, Statement oldstat, Statement newstat) {
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            if (edge.closure != oldstat) continue;
            edge.closure = newstat;
        }
        for (Statement st : stat.getStats()) {
            Statement.replaceClosure(st, oldstat, newstat);
        }
    }

    public List<VarExprent> getImplicitlyDefinedVars() {
        return null;
    }

    private static void addToReversePostOrderListIterative(Statement root, List<? super Statement> lst) {
        LinkedList<Statement> stackNode = new LinkedList<Statement>();
        LinkedList<Integer> stackIndex = new LinkedList<Integer>();
        HashSet<Statement> setVisited = new HashSet<Statement>();
        stackNode.add(root);
        stackIndex.add(0);
        while (!stackNode.isEmpty()) {
            int index;
            Statement node = (Statement)stackNode.getLast();
            setVisited.add(node);
            List lstEdges = node.mapSuccEdges.computeIfAbsent(Integer.MIN_VALUE, k -> new ArrayList());
            for (index = ((Integer)stackIndex.removeLast()).intValue(); index < lstEdges.size(); ++index) {
                StatEdge edge = (StatEdge)lstEdges.get(index);
                Statement succ = edge.getDestination();
                if (setVisited.contains(succ) || edge.getType() != 1 && edge.getType() != 2) continue;
                stackIndex.add(index + 1);
                stackNode.add(succ);
                stackIndex.add(0);
                break;
            }
            if (index != lstEdges.size()) continue;
            lst.add(0, node);
            stackNode.removeLast();
        }
    }

    private static void addToPostReversePostOrderList(Statement stat, List<? super Statement> lst, HashSet<? super Statement> setVisited) {
        Statement pred;
        if (setVisited.contains(stat)) {
            return;
        }
        setVisited.add(stat);
        for (StatEdge prededge : stat.mapPredEdges.computeIfAbsent(1, t -> new ArrayList())) {
            pred = prededge.getSource();
            if (setVisited.contains(pred)) continue;
            Statement.addToPostReversePostOrderList(pred, lst, setVisited);
        }
        for (StatEdge prededge : stat.mapPredEdges.computeIfAbsent(2, t -> new ArrayList())) {
            pred = prededge.getSource();
            if (setVisited.contains(pred)) continue;
            Statement.addToPostReversePostOrderList(pred, lst, setVisited);
        }
        lst.add(0, stat);
    }

    public void changeEdgeNode(EdgeDirection direction, StatEdge edge, Statement value) {
        if (direction == EdgeDirection.BACKWARD) {
            edge.setSource(value);
        } else {
            edge.setDestination(value);
        }
    }

    public void changeEdgeType(EdgeDirection direction, StatEdge edge, int newtype) {
        int oldtype = edge.getType();
        if (oldtype == newtype) {
            return;
        }
        if (oldtype == 2 || newtype == 2) {
            throw new RuntimeException("Invalid edge type!");
        }
        this.removeEdgeDirectInternal(direction, edge, oldtype);
        this.addEdgeDirectInternal(direction, edge, newtype);
        if (direction == EdgeDirection.FORWARD) {
            edge.getDestination().changeEdgeType(EdgeDirection.BACKWARD, edge, newtype);
        }
        edge.setType(newtype);
    }

    private List<StatEdge> getEdges(int type, EdgeDirection direction) {
        List<Object> res;
        Map<Integer, List<StatEdge>> map;
        Map<Integer, List<StatEdge>> map2 = map = direction == EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
        if ((type & type - 1) == 0) {
            res = map.get(type);
            res = res == null ? new ArrayList() : new ArrayList(res);
        } else {
            res = new ArrayList();
            for (int edgetype : StatEdge.TYPES) {
                List<StatEdge> lst;
                if ((type & edgetype) == 0 || (lst = map.get(edgetype)) == null) continue;
                res.addAll(lst);
            }
        }
        return res;
    }

    public List<Statement> getNeighbours(int type, EdgeDirection direction) {
        ArrayList<Statement> res;
        block4: {
            Map<Integer, List<StatEdge>> map;
            block3: {
                map = direction == EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
                res = new ArrayList<Statement>();
                if ((type & type - 1) != 0) break block3;
                List<StatEdge> statEdges = map.get(type);
                if (statEdges == null) break block4;
                for (StatEdge edge : statEdges) {
                    res.add(direction == EdgeDirection.FORWARD ? edge.getDestination() : edge.getSource());
                }
                break block4;
            }
            res = new ArrayList();
            for (int edgetype : StatEdge.TYPES) {
                List<StatEdge> lst;
                if ((type & edgetype) == 0 || (lst = map.get(edgetype)) == null) continue;
                for (StatEdge edge : lst) {
                    res.add(direction == EdgeDirection.FORWARD ? edge.getDestination() : edge.getSource());
                }
            }
        }
        return res;
    }

    public Set<Statement> getNeighboursSet(int type, EdgeDirection direction) {
        return new HashSet<Statement>(this.getNeighbours(type, direction));
    }

    public List<StatEdge> getSuccessorEdges(int type) {
        return this.getEdges(type, EdgeDirection.FORWARD);
    }

    public List<StatEdge> getSuccessorEdgeView(int type) {
        return this.mapSuccEdges.computeIfAbsent(type, k -> new ArrayList());
    }

    public List<StatEdge> getPredecessorEdges(int type) {
        return this.getEdges(type, EdgeDirection.BACKWARD);
    }

    public List<StatEdge> getAllSuccessorEdges() {
        return this.getEdges(Integer.MIN_VALUE, EdgeDirection.FORWARD);
    }

    public boolean hasAnySuccessor() {
        return this.hasSuccessor(Integer.MIN_VALUE);
    }

    public boolean hasSuccessor(int type) {
        Map<Integer, List<StatEdge>> map = this.mapSuccEdges;
        boolean res = false;
        if ((type & type - 1) == 0) {
            List<StatEdge> edges = map.get(type);
            res = edges != null && !edges.isEmpty();
        } else {
            for (int edgetype : StatEdge.TYPES) {
                List<StatEdge> lst;
                if ((type & edgetype) == 0 || (lst = map.get(edgetype)) == null) continue;
                boolean bl = res = !lst.isEmpty();
                if (!res) continue;
                return true;
            }
        }
        return res;
    }

    public StatEdge getFirstSuccessor() {
        Iterator<StatEdge> iterator;
        ValidationHelper.successorsExist(this);
        List<StatEdge> res = this.mapSuccEdges.get(Integer.MIN_VALUE);
        if (res != null && (iterator = res.iterator()).hasNext()) {
            StatEdge e = iterator.next();
            return e;
        }
        throw new IllegalStateException("No successor exists for " + this);
    }

    public List<StatEdge> getAllPredecessorEdges() {
        return this.getEdges(Integer.MIN_VALUE, EdgeDirection.BACKWARD);
    }

    public Statement getFirst() {
        return this.first;
    }

    public void setFirst(Statement first) {
        this.first = first;
    }

    public Statement getPost() {
        return this.post;
    }

    public VBStyleCollection<Statement, Integer> getStats() {
        return this.stats;
    }

    public LastBasicType getLastBasicType() {
        return this.lastBasicType;
    }

    public HashSet<Statement> getContinueSet() {
        return this.continueSet;
    }

    public boolean containsMonitorExit() {
        return this.containsMonitorExit;
    }

    public boolean containsMonitorExitOrAthrow() {
        return this.containsMonitorExit || this.isLastAthrow;
    }

    public boolean isMonitorEnter() {
        return this.isMonitorEnter;
    }

    public BasicBlockStatement getBasichead() {
        if (this instanceof BasicBlockStatement) {
            return (BasicBlockStatement)this;
        }
        return this.first.getBasichead();
    }

    public boolean isLabeled() {
        for (StatEdge edge : this.labelEdges) {
            if (!edge.labeled || !edge.explicit) continue;
            return true;
        }
        return false;
    }

    public boolean hasBasicSuccEdge() {
        switch (this.type) {
            case BASIC_BLOCK: {
                return true;
            }
            case IF: {
                return ((IfStatement)this).iftype == 0;
            }
            case DO: {
                return ((DoStatement)this).getLooptype() != DoStatement.Type.INFINITE;
            }
        }
        return false;
    }

    public Statement getParent() {
        return this.parent;
    }

    public void setParent(Statement parent) {
        this.parent = parent;
    }

    public RootStatement getTopParent() {
        Statement ret = this;
        while (ret.getParent() != null) {
            ret = ret.getParent();
        }
        if (!(ret instanceof RootStatement)) {
            throw new IllegalStateException("Top parent is not a root statement! Malformed IR?");
        }
        return (RootStatement)ret;
    }

    public HashSet<StatEdge> getLabelEdges() {
        return this.labelEdges;
    }

    public List<Exprent> getVarDefinitions() {
        return this.varDefinitions;
    }

    public List<Exprent> getExprents() {
        return this.exprents;
    }

    public void setExprents(List<Exprent> exprents) {
        this.exprents = exprents;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public void setCopied(boolean copied) {
        this.copied = copied;
    }

    public String toString() {
        return "{" + this.type.prettyId + "}:" + this.id;
    }

    public void getOffset(BitSet values) {
        if (this instanceof DummyExitStatement && ((DummyExitStatement)this).bytecode != null) {
            values.or(((DummyExitStatement)this).bytecode);
        }
        if (this.getExprents() != null) {
            for (Exprent e : this.getExprents()) {
                e.getBytecodeRange(values);
            }
        } else {
            for (Object obj : this.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    ((Statement)obj).getOffset(values);
                    continue;
                }
                if (obj instanceof Exprent) {
                    ((Exprent)obj).getBytecodeRange(values);
                    continue;
                }
                if (obj == null) continue;
                DecompilerContext.getLogger().writeMessage("Found unknown class from sequential objects! " + obj.getClass(), IFernflowerLogger.Severity.ERROR);
            }
        }
    }

    public StartEndPair getStartEndRange() {
        if (this.endpoints == null) {
            BitSet set = new BitSet();
            this.getOffset(set);
            this.endpoints = new StartEndPair(set.nextSetBit(0), set.length() - 1);
        }
        return this.endpoints;
    }

    @Override
    public IMatchable findObject(MatchNode matchNode, int index) {
        int node_type = matchNode.getType();
        if (node_type == 0 && !this.stats.isEmpty()) {
            String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.STATEMENT_POSITION);
            if (position != null) {
                if (position.matches("-?\\d+")) {
                    return (IMatchable)this.stats.get((this.stats.size() + Integer.parseInt(position)) % this.stats.size());
                }
            } else if (index < this.stats.size()) {
                return (IMatchable)this.stats.get(index);
            }
        } else if (node_type == 1 && this.exprents != null && !this.exprents.isEmpty()) {
            String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_POSITION);
            if (position != null) {
                if (position.matches("-?\\d+")) {
                    return this.exprents.get((this.exprents.size() + Integer.parseInt(position)) % this.exprents.size());
                }
            } else if (index < this.exprents.size()) {
                return this.exprents.get(index);
            }
        }
        return null;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (matchNode.getType() != 0) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            switch (rule.getKey()) {
                case STATEMENT_TYPE: {
                    if (this.type == rule.getValue().value) break;
                    return false;
                }
                case STATEMENT_STATSIZE: {
                    if (this.stats.size() == ((Integer)rule.getValue().value).intValue()) break;
                    return false;
                }
                case STATEMENT_EXPRSIZE: {
                    int exprsize = (Integer)rule.getValue().value;
                    if (!(exprsize == -1 ? this.exprents != null : this.exprents == null || this.exprents.size() != exprsize)) break;
                    return false;
                }
                case STATEMENT_RET: {
                    if (engine.checkAndSetVariableValue((String)rule.getValue().value, this)) break;
                    return false;
                }
            }
        }
        return true;
    }

    public static enum LastBasicType {
        IF,
        SWITCH,
        GENERAL;

    }

    public static enum EdgeDirection {
        BACKWARD,
        FORWARD;

    }

    public static enum StatementType {
        ROOT("Root"),
        BASIC_BLOCK("Block"),
        SEQUENCE("Seq"),
        DUMMY_EXIT("Exit"),
        GENERAL("General"),
        IF("If"),
        DO("Do"),
        SWITCH("Switch"),
        SYNCHRONIZED("Monitor"),
        TRY_CATCH("Catch"),
        CATCH_ALL("CatchAll");

        private final String prettyId;

        private StatementType(String prettyId) {
            this.prettyId = prettyId;
        }
    }
}

