/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;

public class ContextUnit {
    private final IContextSource source;
    private final boolean own;
    private final boolean root;
    private final IResultSaver resultSaver;
    private final IDecompiledData decompiledData;
    private volatile boolean entriesInitialized;
    private List<String> classEntries = List.of();
    private List<String> dirEntries = List.of();
    private List<IContextSource.Entry> otherEntries = List.of();
    private List<IContextSource> childContexts = List.of();

    public ContextUnit(IContextSource source, boolean own, boolean root, IResultSaver resultSaver, IDecompiledData decompiledData) {
        this.source = source;
        this.own = own;
        this.root = root;
        this.resultSaver = resultSaver;
        this.decompiledData = decompiledData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEntries() {
        if (!this.entriesInitialized) {
            ContextUnit contextUnit = this;
            synchronized (contextUnit) {
                if (!this.entriesInitialized) {
                    IContextSource.Entries entries = this.source.getEntries();
                    this.classEntries = entries.classes().stream().filter(ent -> ent.multirelease() == -1).map(entry -> entry.basePath()).collect(Collectors.toUnmodifiableList());
                    this.dirEntries = entries.directories();
                    boolean includeExtras = !DecompilerContext.getOption("sef");
                    this.otherEntries = new ArrayList<IContextSource.Entry>();
                    for (IContextSource.Entry entry2 : entries.others()) {
                        if ("fernflower_abstract_parameter_names.txt".equals(entry2.basePath())) {
                            try (InputStream is = this.source.getInputStream(entry2);){
                                byte[] data = is.readAllBytes();
                                DecompilerContext.getStructContext().loadAbstractMetadata(new String(data, StandardCharsets.UTF_8));
                            }
                            catch (IOException ex) {
                                DecompilerContext.getLogger().writeMessage("Failed to load abstract parameter names file", IFernflowerLogger.Severity.ERROR, ex);
                            }
                            continue;
                        }
                        if (!includeExtras) continue;
                        this.otherEntries.add(entry2);
                    }
                    this.childContexts = entries.childContexts();
                    this.entriesInitialized = true;
                }
            }
        }
    }

    public List<String> getClassNames() {
        this.initEntries();
        return this.classEntries;
    }

    public byte[] getClassBytes(String className) throws IOException {
        return this.source.getClassBytes(className);
    }

    public List<String> getDirectoryNames() {
        this.initEntries();
        return this.dirEntries;
    }

    public List<IContextSource.Entry> getOtherEntries() {
        this.initEntries();
        return this.otherEntries;
    }

    public List<IContextSource> getChildContexts() {
        this.initEntries();
        return this.childContexts;
    }

    public String getName() {
        return this.source.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        ContextUnit contextUnit = this;
        synchronized (contextUnit) {
            this.entriesInitialized = false;
            this.classEntries = List.of();
            this.dirEntries = List.of();
            this.otherEntries = List.of();
        }
    }

    public void save(Function<String, StructClass> loader) throws IOException {
        this.initEntries();
        IContextSource.IOutputSink sink = this.source.createOutputSink(this.resultSaver);
        if (sink == null) {
            throw new IllegalStateException("Context source " + this.source + " cannot be saved, but had a save requested.");
        }
        sink.begin();
        for (String dirEntry : this.dirEntries) {
            sink.acceptDirectory(dirEntry);
        }
        for (IContextSource.Entry otherEntry : this.otherEntries) {
            sink.acceptOther(otherEntry.path());
        }
        LinkedList futures = new LinkedList();
        ExecutorService decompileExecutor = Executors.newFixedThreadPool(Integer.parseInt((String)DecompilerContext.getProperty("thr")));
        DecompilerContext rootContext = DecompilerContext.getCurrentContext();
        ClassContext[] toDump = new ClassContext[this.classEntries.size()];
        for (int i = 0; i < this.classEntries.size(); ++i) {
            StructClass structClass = loader.apply(this.classEntries.get(i));
            String entryName = this.decompiledData.getClassEntryName(structClass, this.classEntries.get(i));
            if (entryName == null) continue;
            int finalI = i;
            futures.add(decompileExecutor.submit(() -> {
                this.setContext(rootContext);
                String content = this.decompiledData.getClassContent(cl);
                int[] mapping = null;
                if (DecompilerContext.getOption("bsm")) {
                    mapping = DecompilerContext.getBytecodeSourceMapper().getOriginalLinesMapping();
                }
                toDump[finalI] = new ClassContext(cl.qualifiedName, entryName, content, mapping);
            }));
        }
        decompileExecutor.shutdown();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        for (ClassContext cls : toDump) {
            if (cls == null) continue;
            sink.acceptClass(cls.qualifiedName, cls.entryName, cls.classContent, cls.mapping);
        }
        sink.close();
    }

    public void setContext(DecompilerContext rootContext) {
        DecompilerContext current = DecompilerContext.getCurrentContext();
        if (current == null) {
            current = new DecompilerContext(new HashMap<String, Object>(rootContext.properties), rootContext.logger, rootContext.structContext, rootContext.classProcessor, rootContext.poolInterceptor, rootContext.renamerFactory);
            DecompilerContext.setCurrentContext(current);
        }
    }

    public boolean isOwn() {
        return this.own;
    }

    public boolean isRoot() {
        return this.root;
    }

    void close() throws Exception {
        if (this.source instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.source)).close();
        }
        this.clear();
    }

    static final class ClassContext {
        private final String qualifiedName;
        private final String entryName;
        private final String classContent;
        private final int[] mapping;

        ClassContext(String qualifiedName, String entryName, String classContent, int[] mapping) {
            this.qualifiedName = qualifiedName;
            this.entryName = entryName;
            this.classContent = classContent;
            this.mapping = mapping;
        }
    }
}

