/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.ContextUnit;
import org.jetbrains.java.decompiler.struct.DirectoryContextSource;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.JarContextSource;
import org.jetbrains.java.decompiler.struct.SingleFileContextSource;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructContext {
    private static volatile StructClass SENTINEL_CLASS;
    private final IBytecodeProvider legacyProvider;
    private final IResultSaver saver;
    private final IDecompiledData decompiledData;
    private final List<ContextUnit> units = new ArrayList<ContextUnit>();
    private final Map<String, StructClass> classes = new ConcurrentHashMap<String, StructClass>();
    private final Map<String, ContextUnit> unitsByClassName = new ConcurrentHashMap<String, ContextUnit>();
    private final Map<String, List<String>> abstractNames = new HashMap<String, List<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static StructClass getSentinel() {
        if (SENTINEL_CLASS != null) return SENTINEL_CLASS;
        Class<StructContext> clazz = StructContext.class;
        synchronized (StructContext.class) {
            if (SENTINEL_CLASS != null) return SENTINEL_CLASS;
            try (InputStream stream = StructContext.class.getResourceAsStream("StructContext.class");){
                byte[] data = stream.readAllBytes();
                SENTINEL_CLASS = StructClass.create(new DataInputFullStream(data), false);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SENTINEL_CLASS;
        }
    }

    public StructContext(IBytecodeProvider legacyProvider, IResultSaver saver, IDecompiledData decompiledData) {
        this.legacyProvider = legacyProvider;
        this.saver = saver;
        this.decompiledData = decompiledData;
    }

    public StructContext(IResultSaver saver, IDecompiledData decompiledData) {
        this.legacyProvider = null;
        this.saver = saver;
        this.decompiledData = decompiledData;
    }

    public StructClass getClass(String name) {
        if (name == null) {
            return null;
        }
        StructClass ret = this.classes.computeIfAbsent(name, key -> {
            ContextUnit unitForClass = this.unitsByClassName.get(key);
            if (unitForClass != null) {
                try {
                    DecompilerContext.getLogger().writeMessage("Loading Class: " + key + " from " + unitForClass.getName(), IFernflowerLogger.Severity.INFO);
                    StructClass clazz = StructClass.create(new DataInputFullStream(unitForClass.getClassBytes((String)key)), unitForClass.isOwn());
                    if (!key.equals(clazz.qualifiedName)) {
                        this.classes.put(clazz.qualifiedName, clazz);
                    }
                    return clazz;
                }
                catch (IOException ex) {
                    DecompilerContext.getLogger().writeMessage("Failed to read class " + key + " from " + unitForClass.getName(), IFernflowerLogger.Severity.ERROR, ex);
                }
            }
            return StructContext.getSentinel();
        });
        return ret == StructContext.getSentinel() ? null : ret;
    }

    public boolean hasClass(String name) {
        return this.unitsByClassName.containsKey(name);
    }

    public List<StructClass> getOwnClasses() {
        return this.units.stream().filter(ContextUnit::isOwn).flatMap(unit -> unit.getClassNames().stream()).map(name -> Objects.requireNonNull(this.getClass((String)name), () -> "Could not find class " + name)).collect(Collectors.toUnmodifiableList());
    }

    public void reloadContext() throws IOException {
        this.classes.clear();
        this.unitsByClassName.clear();
        this.abstractNames.clear();
        List<ContextUnit> units = List.copyOf(this.units);
        this.units.clear();
        for (ContextUnit unit : units) {
            if (!unit.isRoot()) continue;
            unit.clear();
            this.units.add(unit);
            this.initUnit(unit);
        }
    }

    public void saveContext() {
        for (ContextUnit unit : this.units) {
            if (!unit.isOwn()) continue;
            try {
                unit.save(this::getClass);
            }
            catch (IOException ex) {
                DecompilerContext.getLogger().writeMessage("Failed to save data for context unit" + unit.getName(), IFernflowerLogger.Severity.ERROR, ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isJarFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName();
        if (name.endsWith(".jar")) return true;
        if (name.endsWith(".zip")) {
            return true;
        }
        if (name.endsWith(".class")) {
            return false;
        }
        try (SeekableByteChannel channel = Files.newByteChannel(file.toPath(), new OpenOption[0]);){
            long size = channel.size();
            if (size < 22L) {
                boolean bl = false;
                return bl;
            }
            int bufferSize = (int)Math.min(size & 0xFFFFFFFFFFFFFFFCL, 1024L);
            channel.position(size - (long)bufferSize);
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
            for (int read = 0; read < bufferSize; read += channel.read(buffer)) {
            }
            buffer.flip();
            int pos = buffer.limit() - 22;
            while (pos >= 0) {
                if (buffer.getInt(pos) == 101010256) {
                    boolean bl = true;
                    return bl;
                }
                --pos;
            }
            return false;
        }
        catch (IOException e) {
            DecompilerContext.getLogger().writeMessage("Could not determine if " + file + " contains a JAR file", IFernflowerLogger.Severity.WARN, e);
        }
        return false;
    }

    public void addSpace(File file, boolean isOwn) {
        if (file.isDirectory()) {
            this.addSpace(new DirectoryContextSource(this.legacyProvider, file), isOwn);
        } else {
            if (StructContext.isJarFile(file)) {
                try {
                    this.addSpace(new JarContextSource(this.legacyProvider, file), isOwn);
                }
                catch (IOException ex) {
                    String message = "Invalid archive " + file;
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.ERROR, ex);
                    throw new UncheckedIOException(message, ex);
                }
            }
            try {
                this.addSpace(new SingleFileContextSource(this.legacyProvider, file), isOwn);
            }
            catch (IOException ex) {
                String message = "Invalid file " + file;
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.ERROR, ex);
                throw new UncheckedIOException(message, ex);
            }
        }
    }

    public void addSpace(IContextSource source, boolean isOwn) {
        this.addSpace(source, isOwn, true);
    }

    private void addSpace(IContextSource source, boolean isOwn, boolean isRoot) {
        ContextUnit unit = new ContextUnit(source, isOwn, isRoot, this.saver, this.decompiledData);
        this.units.add(unit);
        this.initUnit(unit);
    }

    private void initUnit(ContextUnit unit) {
        DecompilerContext.getLogger().writeMessage("Scanning classes from " + unit.getName(), IFernflowerLogger.Severity.INFO);
        boolean isOwn = unit.isOwn();
        for (String clazz : unit.getClassNames()) {
            ContextUnit existing = this.unitsByClassName.putIfAbsent(clazz, unit);
            if (existing != null && (!isOwn || existing.isOwn() || !this.unitsByClassName.replace(clazz, existing, unit))) continue;
            DecompilerContext.getLogger().writeMessage("    " + clazz, IFernflowerLogger.Severity.TRACE);
            if (!isOwn) continue;
            this.getClass(clazz);
        }
        for (IContextSource child : unit.getChildContexts()) {
            this.addSpace(child, isOwn, false);
        }
    }

    public boolean instanceOf(String valclass, String refclass) {
        if (valclass.equals(refclass)) {
            return true;
        }
        StructClass cl = this.getClass(valclass);
        if (cl == null) {
            return false;
        }
        if (cl.superClass != null && this.instanceOf(cl.superClass.getString(), refclass)) {
            return true;
        }
        int[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String intfc = cl.getPool().getPrimitiveConstant(interfaces[i]).getString();
            if (!this.instanceOf(intfc, refclass)) continue;
            return true;
        }
        return false;
    }

    public StructClass getFirstCommonClass(String firstclass, String secondclass) {
        StructClass fcls = this.getClass(firstclass);
        StructClass scls = this.getClass(secondclass);
        if (fcls != null && scls != null) {
            List<StructClass> clsList = scls.getAllSuperClasses();
            while (fcls != null) {
                if (clsList.contains(fcls)) {
                    return fcls;
                }
                fcls = fcls.superClass == null ? null : this.getClass(fcls.superClass.getString());
            }
        }
        return null;
    }

    public void loadAbstractMetadata(String string) {
        for (String line : string.split("\n")) {
            String[] pts = line.split(" ");
            if (pts.length < 4) continue;
            GenericMethodDescriptor desc = GenericMain.parseMethodSignature(pts[2]);
            ArrayList<String> params = new ArrayList<String>();
            for (int x = 0; x < pts.length - 3; ++x) {
                for (int y = 0; y < desc.parameterTypes.get((int)x).stackSize; ++y) {
                    params.add(pts[x + 3]);
                }
            }
            this.abstractNames.put(pts[0] + " " + pts[1] + " " + pts[2], params);
        }
    }

    public String renameAbstractParameter(String className, String methodName, String descriptor, int index, String _default) {
        List<String> params = this.abstractNames.get(className + " " + methodName + " " + descriptor);
        return params != null && index < params.size() ? params.get(index) : _default;
    }

    public void clear() {
        try {
            this.saver.close();
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Failed to close out result saver", IFernflowerLogger.Severity.ERROR, ex);
        }
        for (ContextUnit unit : this.units) {
            try {
                unit.close();
            }
            catch (Exception ex) {
                DecompilerContext.getLogger().writeMessage("Failed to close context unit " + unit.getName(), IFernflowerLogger.Severity.ERROR, ex);
            }
        }
        this.units.clear();
        this.unitsByClassName.clear();
        this.classes.clear();
    }
}

