/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.match;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchNode;

public class MatchEngine {
    private static final Map<String, IMatchable.MatchProperties> stat_properties = new HashMap<String, IMatchable.MatchProperties>();
    private static final Map<String, IMatchable.MatchProperties> expr_properties = new HashMap<String, IMatchable.MatchProperties>();
    private static final Map<String, Statement.StatementType> stat_type = new HashMap<String, Statement.StatementType>();
    private static final Map<String, Exprent.Type> expr_type = new HashMap<String, Exprent.Type>();
    private static final Map<String, FunctionExprent.FunctionType> expr_func_type = new HashMap<String, FunctionExprent.FunctionType>();
    private static final Map<String, ExitExprent.Type> expr_exit_type = new HashMap<String, ExitExprent.Type>();
    private static final Map<String, Integer> stat_if_type = new HashMap<String, Integer>();
    private static final Map<String, VarType> expr_const_type = new HashMap<String, VarType>();
    private final MatchNode rootNode;
    private final Map<String, Object> variables = new HashMap<String, Object>();

    public MatchEngine(String description) {
        String[] lines = description.split("\n");
        int depth = 0;
        LinkedList<MatchNode> stack = new LinkedList<MatchNode>();
        for (String line : lines) {
            int new_depth;
            ArrayList<String> properties = new ArrayList<String>(Arrays.asList(line.split("\\s+")));
            if (((String)properties.get(0)).isEmpty()) {
                properties.remove(0);
            }
            int node_type = "statement".equals(properties.get(0)) ? 0 : 1;
            MatchNode matchNode = new MatchNode(node_type);
            for (int i = 1; i < properties.size(); ++i) {
                Object value;
                String[] values;
                IMatchable.MatchProperties property = (node_type == 0 ? stat_properties : expr_properties).get((values = ((String)properties.get(i)).split(":"))[0]);
                if (property == null) {
                    throw new RuntimeException("Unknown matching property");
                }
                int parameter = 0;
                String strValue = values[1];
                if (values.length == 3) {
                    parameter = Integer.parseInt(values[1]);
                    strValue = values[2];
                }
                switch (property) {
                    case STATEMENT_TYPE: {
                        value = stat_type.get(strValue);
                        break;
                    }
                    case STATEMENT_STATSIZE: 
                    case STATEMENT_EXPRSIZE: {
                        value = Integer.valueOf(strValue);
                        break;
                    }
                    case STATEMENT_POSITION: 
                    case EXPRENT_POSITION: 
                    case EXPRENT_INVOCATION_CLASS: 
                    case EXPRENT_INVOCATION_SIGNATURE: 
                    case EXPRENT_INVOCATION_PARAMETER: 
                    case EXPRENT_VAR_INDEX: 
                    case EXPRENT_FIELD_NAME: 
                    case EXPRENT_CONSTVALUE: 
                    case STATEMENT_RET: 
                    case EXPRENT_RET: {
                        value = strValue;
                        break;
                    }
                    case STATEMENT_IFTYPE: {
                        value = stat_if_type.get(strValue);
                        break;
                    }
                    case EXPRENT_FUNCTYPE: {
                        value = expr_func_type.get(strValue);
                        break;
                    }
                    case EXPRENT_EXITTYPE: {
                        value = expr_exit_type.get(strValue);
                        break;
                    }
                    case EXPRENT_CONSTTYPE: {
                        value = expr_const_type.get(strValue);
                        break;
                    }
                    case EXPRENT_TYPE: {
                        value = expr_type.get(strValue);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled matching property");
                    }
                }
                matchNode.addRule(property, new MatchNode.RuleValue(parameter, value));
            }
            if (stack.isEmpty()) {
                stack.push(matchNode);
                continue;
            }
            for (int i = new_depth = line.lastIndexOf(32, depth) + 1; i <= depth; ++i) {
                stack.pop();
            }
            ((MatchNode)stack.getFirst()).addChild(matchNode);
            stack.push(matchNode);
            depth = new_depth;
        }
        this.rootNode = (MatchNode)stack.getLast();
    }

    public boolean match(IMatchable object) {
        this.variables.clear();
        return this.match(this.rootNode, object);
    }

    private boolean match(MatchNode matchNode, IMatchable object) {
        if (!object.match(matchNode, this)) {
            return false;
        }
        int expr_index = 0;
        int stat_index = 0;
        Iterator<MatchNode> iterator = matchNode.getChildren().iterator();
        while (iterator.hasNext()) {
            MatchNode childNode;
            boolean isStatement = (childNode = iterator.next()).getType() == 0;
            IMatchable childObject = object.findObject(childNode, isStatement ? stat_index : expr_index);
            if (childObject == null || !this.match(childNode, childObject)) {
                return false;
            }
            if (isStatement) {
                ++stat_index;
                continue;
            }
            ++expr_index;
        }
        return true;
    }

    public boolean checkAndSetVariableValue(String name, Object value) {
        Object old_value = this.variables.get(name);
        if (old_value != null) {
            return old_value.equals(value);
        }
        this.variables.put(name, value);
        return true;
    }

    public Object getVariableValue(String name) {
        return this.variables.get(name);
    }

    static {
        stat_properties.put("type", IMatchable.MatchProperties.STATEMENT_TYPE);
        stat_properties.put("ret", IMatchable.MatchProperties.STATEMENT_RET);
        stat_properties.put("position", IMatchable.MatchProperties.STATEMENT_POSITION);
        stat_properties.put("statsize", IMatchable.MatchProperties.STATEMENT_STATSIZE);
        stat_properties.put("exprsize", IMatchable.MatchProperties.STATEMENT_EXPRSIZE);
        stat_properties.put("iftype", IMatchable.MatchProperties.STATEMENT_IFTYPE);
        expr_properties.put("type", IMatchable.MatchProperties.EXPRENT_TYPE);
        expr_properties.put("ret", IMatchable.MatchProperties.EXPRENT_RET);
        expr_properties.put("position", IMatchable.MatchProperties.EXPRENT_POSITION);
        expr_properties.put("functype", IMatchable.MatchProperties.EXPRENT_FUNCTYPE);
        expr_properties.put("exittype", IMatchable.MatchProperties.EXPRENT_EXITTYPE);
        expr_properties.put("consttype", IMatchable.MatchProperties.EXPRENT_CONSTTYPE);
        expr_properties.put("constvalue", IMatchable.MatchProperties.EXPRENT_CONSTVALUE);
        expr_properties.put("invclass", IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS);
        expr_properties.put("signature", IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE);
        expr_properties.put("parameter", IMatchable.MatchProperties.EXPRENT_INVOCATION_PARAMETER);
        expr_properties.put("index", IMatchable.MatchProperties.EXPRENT_VAR_INDEX);
        expr_properties.put("name", IMatchable.MatchProperties.EXPRENT_FIELD_NAME);
        stat_type.put("if", Statement.StatementType.IF);
        stat_type.put("do", Statement.StatementType.DO);
        stat_type.put("switch", Statement.StatementType.SWITCH);
        stat_type.put("trycatch", Statement.StatementType.TRY_CATCH);
        stat_type.put("basicblock", Statement.StatementType.BASIC_BLOCK);
        stat_type.put("sequence", Statement.StatementType.SEQUENCE);
        expr_type.put("annotation", Exprent.Type.ANNOTATION);
        expr_type.put("array", Exprent.Type.ARRAY);
        expr_type.put("assert", Exprent.Type.ASSERT);
        expr_type.put("assignment", Exprent.Type.ASSIGNMENT);
        expr_type.put("constant", Exprent.Type.CONST);
        expr_type.put("exit", Exprent.Type.EXIT);
        expr_type.put("field", Exprent.Type.FIELD);
        expr_type.put("function", Exprent.Type.FUNCTION);
        expr_type.put("if", Exprent.Type.IF);
        expr_type.put("invocation", Exprent.Type.INVOCATION);
        expr_type.put("monitor", Exprent.Type.MONITOR);
        expr_type.put("new", Exprent.Type.NEW);
        expr_type.put("switch", Exprent.Type.SWITCH);
        expr_type.put("switchhead", Exprent.Type.SWITCH_HEAD);
        expr_type.put("var", Exprent.Type.VAR);
        expr_type.put("yield", Exprent.Type.YIELD);
        expr_func_type.put("eq", FunctionExprent.FunctionType.EQ);
        expr_exit_type.put("return", ExitExprent.Type.RETURN);
        expr_exit_type.put("throw", ExitExprent.Type.THROW);
        stat_if_type.put("if", 0);
        stat_if_type.put("ifelse", 1);
        expr_const_type.put("null", VarType.VARTYPE_NULL);
        expr_const_type.put("string", VarType.VARTYPE_STRING);
    }
}

