/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.util.HashSet;
import java.util.stream.Stream;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.util.ModuleBasedContextSource;

public class ClasspathScanner {
    public static void addAllClasspath(StructContext ctx) {
        String[] props;
        HashSet<String> found = new HashSet<String>();
        for (String prop : props = new String[]{System.getProperty("java.class.path"), System.getProperty("sun.boot.class.path")}) {
            if (prop == null) continue;
            for (String path : prop.split(File.pathSeparator)) {
                File file = new File(path);
                if (found.contains(file.getAbsolutePath()) || !file.exists() || !file.getName().endsWith(".class") && !file.getName().endsWith(".jar")) continue;
                DecompilerContext.getLogger().writeMessage("Adding File to context from classpath: " + file, IFernflowerLogger.Severity.INFO);
                ctx.addSpace(file, false);
                found.add(file.getAbsolutePath());
            }
        }
        ClasspathScanner.addAllModulePath(ctx);
    }

    private static void addAllModulePath(StructContext ctx) {
        for (ModuleReference module : ModuleFinder.ofSystem().findAll()) {
            String name = module.descriptor().name();
            try {
                ctx.addSpace(new ModuleContextSource(module), false);
            }
            catch (IOException e) {
                DecompilerContext.getLogger().writeMessage("Error loading module " + name, e);
            }
        }
    }

    static class ModuleContextSource
    extends ModuleBasedContextSource
    implements AutoCloseable {
        private final ModuleReader reader;

        public ModuleContextSource(ModuleReference ref) throws IOException {
            super(ref.descriptor());
            this.reader = ref.open();
        }

        @Override
        public Stream<String> entryNames() throws IOException {
            return this.reader.list();
        }

        @Override
        public InputStream getInputStream(String resource) throws IOException {
            return this.reader.open(resource).orElse(null);
        }

        @Override
        public void close() throws Exception {
            this.reader.close();
        }
    }
}

