/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class VBStyleCollection<E, K>
extends ArrayList<E> {
    private HashMap<K, Integer> map = new HashMap();
    private ArrayList<K> lstKeys = new ArrayList();

    public VBStyleCollection() {
    }

    public VBStyleCollection(int initialCapacity) {
        super(initialCapacity);
        this.lstKeys = new ArrayList(initialCapacity);
        this.map = new HashMap(initialCapacity);
    }

    @Override
    public boolean add(E element) {
        this.lstKeys.add(null);
        super.add(element);
        return true;
    }

    @Override
    public boolean remove(Object element) {
        throw new RuntimeException("not implemented!");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (int i = c.size() - 1; i >= 0; --i) {
            this.lstKeys.add(null);
        }
        return super.addAll(c);
    }

    public void addAllWithKey(Collection<E> elements, Collection<K> keys) {
        int index = super.size();
        for (K key : keys) {
            this.map.put(key, index++);
        }
        super.addAll(elements);
        this.lstKeys.addAll(keys);
    }

    public void addWithKey(E element, K key) {
        this.map.put(key, super.size());
        super.add(element);
        this.lstKeys.add(key);
    }

    public E putWithKey(E element, K key) {
        Integer index = this.map.get(key);
        if (index != null) {
            return super.set(index, element);
        }
        this.addWithKey(element, key);
        return null;
    }

    @Override
    public void add(int index, E element) {
        this.addToListIndex(index, 1);
        this.lstKeys.add(index, null);
        super.add(index, element);
    }

    public void addWithKeyAndIndex(int index, E element, K key) {
        this.addToListIndex(index, 1);
        this.map.put(key, index);
        super.add(index, element);
        this.lstKeys.add(index, key);
    }

    public void removeWithKey(K key) {
        Integer indexBox = this.map.get(key);
        if (indexBox == null) {
            return;
        }
        int index = indexBox;
        this.addToListIndex(index + 1, -1);
        super.remove(index);
        this.lstKeys.remove(index);
        this.map.remove(key);
    }

    @Override
    public E remove(int index) {
        this.addToListIndex(index + 1, -1);
        K obj = this.lstKeys.get(index);
        if (obj != null) {
            this.map.remove(obj);
        }
        this.lstKeys.remove(index);
        return super.remove(index);
    }

    public E getWithKey(K key) {
        Integer index = this.map.get(key);
        if (index == null) {
            return null;
        }
        return super.get(index);
    }

    public int getIndexByKey(K key) {
        return this.map.get(key);
    }

    @Override
    public E getLast() {
        return super.get(super.size() - 1);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.lstKeys.clear();
        super.clear();
    }

    @Override
    public VBStyleCollection<E, K> clone() {
        VBStyleCollection c = new VBStyleCollection();
        c.addAll(new ArrayList(this));
        c.setMap(new HashMap<K, Integer>(this.map));
        c.setLstKeys(new ArrayList<K>(this.lstKeys));
        return c;
    }

    public void setMap(HashMap<K, Integer> map) {
        this.map = map;
    }

    public K getKey(int index) {
        return this.lstKeys.get(index);
    }

    public ArrayList<K> getLstKeys() {
        return this.lstKeys;
    }

    public void setLstKeys(ArrayList<K> lstKeys) {
        this.lstKeys = lstKeys;
    }

    private void addToListIndex(int index, int diff) {
        for (int i = this.lstKeys.size() - 1; i >= index; --i) {
            K obj = this.lstKeys.get(i);
            if (obj == null) continue;
            this.map.put(obj, i + diff);
        }
    }

    public String toStringVb() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < super.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getLstKeys().get(i)).append("=").append(super.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

