/*
 * Decompiled with CFR 0.152.
 */
package org.qunix.maven.structure.plugin.core;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.qunix.maven.structure.plugin.core.types.StructureOutput;
import org.qunix.maven.structure.plugin.interfaces.StructureNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureNode<T>
implements StructureNode<T> {
    private static final long serialVersionUID = 1L;
    protected AbstractStructureNode[] childs;
    protected T content;
    protected boolean detailEnabled;

    public AbstractStructureNode(T content, boolean detailEnabled) throws MojoFailureException {
        this.content = content;
        this.childs = this.getChilds();
        this.detailEnabled = detailEnabled;
    }

    @Override
    public String getName() throws MojoFailureException {
        if (!this.detailEnabled) {
            return this.getNodeName();
        }
        return this.getDetailedName();
    }

    @Override
    public boolean hasMoreChilds(int index, String[] ignores) throws MojoFailureException {
        if (this.isEmpty() || this.childs.length - 1 == index) {
            return false;
        }
        for (int i = index + 1; i < this.childs.length; ++i) {
            if (!this.childs[i].isValid(ignores, new String[0])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid(String[] ignores, String ... parentName) {
        if (!(ArrayUtils.isEmpty((Object[])parentName) || StringUtils.isEmpty((CharSequence)this.getParentName()) || this.getParentName().equalsIgnoreCase(parentName[0]))) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])ignores)) {
            return true;
        }
        for (int i = 0; i < ignores.length; ++i) {
            if (!this.getNodeName().matches(ignores[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() throws MojoFailureException {
        return ArrayUtils.isEmpty((Object[])this.childs);
    }

    @Override
    public abstract String getNodeName();

    public abstract String getDetailedName() throws MojoFailureException;

    @Override
    public String getOutput(String levelStr) throws MojoFailureException {
        StringBuilder sb = new StringBuilder(StructureOutput.NEW_LINE.getValue()).append(levelStr).append(StructureOutput.VERTICAL_BAR.getValue()).append(StructureOutput.NEW_LINE.getValue()).append(levelStr).append(StructureOutput.VERTICAL_BAR.getValue()).append(StructureOutput.NEW_LINE.getValue()).append(levelStr);
        if (this.isEmpty()) {
            sb.append(StructureOutput.LOW_LINE.getValue());
        } else {
            sb.append(StructureOutput.BACKSLASH_LOWLINE.getValue());
        }
        return sb.append(this.getName()).toString();
    }

    @Override
    public String getHeader() throws MojoFailureException {
        return StructureOutput.NEW_LINE.getValue() + StructureOutput.NEW_LINE.getValue() + "Project structure:" + StructureOutput.LONG_NEW_LINE.getValue() + StructureOutput.LONG_TAB.getValue() + this.getName();
    }
}

