/*
 * Decompiled with CFR 0.152.
 */
package org.qunix.maven.structure.plugin.core;

import java.io.File;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.qunix.maven.structure.plugin.core.AbstractStructureNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStructureNode
extends AbstractStructureNode<File> {
    private static final long serialVersionUID = 1L;

    public FileStructureNode(File content, boolean detailEnabled) throws MojoFailureException {
        super(content, detailEnabled);
    }

    @Override
    public AbstractStructureNode[] getChilds() throws MojoFailureException {
        Object[] files = ((File)this.content).listFiles();
        if (ArrayUtils.isEmpty((Object[])files)) {
            return null;
        }
        AbstractStructureNode[] childs = new AbstractStructureNode[files.length];
        for (int i = 0; i < files.length; ++i) {
            childs[i] = new FileStructureNode((File)files[i], this.detailEnabled);
        }
        return childs;
    }

    @Override
    public String getNodeName() {
        return ((File)this.content).getName();
    }

    @Override
    public String getDetailedName() throws MojoFailureException {
        StringBuilder sb = new StringBuilder(" [ " + this.getNodeName() + " ] ");
        sb.append(" ").append(((File)this.content).isHidden() ? "hidden" : "").append(" ").append(((File)this.content).isDirectory() ? (this.isEmpty() ? 0 : this.childs.length) + " file" : ((File)this.content).length() + " byte").append(" ").append(new Date(((File)this.content).lastModified()).toString());
        return sb.toString();
    }

    @Override
    public String getParentName() {
        return null;
    }
}

