/*
 * Decompiled with CFR 0.152.
 */
package org.qunix.maven.structure.plugin.core;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.qunix.maven.structure.plugin.core.AbstractStructureNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleStructureNode
extends AbstractStructureNode<MavenProject> {
    private static final long serialVersionUID = 1L;

    public ModuleStructureNode(MavenProject content, boolean detailEnabled) throws MojoFailureException {
        super(content, detailEnabled);
    }

    @Override
    public AbstractStructureNode[] getChilds() throws MojoFailureException {
        List projects = ((MavenProject)this.content).getCollectedProjects();
        if (CollectionUtils.isEmpty((Collection)projects)) {
            return null;
        }
        AbstractStructureNode[] childs = new AbstractStructureNode[projects.size()];
        for (int i = 0; i < projects.size(); ++i) {
            childs[i] = new ModuleStructureNode((MavenProject)projects.get(i), this.detailEnabled);
        }
        return childs;
    }

    @Override
    public String getNodeName() {
        return ((MavenProject)this.content).getArtifactId();
    }

    @Override
    public String getDetailedName() {
        StringBuilder sb = new StringBuilder(((MavenProject)this.content).getGroupId());
        sb.append(" : ").append(((MavenProject)this.content).getArtifactId());
        sb.append(" (").append(((MavenProject)this.content).getVersion()).append(") ");
        sb.append(((MavenProject)this.content).getPackaging());
        return sb.toString();
    }

    @Override
    public String getParentName() {
        return ((MavenProject)this.content).getParent().getArtifactId();
    }
}

