/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.oauth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import org.radarbase.exception.TokenException;

public class OAuth2AccessTokenDetails {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="sub")
    private String subject;
    @JsonProperty(value="iss")
    private String issuer;
    @JsonProperty(value="iat")
    private long issueDate;
    @JsonProperty(value="jti")
    private String jsonWebTokenId;
    @JsonProperty(value="error")
    private String error;
    @JsonProperty(value="error_description")
    private String errorDescription;
    @JsonProperty(value="message")
    private String message;

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public long getIssueDate() {
        return this.issueDate;
    }

    public String getJsonWebTokenId() {
        return this.jsonWebTokenId;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        if (this.errorDescription != null) {
            return this.errorDescription;
        }
        if (this.message != null) {
            return this.message;
        }
        return "";
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.getExpiryDate());
    }

    public boolean isValid() {
        return this.accessToken != null && this.error == null;
    }

    public Instant getExpiryDate() {
        return Instant.ofEpochSecond(this.issueDate + this.expiresIn);
    }

    public static OAuth2AccessTokenDetails getObject(String responseBody) throws TokenException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            OAuth2AccessTokenDetails result = (OAuth2AccessTokenDetails)mapper.readValue(responseBody, OAuth2AccessTokenDetails.class);
            if (result.getError() != null) {
                throw new TokenException(result.getError() + ": " + result.getErrorDescription());
            }
            if (result.getAccessToken() == null) {
                throw new TokenException("An unexpected error occured. Response body was: " + responseBody);
            }
            return result;
        }
        catch (Exception e) {
            throw new TokenException(e);
        }
    }
}

