/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.oauth;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.radarbase.exception.TokenException;
import org.radarbase.oauth.OAuth2AccessTokenDetails;

public class OAuth2Client {
    private static final Duration MINIMUM_VALIDITY = Duration.ofSeconds(10L);
    private final URL tokenEndpoint;
    private final Set<String> scope;
    private final OkHttpClient httpClient;
    private final String clientCredentials;
    private OAuth2AccessTokenDetails token;

    private OAuth2Client(URL endpoint, String clientCredentials, Set<String> scopes, OAuth2AccessTokenDetails token, OkHttpClient client) {
        this.tokenEndpoint = endpoint;
        this.clientCredentials = clientCredentials;
        this.scope = scopes;
        this.token = token;
        this.httpClient = client;
    }

    public URL getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public synchronized OAuth2AccessTokenDetails getToken() {
        return this.token;
    }

    public OAuth2AccessTokenDetails getValidToken() throws TokenException {
        return this.getValidToken(MINIMUM_VALIDITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2AccessTokenDetails getValidToken(Duration validity) throws TokenException {
        OAuth2Client oAuth2Client = this;
        synchronized (oAuth2Client) {
            if (this.isTokenValidFor(validity)) {
                return this.token;
            }
        }
        return this.refreshToken();
    }

    public synchronized boolean isTokenValidFor(Duration timeStillValid) {
        return this.token.isValid() && Instant.now().plus(timeStillValid).isBefore(this.token.getExpiryDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuth2AccessTokenDetails refreshToken() throws TokenException {
        FormBody body = new FormBody.Builder().add("grant_type", "client_credentials").add("scope", String.join((CharSequence)" ", this.scope)).build();
        Request request = new Request.Builder().addHeader("Accept", "application/json").addHeader("Authorization", this.clientCredentials).url(this.getTokenEndpoint()).post((RequestBody)body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) throw new TokenException("Cannot get a valid token : Response-code :" + response.code() + " received when requesting token from server with message " + response.message());
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new TokenException("No response from server");
            }
            OAuth2AccessTokenDetails localToken = OAuth2AccessTokenDetails.getObject(responseBody.string());
            Object object = this;
            synchronized (object) {
                this.token = localToken;
            }
            object = localToken;
            return object;
        }
        catch (IOException e) {
            throw new TokenException(e);
        }
    }

    public static class Builder {
        private URL tokenEndpoint;
        private final Set<String> scopeSet = new HashSet<String>();
        private OAuth2AccessTokenDetails currentToken = new OAuth2AccessTokenDetails();
        private OkHttpClient okHttpClient;
        private String clientCredentials;

        public Builder endpoint(URL url) {
            this.tokenEndpoint = url;
            return this;
        }

        public Builder endpoint(URL mpBaseUrl, String tokenPath) throws MalformedURLException {
            this.tokenEndpoint = new URL(mpBaseUrl, tokenPath);
            return this;
        }

        public Builder credentials(String id, String secret) {
            this.clientCredentials = Credentials.basic((String)id, (String)secret);
            return this;
        }

        public Builder scopes(String ... scopes) {
            this.scopeSet.addAll(Arrays.asList(scopes));
            return this;
        }

        public Builder token(OAuth2AccessTokenDetails token) {
            this.currentToken = token;
            return this;
        }

        public Builder httpClient(OkHttpClient client) {
            this.okHttpClient = client;
            return this;
        }

        public OAuth2Client build() {
            if (this.clientCredentials == null) {
                throw new IllegalStateException("Client credentials missing");
            }
            if (this.tokenEndpoint == null) {
                throw new IllegalStateException("Token endpoint missing");
            }
            if (this.okHttpClient == null) {
                this.okHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            }
            return new OAuth2Client(this.tokenEndpoint, this.clientCredentials, this.scopeSet, this.currentToken, this.okHttpClient);
        }
    }
}

