/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.radarbase.auth.authorization.Permission;

public final class Permissions {
    private static final Map<Permission, Set<String>> PERMISSION_MATRIX = new HashMap<Permission, Set<String>>();

    private Permissions() {
    }

    public static Set<String> allowedAuthorities(Permission permission) {
        if (PERMISSION_MATRIX.containsKey(permission)) {
            return Collections.unmodifiableSet(PERMISSION_MATRIX.get(permission));
        }
        return Collections.emptySet();
    }

    public static Map<Permission, Set<String>> getPermissionMatrix() {
        return Collections.unmodifiableMap(PERMISSION_MATRIX);
    }

    private static void initPermissions() {
        Permission.allPermissions().forEach(p -> {
            Set cfr_ignored_0 = PERMISSION_MATRIX.put((Permission)p, new HashSet());
        });
        PERMISSION_MATRIX.values().forEach(s -> s.add("ROLE_SYS_ADMIN"));
        PERMISSION_MATRIX.entrySet().stream().filter(e -> e.getKey() != Permission.PROJECT_CREATE).forEach(e -> ((Set)e.getValue()).add("ROLE_PROJECT_ADMIN"));
        PERMISSION_MATRIX.entrySet().stream().filter(e -> ((Permission)e.getKey()).getEntity() == Permission.Entity.SUBJECT).forEach(e -> ((Set)e.getValue()).add("ROLE_PROJECT_OWNER"));
        PERMISSION_MATRIX.entrySet().stream().filter(e -> !Arrays.asList(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY, Permission.Entity.USER).contains((Object)((Permission)e.getKey()).getEntity())).filter(e -> ((Permission)e.getKey()).getOperation() == Permission.Operation.READ).forEach(e -> ((Set)e.getValue()).add("ROLE_PROJECT_OWNER"));
        PERMISSION_MATRIX.entrySet().stream().filter(e -> ((Permission)e.getKey()).getEntity() == Permission.Entity.SUBJECT).filter(e -> ((Permission)e.getKey()).getOperation() != Permission.Operation.DELETE).forEach(e -> ((Set)e.getValue()).add("ROLE_PROJECT_AFFILIATE"));
        PERMISSION_MATRIX.entrySet().stream().filter(e -> !Arrays.asList(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY, Permission.Entity.USER).contains((Object)((Permission)e.getKey()).getEntity())).filter(e -> ((Permission)e.getKey()).getOperation() == Permission.Operation.READ).forEach(e -> ((Set)e.getValue()).add("ROLE_PROJECT_AFFILIATE"));
        PERMISSION_MATRIX.entrySet().stream().filter(e -> !Arrays.asList(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY, Permission.Entity.USER).contains((Object)((Permission)e.getKey()).getEntity())).filter(e -> ((Permission)e.getKey()).getOperation() == Permission.Operation.READ).forEach(e -> ((Set)e.getValue()).add("ROLE_PROJECT_ANALYST"));
        PERMISSION_MATRIX.get(Permission.SOURCE_UPDATE).add("ROLE_PROJECT_ANALYST");
        Arrays.asList(Permission.SUBJECT_READ, Permission.SUBJECT_UPDATE, Permission.MEASUREMENT_CREATE, Permission.MEASUREMENT_READ).forEach(p -> PERMISSION_MATRIX.get(p).add("ROLE_PARTICIPANT"));
    }

    static {
        Permissions.initPermissions();
    }
}

