/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.token.validation;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.radarbase.auth.exception.ConfigurationException;
import org.radarbase.auth.token.validation.TokenValidationAlgorithm;

public abstract class AbstractTokenValidationAlgorithm
implements TokenValidationAlgorithm {
    protected abstract String getKeyFactoryType();

    protected PublicKey parseKey(String publicKey) {
        String trimmedKey = publicKey.replaceAll("-----BEGIN ([A-Z]+ )?PUBLIC KEY-----", "");
        trimmedKey = trimmedKey.replaceAll("-----END ([A-Z]+ )?PUBLIC KEY-----", "");
        trimmedKey = trimmedKey.trim();
        try {
            byte[] decodedPublicKey = Base64.getDecoder().decode(trimmedKey);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(decodedPublicKey);
            KeyFactory kf = KeyFactory.getInstance(this.getKeyFactoryType());
            return kf.generatePublic(spec);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }
}

