/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.auth0.jwt.algorithms;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.apache.commons.codec.binary.Base64;
import shadow.com.auth0.jwt.algorithms.Algorithm;
import shadow.com.auth0.jwt.algorithms.CryptoHelper;
import shadow.com.auth0.jwt.exceptions.SignatureGenerationException;
import shadow.com.auth0.jwt.exceptions.SignatureVerificationException;
import shadow.com.auth0.jwt.interfaces.DecodedJWT;
import shadow.com.auth0.jwt.interfaces.ECDSAKeyProvider;

class ECDSAAlgorithm
extends Algorithm {
    private final ECDSAKeyProvider keyProvider;
    private final CryptoHelper crypto;
    private final int ecNumberSize;

    ECDSAAlgorithm(CryptoHelper crypto, String id, String algorithm, int ecNumberSize, ECDSAKeyProvider keyProvider) throws IllegalArgumentException {
        super(id, algorithm);
        if (keyProvider == null) {
            throw new IllegalArgumentException("The Key Provider cannot be null.");
        }
        this.keyProvider = keyProvider;
        this.crypto = crypto;
        this.ecNumberSize = ecNumberSize;
    }

    ECDSAAlgorithm(String id, String algorithm, int ecNumberSize, ECDSAKeyProvider keyProvider) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, ecNumberSize, keyProvider);
    }

    @Override
    public void verify(DecodedJWT jwt) throws SignatureVerificationException {
        byte[] contentBytes = String.format("%s.%s", jwt.getHeader(), jwt.getPayload()).getBytes(StandardCharsets.UTF_8);
        byte[] signatureBytes = Base64.decodeBase64((String)jwt.getSignature());
        try {
            boolean valid;
            ECPublicKey publicKey = (ECPublicKey)this.keyProvider.getPublicKeyById(jwt.getKeyId());
            if (publicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            if (!this.isDERSignature(signatureBytes)) {
                signatureBytes = this.JOSEToDER(signatureBytes);
            }
            if (!(valid = this.crypto.verifySignatureFor(this.getDescription(), publicKey, contentBytes, signatureBytes))) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        try {
            ECPrivateKey privateKey = (ECPrivateKey)this.keyProvider.getPrivateKey();
            if (privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            return this.crypto.createSignatureFor(this.getDescription(), privateKey, contentBytes);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    @Override
    public String getSigningKeyId() {
        return this.keyProvider.getPrivateKeyId();
    }

    private boolean isDERSignature(byte[] signature) {
        return signature[0] == 48 && signature.length != this.ecNumberSize * 2;
    }

    private byte[] JOSEToDER(byte[] joseSignature) throws SignatureException {
        int offset;
        byte[] derSignature;
        int sPadding;
        int sLength;
        if (joseSignature.length != this.ecNumberSize * 2) {
            throw new SignatureException(String.format("The signature length was invalid. Expected %d bytes but received %d", this.ecNumberSize * 2, joseSignature.length));
        }
        int rPadding = this.countPadding(joseSignature, 0, this.ecNumberSize);
        int rLength = this.ecNumberSize - rPadding;
        int length = 2 + rLength + 2 + (sLength = this.ecNumberSize - (sPadding = this.countPadding(joseSignature, this.ecNumberSize, joseSignature.length)));
        if (length > 255) {
            throw new SignatureException("Invalid ECDSA signature format");
        }
        if (length > 127) {
            derSignature = new byte[3 + length];
            derSignature[1] = -127;
            offset = 2;
        } else {
            derSignature = new byte[2 + length];
            offset = 1;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)length;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)rLength;
        System.arraycopy(joseSignature, 0, derSignature, offset + (rLength - this.ecNumberSize), this.ecNumberSize);
        offset += rLength;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)sLength;
        System.arraycopy(joseSignature, this.ecNumberSize, derSignature, offset + (sLength - this.ecNumberSize), this.ecNumberSize);
        return derSignature;
    }

    private int countPadding(byte[] bytes, int fromIndex, int toIndex) {
        int padding = 0;
        while (fromIndex + padding < toIndex && bytes[fromIndex + padding] == 0) {
            ++padding;
        }
        return bytes[fromIndex + padding] > 127 ? padding : padding - 1;
    }

    static ECDSAKeyProvider providerForKeys(final ECPublicKey publicKey, final ECPrivateKey privateKey) {
        if (publicKey == null && privateKey == null) {
            throw new IllegalArgumentException("Both provided Keys cannot be null.");
        }
        return new ECDSAKeyProvider(){

            @Override
            public ECPublicKey getPublicKeyById(String keyId) {
                return publicKey;
            }

            @Override
            public ECPrivateKey getPrivateKey() {
                return privateKey;
            }

            @Override
            public String getPrivateKeyId() {
                return null;
            }
        };
    }
}

