/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.auth0.jwt.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import shadow.com.auth0.jwt.impl.ClaimsHolder;

public class PayloadSerializer
extends StdSerializer<ClaimsHolder> {
    public PayloadSerializer() {
        this(null);
    }

    private PayloadSerializer(Class<ClaimsHolder> t) {
        super(t);
    }

    public void serialize(ClaimsHolder holder, JsonGenerator gen, SerializerProvider provider) throws IOException {
        HashMap<String, Object> safePayload = new HashMap<String, Object>();
        block10: for (Map.Entry<String, Object> e : holder.getClaims().entrySet()) {
            switch (e.getKey()) {
                case "aud": {
                    if (e.getValue() instanceof String) {
                        safePayload.put(e.getKey(), e.getValue());
                        continue block10;
                    }
                    String[] audArray = (String[])e.getValue();
                    if (audArray.length == 1) {
                        safePayload.put(e.getKey(), audArray[0]);
                        continue block10;
                    }
                    if (audArray.length <= 1) continue block10;
                    safePayload.put(e.getKey(), audArray);
                    continue block10;
                }
                case "exp": 
                case "iat": 
                case "nbf": {
                    safePayload.put(e.getKey(), this.dateToSeconds((Date)e.getValue()));
                    continue block10;
                }
            }
            if (e.getValue() instanceof Date) {
                safePayload.put(e.getKey(), this.dateToSeconds((Date)e.getValue()));
                continue;
            }
            safePayload.put(e.getKey(), e.getValue());
        }
        gen.writeObject(safePayload);
    }

    private long dateToSeconds(Date date) {
        return date.getTime() / 1000L;
    }
}

