/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.radarbase.auth.exception.TokenValidationException;
import org.radarbase.auth.security.jwk.JavaWebKey;
import org.radarbase.auth.security.jwk.JavaWebKeySet;
import org.radarbase.auth.token.validation.ECTokenValidationAlgorithm;
import org.radarbase.auth.token.validation.RSATokenValidationAlgorithm;
import org.radarbase.auth.token.validation.TokenValidationAlgorithm;
import org.radarbase.auth.token.validation.deprecated.DeprecatedEcTokenValidationAlgorithm;

public class AlgorithmLoader {
    private final List<TokenValidationAlgorithm> supportedAlgorithmsForWebKeySets;
    private final List<TokenValidationAlgorithm> supportedAlgorithmsForPublicKeysInConfig;

    public AlgorithmLoader(List<TokenValidationAlgorithm> supportedAlgorithmsForWebKeySets, List<TokenValidationAlgorithm> supportedAlgorithmsForPublicKeysInConfig) {
        this.supportedAlgorithmsForWebKeySets = supportedAlgorithmsForWebKeySets;
        this.supportedAlgorithmsForPublicKeysInConfig = supportedAlgorithmsForPublicKeysInConfig;
    }

    public AlgorithmLoader() {
        this(Arrays.asList(new ECTokenValidationAlgorithm(), new RSATokenValidationAlgorithm()), Arrays.asList(new DeprecatedEcTokenValidationAlgorithm(), new RSATokenValidationAlgorithm()));
    }

    private Algorithm algorithmFromPublicKey(String publicKey) {
        return AlgorithmLoader.loadAlgorithmFromPublicKey(this.supportedAlgorithmsForWebKeySets, publicKey);
    }

    private static Algorithm loadAlgorithmFromPublicKey(List<TokenValidationAlgorithm> supportedAlgorithms, String publicKey) {
        return supportedAlgorithms.stream().filter(algorithm -> publicKey.startsWith(algorithm.getKeyHeader())).findFirst().orElseThrow(() -> new TokenValidationException("Unsupported public key: " + publicKey)).getAlgorithm(publicKey);
    }

    public Algorithm loadDeprecatedAlgorithmFromPublicKey(String publicKey) {
        return AlgorithmLoader.loadAlgorithmFromPublicKey(this.supportedAlgorithmsForPublicKeysInConfig, publicKey);
    }

    public List<Algorithm> loadAlgorithmsFromJavaWebKeys(JavaWebKeySet publicKeyInfo) {
        return publicKeyInfo.getKeys().stream().map(JavaWebKey::getValue).map(this::algorithmFromPublicKey).collect(Collectors.toList());
    }

    public static JWTVerifier buildVerifier(Algorithm algorithm, String audience) {
        return JWT.require((Algorithm)algorithm).withAudience(new String[]{audience}).build();
    }
}

