/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authentication;

import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.radarbase.auth.authentication.AlgorithmLoader;
import org.radarbase.auth.config.TokenValidatorConfig;
import org.radarbase.auth.config.TokenVerifierPublicKeyConfig;
import org.radarbase.auth.exception.TokenValidationException;
import org.radarbase.auth.security.jwk.JavaWebKeySet;
import org.radarbase.auth.token.JwtRadarToken;
import org.radarbase.auth.token.RadarToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenValidator.class);
    private final TokenValidatorConfig config;
    private List<JWTVerifier> verifiers = new LinkedList<JWTVerifier>();
    private static final Duration FETCH_TIMEOUT_DEFAULT = Duration.ofMinutes(1L);
    private final Duration fetchTimeout;
    private Instant lastFetch = Instant.MIN;
    private static final long DEFAULT_TIMEOUT = 30L;
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    private final ObjectMapper mapper = new ObjectMapper();
    private final AlgorithmLoader algorithmLoader = new AlgorithmLoader();

    public TokenValidator() {
        this((TokenValidatorConfig)TokenVerifierPublicKeyConfig.readFromFileOrClasspath(), FETCH_TIMEOUT_DEFAULT);
    }

    public TokenValidator(TokenValidatorConfig config) {
        this(config, FETCH_TIMEOUT_DEFAULT);
    }

    private TokenValidator(TokenValidatorConfig config, Duration fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
        this.config = config;
    }

    @Deprecated
    public TokenValidator(TokenValidatorConfig config, long fetchTimeout) {
        this(config, Duration.ofSeconds(fetchTimeout));
    }

    @Deprecated
    protected TokenValidator(List<JWTVerifier> verifiers, TokenValidatorConfig config) {
        this.config = config;
        this.verifiers = verifiers;
        this.fetchTimeout = Duration.ofHours(1L);
    }

    public RadarToken validateAccessToken(String token) throws TokenValidationException {
        return this.validateAccessToken(token, true);
    }

    private RadarToken validateAccessToken(String token, boolean tryRefresh) {
        List<JWTVerifier> localVerifiers = this.getVerifiers();
        for (JWTVerifier verifier : localVerifiers) {
            try {
                DecodedJWT jwt = verifier.verify(token);
                Map claims = jwt.getClaims();
                LOGGER.debug("Verified JWT header {} and payload {}", (Object)jwt.getHeader(), (Object)jwt.getPayload());
                if (!claims.containsKey("scope")) {
                    throw new TokenValidationException("The required claim scopeis missing from the token");
                }
                return new JwtRadarToken(jwt);
            }
            catch (SignatureVerificationException sve) {
                LOGGER.debug("Client presented a token with an incorrect signature.");
                if (!tryRefresh) continue;
                LOGGER.info("Trying to fetch public keys again...");
                try {
                    this.refresh();
                }
                catch (TokenValidationException ex) {
                    LOGGER.warn("Could not fetch public keys.", (Throwable)ex);
                }
                return this.validateAccessToken(token, false);
            }
            catch (JWTVerificationException ex) {
                LOGGER.debug("Verifier {} with implementation {} did not accept token {}", new Object[]{verifier.toString(), verifier.getClass().toString(), token});
            }
        }
        throw new TokenValidationException("No registered validator could authenticate this token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JWTVerifier> getVerifiers() {
        TokenValidator tokenValidator = this;
        synchronized (tokenValidator) {
            if (!this.verifiers.isEmpty()) {
                return this.verifiers;
            }
        }
        List<JWTVerifier> localVerifiers = this.loadVerifiers();
        TokenValidator tokenValidator2 = this;
        synchronized (tokenValidator2) {
            this.verifiers = localVerifiers;
            return this.verifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws TokenValidationException {
        List<JWTVerifier> localVerifiers = this.loadVerifiers();
        if (!localVerifiers.isEmpty()) {
            TokenValidator tokenValidator = this;
            synchronized (tokenValidator) {
                this.verifiers = localVerifiers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JWTVerifier> loadVerifiers() throws TokenValidationException {
        TokenValidator tokenValidator = this;
        synchronized (tokenValidator) {
            if (Instant.now().isBefore(this.lastFetch.plus(this.fetchTimeout))) {
                LOGGER.warn("Fetched public key less than {} ago, denied access.", (Object)this.fetchTimeout);
                throw new TokenValidationException("Not fetching public key more than once every " + this.fetchTimeout);
            }
            this.lastFetch = Instant.now();
        }
        Stream endpointKeys = TokenValidator.streamEmptyIfNull(this.config.getPublicKeyEndpoints()).map(this::algorithmFromServerPublicKeyEndpoint).flatMap(Collection::stream);
        Stream<Algorithm> stringKeys = TokenValidator.streamEmptyIfNull(this.config.getPublicKeys()).map(this.algorithmLoader::loadDeprecatedAlgorithmFromPublicKey);
        return Stream.concat(endpointKeys, stringKeys).map(alg -> AlgorithmLoader.buildVerifier(alg, this.config.getResourceName())).collect(Collectors.toList());
    }

    private List<Algorithm> algorithmFromServerPublicKeyEndpoint(URI serverUri) throws TokenValidationException {
        LOGGER.info("Getting the JWT public key at " + serverUri);
        try {
            Request request = new Request.Builder().url(serverUri.toURL()).header("Accept", "application/json").build();
            Response response = this.client.newCall(request).execute();
            if (response.isSuccessful() && response.body() != null) {
                JavaWebKeySet publicKeyInfo = (JavaWebKeySet)this.mapper.readValue(response.body().string(), JavaWebKeySet.class);
                response.close();
                LOGGER.debug("Processing {} public keys from public-key endpoint {}", (Object)publicKeyInfo.getKeys().size(), (Object)serverUri.toURL());
                return this.algorithmLoader.loadAlgorithmsFromJavaWebKeys(publicKeyInfo);
            }
            throw new TokenValidationException("Invalid token signature. Could not load newer public keys");
        }
        catch (Exception ex) {
            throw new TokenValidationException(ex);
        }
    }

    private static <T> Stream<T> streamEmptyIfNull(Collection<T> collection) {
        return collection != null ? collection.stream() : Stream.empty();
    }
}

