/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authorization;

import org.radarbase.auth.authorization.Permission;
import org.radarbase.auth.exception.NotAuthorizedException;
import org.radarbase.auth.token.RadarToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RadarAuthorization {
    private static final Logger log = LoggerFactory.getLogger(RadarAuthorization.class);

    private RadarAuthorization() {
    }

    public static void checkAuthority(RadarToken token, String authority) throws NotAuthorizedException {
        if (!token.isClientCredentials()) {
            log.debug("Checking authority {} for user {}", (Object)authority, (Object)token.getSubject());
            if (!token.hasAuthority(authority)) {
                throw new NotAuthorizedException(String.format("Request Client %s does not have authority %s", token.getSubject(), authority));
            }
        }
    }

    public static void checkAuthorityAndPermission(RadarToken token, String authority, Permission permission) throws NotAuthorizedException {
        log.debug("Checking authority {} and permission {} for user {}", new Object[]{authority, permission, token.getSubject()});
        RadarAuthorization.checkAuthority(token, authority);
        RadarAuthorization.checkPermission(token, permission);
    }

    public static void checkPermission(RadarToken token, Permission permission) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {}", (Object)permission.toString(), (Object)token.getSubject());
        if (!token.hasPermission(permission)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s", token.getSubject(), permission.toString()));
        }
    }

    public static void checkPermissionOnProject(RadarToken token, Permission permission, String projectName) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} in project {}", new Object[]{permission.toString(), token.getSubject(), projectName});
        if (!token.hasPermissionOnProject(permission, projectName)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s in project %s", token.getSubject(), permission.toString(), projectName));
        }
    }

    public static void checkPermissionOnSubject(RadarToken token, Permission permission, String projectName, String subjectName) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} on subject {} in project {}", new Object[]{permission.toString(), token.getSubject(), subjectName, projectName});
        if (!token.hasPermissionOnSubject(permission, projectName, subjectName)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s on subject %s in project %s", token.getSubject(), permission, subjectName, projectName));
        }
    }

    public static void checkPermissionOnSource(RadarToken token, Permission permission, String projectName, String subjectName, String sourceId) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} on source {} of subject {} in project {}", new Object[]{permission.toString(), token.getSubject(), sourceId, subjectName, projectName});
        if (!token.hasPermissionOnSource(permission, projectName, subjectName, sourceId)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s on source %s of subject %s in project %s", token.getSubject(), permission, sourceId, subjectName, projectName));
        }
    }
}

