/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.token;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.radarbase.auth.authorization.Permission;
import org.radarbase.auth.token.RadarToken;

public abstract class AbstractRadarToken
implements RadarToken {
    protected static final String CLIENT_CREDENTIALS = "client_credentials";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasAuthority(String authority) {
        if (this.isClientCredentials()) return true;
        if (!this.getAuthorities().stream().anyMatch(authority::equals)) return false;
        return true;
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.hasScope(permission.scopeName()) && (this.isClientCredentials() || this.hasAuthorityForPermission(permission));
    }

    @Override
    public boolean hasPermissionOnProject(Permission permission, String projectName) {
        return this.hasScope(permission.scopeName()) && (this.isClientCredentials() || this.hasAuthorityForProject(permission, projectName));
    }

    @Override
    public boolean hasPermissionOnSubject(Permission permission, String projectName, String subjectName) {
        return this.hasScope(permission.scopeName()) && (this.isClientCredentials() || this.hasAuthorityForSubject(permission, projectName, subjectName));
    }

    @Override
    public boolean hasPermissionOnSource(Permission permission, String projectName, String subjectName, String sourceId) {
        return this.hasScope(permission.scopeName()) && (this.isClientCredentials() || this.hasAuthorityForSource(permission, projectName, subjectName, sourceId));
    }

    protected boolean hasScope(String scope) {
        return this.getScopes().contains(scope);
    }

    @Override
    public boolean isClientCredentials() {
        return CLIENT_CREDENTIALS.equals(this.getGrantType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasAuthorityForPermission(Permission permission) {
        if (this.hasNonProjectRelatedAuthorityForPermission(permission)) return true;
        if (!this.getRoles().values().stream().flatMap(Collection::stream).anyMatch(permission::isAuthorityAllowed)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasAuthorityForProject(Permission permission, String projectName) {
        if (this.hasNonProjectRelatedAuthorityForPermission(permission)) {
            return true;
        }
        if (projectName == null) {
            return false;
        }
        List<String> roles = this.getRoles().get(projectName);
        if (roles == null) return false;
        if (!roles.stream().anyMatch(permission::isAuthorityAllowed)) return false;
        return true;
    }

    protected boolean hasAuthorityForSubject(Permission permission, String projectName, String subjectName) {
        if (this.isJustParticipant(projectName)) {
            return this.getSubject().equals(subjectName) && permission.isAuthorityAllowed("ROLE_PARTICIPANT");
        }
        return this.hasAuthorityForProject(permission, projectName);
    }

    protected boolean hasAuthorityForSource(Permission permission, String projectName, String subjectName, String sourceId) {
        if (!this.hasAuthorityForSubject(permission, projectName, subjectName)) {
            return false;
        }
        if (this.isJustParticipant(projectName)) {
            return this.getSources().contains(sourceId);
        }
        return true;
    }

    protected boolean hasNonProjectRelatedAuthorityForPermission(Permission permission) {
        return this.getAuthorities().contains("ROLE_SYS_ADMIN") && permission.isAuthorityAllowed("ROLE_SYS_ADMIN");
    }

    protected boolean isJustParticipant(String projectName) {
        return Collections.singletonList("ROLE_PARTICIPANT").equals(this.getRoles().get(projectName));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.getToken(), ((AbstractRadarToken)other).getToken());
    }

    public int hashCode() {
        return Objects.hashCode(this.getToken());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{scopes=" + this.getScopes() + ", subject='" + this.getSubject() + '\'' + ", roles=" + this.getRoles() + ", sources=" + this.getSources() + ", authorities=" + this.getAuthorities() + ", grantType='" + this.getGrantType() + '\'' + ", audience=" + this.getAudience() + ", issuer='" + this.getIssuer() + '\'' + ", issuedAt=" + this.getIssuedAt() + ", expiresAt=" + this.getExpiresAt() + ", type='" + this.getType() + '\'' + ", token='" + this.getToken() + '\'' + '}';
    }
}

