/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.token;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.radarbase.auth.token.AbstractRadarToken;

public class JwtRadarToken
extends AbstractRadarToken {
    private static final Pattern ROLE_SEPARATOR_PATTERN = Pattern.compile(":");
    public static final String AUTHORITIES_CLAIM = "authorities";
    public static final String ROLES_CLAIM = "roles";
    public static final String SCOPE_CLAIM = "scope";
    public static final String SOURCES_CLAIM = "sources";
    public static final String GRANT_TYPE_CLAIM = "grant_type";
    public static final String CLIENT_ID_CLAIM = "client_id";
    private final Map<String, List<String>> roles;
    private final List<String> authorities;
    private final List<String> scopes;
    private final List<String> sources;
    private final String grantType;
    private final String subject;
    private final Date issuedAt;
    private final Date expiresAt;
    private final List<String> audience;
    private final String token;
    private final String issuer;
    private final String type;
    private final String clientId;
    private final DecodedJWT jwt;

    public JwtRadarToken(DecodedJWT jwt) {
        List<Object> scopeClaimList;
        this.jwt = jwt;
        this.roles = this.parseRoles(jwt);
        this.authorities = JwtRadarToken.emptyIfNull(jwt.getClaim(AUTHORITIES_CLAIM).asList(String.class));
        Claim scopeClaim = jwt.getClaim(SCOPE_CLAIM);
        String scopeClaimString = scopeClaim.asString();
        this.scopes = scopeClaimString != null ? Arrays.asList(scopeClaimString.split(" ")) : ((scopeClaimList = scopeClaim.asList(String.class)) != null ? scopeClaimList : Collections.emptyList());
        this.sources = JwtRadarToken.emptyIfNull(jwt.getClaim(SOURCES_CLAIM).asList(String.class));
        this.grantType = JwtRadarToken.emptyIfNull(jwt.getClaim(GRANT_TYPE_CLAIM).asString());
        this.subject = JwtRadarToken.emptyIfNull(jwt.getSubject());
        this.issuedAt = jwt.getIssuedAt();
        this.expiresAt = jwt.getExpiresAt();
        this.audience = JwtRadarToken.emptyIfNull(jwt.getAudience());
        this.token = JwtRadarToken.emptyIfNull(jwt.getToken());
        this.issuer = JwtRadarToken.emptyIfNull(jwt.getIssuer());
        this.type = JwtRadarToken.emptyIfNull(jwt.getType());
        this.clientId = jwt.getClaim(CLIENT_ID_CLAIM).asString();
    }

    @Override
    public Map<String, List<String>> getRoles() {
        return this.roles;
    }

    @Override
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public List<String> getSources() {
        return this.sources;
    }

    @Override
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public Date getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public List<String> getAudience() {
        return this.audience;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClaimString(String name) {
        return this.jwt.getClaim(name).asString();
    }

    @Override
    public List<String> getClaimList(String name) {
        try {
            return this.jwt.getClaim(name).asList(String.class);
        }
        catch (JWTDecodeException ex) {
            return null;
        }
    }

    private Map<String, List<String>> parseRoles(DecodedJWT jwt) {
        return JwtRadarToken.emptyIfNull(jwt.getClaim(ROLES_CLAIM).asList(String.class)).stream().filter(s -> s.contains(":")).distinct().map(ROLE_SEPARATOR_PATTERN::split).collect(Collectors.groupingBy(s -> s[0], Collectors.mapping(s -> s[1], Collectors.toList())));
    }

    private static String emptyIfNull(String string) {
        return string != null ? string : "";
    }

    private static List<String> emptyIfNull(List<String> list) {
        return list != null ? list : Collections.emptyList();
    }
}

