/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.crypto.generators;

import shadow.org.bouncycastle.crypto.CipherKeyGenerator;
import shadow.org.bouncycastle.crypto.KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.DESParameters;

public class DESKeyGenerator
extends CipherKeyGenerator {
    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(keyGenerationParameters);
        if (this.strength == 0 || this.strength == 7) {
            this.strength = 8;
        } else if (this.strength != 8) {
            throw new IllegalArgumentException("DES key must be 64 bits long.");
        }
    }

    public byte[] generateKey() {
        byte[] byArray = new byte[8];
        do {
            this.random.nextBytes(byArray);
            DESParameters.setOddParity(byArray);
        } while (DESParameters.isWeakKey(byArray, 0));
        return byArray;
    }
}

