/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.radarbase.auth.authorization.Permission;
import org.radarbase.auth.authorization.RoleAuthority;

public final class Permissions {
    private static final Map<Permission, Set<RoleAuthority>> PERMISSION_MATRIX = Permissions.createPermissions();

    private Permissions() {
    }

    public static Set<RoleAuthority> allowedRoles(Permission permission) {
        return PERMISSION_MATRIX.getOrDefault((Object)permission, Set.of());
    }

    public static Map<Permission, Set<RoleAuthority>> getPermissionMatrix() {
        return PERMISSION_MATRIX;
    }

    private static Map<Permission, Set<RoleAuthority>> createPermissions() {
        EnumMap rolePermissions = new EnumMap(RoleAuthority.class);
        rolePermissions.put(RoleAuthority.SYS_ADMIN, Permission.stream());
        rolePermissions.put(RoleAuthority.ORGANIZATION_ADMIN, Permission.stream().filter(Permissions.excludePermissions(Permission.ORGANIZATION_CREATE)).filter(Permissions.excludeEntities(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY, Permission.Entity.MEASUREMENT)).filter(Permissions.excludePermissions(Permission.SOURCEDATA_CREATE, Permission.SOURCETYPE_CREATE)));
        rolePermissions.put(RoleAuthority.PROJECT_ADMIN, Permission.stream().filter(Permissions.excludeEntities(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY)).filter(Permissions.excludeOtherEntityOperations(Permission.Entity.ORGANIZATION, Permission.Operation.READ)).filter(Permissions.excludePermissions(Permission.PROJECT_CREATE)));
        rolePermissions.put(RoleAuthority.PROJECT_OWNER, Permission.stream().filter(Permissions.excludeEntities(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY, Permission.Entity.USER)).filter(Permissions.excludeOtherEntityOperations(Permission.Entity.ORGANIZATION, Permission.Operation.READ)).filter(Permissions.excludePermissions(Permission.PROJECT_CREATE)));
        rolePermissions.put(RoleAuthority.PROJECT_AFFILIATE, Permission.stream().filter(Permissions.excludeEntities(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY, Permission.Entity.USER)).filter(Permissions.excludeOtherEntityOperations(Permission.Entity.ORGANIZATION, Permission.Operation.READ)).filter(Permissions.excludeOtherEntityOperations(Permission.Entity.PROJECT, Permission.Operation.READ)).filter(Permissions.excludePermissions(Permission.SUBJECT_DELETE)));
        rolePermissions.put(RoleAuthority.PROJECT_ANALYST, Permission.stream().filter(Permissions.excludeEntities(Permission.Entity.AUDIT, Permission.Entity.AUTHORITY, Permission.Entity.USER)).filter(p -> p.getOperation() == Permission.Operation.READ || p == Permission.SUBJECT_UPDATE));
        rolePermissions.put(RoleAuthority.PARTICIPANT, Stream.of(Permission.SUBJECT_READ, Permission.SUBJECT_UPDATE, Permission.MEASUREMENT_CREATE, Permission.MEASUREMENT_READ));
        rolePermissions.put(RoleAuthority.INACTIVE_PARTICIPANT, Stream.empty());
        return Collections.unmodifiableMap(rolePermissions.entrySet().stream().flatMap(rolePerm -> ((Stream)rolePerm.getValue()).map(p -> Map.entry(p, (RoleAuthority)rolePerm.getKey()))).collect(Collectors.groupingBy(Map.Entry::getKey, () -> new EnumMap(Permission.class), Collectors.mapping(Map.Entry::getValue, Permissions.toUnmodifiableEnumSet()))));
    }

    private static Collector<RoleAuthority, ?, Set<RoleAuthority>> toUnmodifiableEnumSet() {
        return Collectors.collectingAndThen(Collectors.toCollection(() -> EnumSet.noneOf(RoleAuthority.class)), Collections::unmodifiableSet);
    }

    private static Predicate<Permission> excludeOtherEntityOperations(Permission.Entity entity, Permission.Operation ... operations) {
        return p -> p.getEntity() != entity || Arrays.asList(operations).contains((Object)p.getOperation());
    }

    private static Predicate<Permission> excludePermissions(Permission ... permissions) {
        return p -> !Arrays.asList(permissions).contains(p);
    }

    private static Predicate<Permission> excludeEntities(Permission.Entity ... entities) {
        return p -> !Arrays.asList(entities).contains((Object)p.getEntity());
    }
}

