/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authorization;

import org.radarbase.auth.authorization.Permission;
import org.radarbase.auth.authorization.RoleAuthority;
import org.radarbase.auth.exception.NotAuthorizedException;
import org.radarbase.auth.token.RadarToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RadarAuthorization {
    private static final Logger log = LoggerFactory.getLogger(RadarAuthorization.class);

    private RadarAuthorization() {
    }

    public static void checkAuthority(RadarToken token, RoleAuthority authority) throws NotAuthorizedException {
        if (!token.isClientCredentials()) {
            log.debug("Checking authority {} for user {}", (Object)authority, (Object)token.getUsername());
            if (!token.hasAuthority(authority)) {
                throw new NotAuthorizedException(String.format("Request Client %s does not have authority %s", token.getUsername(), authority));
            }
        }
    }

    public static void checkAuthorityAndPermission(RadarToken token, RoleAuthority authority, Permission permission) throws NotAuthorizedException {
        log.debug("Checking authority {} and permission {} for user {}", new Object[]{authority, permission, token.getUsername()});
        RadarAuthorization.checkAuthority(token, authority);
        RadarAuthorization.checkPermission(token, permission);
    }

    public static void checkPermission(RadarToken token, Permission permission) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {}", (Object)permission.toString(), (Object)token.getUsername());
        if (!token.hasPermission(permission)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s", new Object[]{token.getUsername(), permission}));
        }
    }

    public static void checkGlobalPermission(RadarToken token, Permission permission) throws NotAuthorizedException {
        log.debug("Checking global permission {} for user {}", (Object)permission.toString(), (Object)token.getUsername());
        if (!token.hasGlobalPermission(permission)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s", new Object[]{token.getUsername(), permission}));
        }
    }

    public static void checkPermissionOnOrganization(RadarToken token, Permission permission, String organizationName) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} in organization {}", new Object[]{permission.toString(), token.getUsername(), organizationName});
        if (!token.hasPermissionOnOrganization(permission, organizationName)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s in organization %s", new Object[]{token.getUsername(), permission, organizationName}));
        }
    }

    public static void checkPermissionOnOrganizationAndProject(RadarToken token, Permission permission, String organization, String projectName) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} in organization {} and project {}", new Object[]{permission.toString(), token.getUsername(), organization, projectName});
        if (!token.hasPermissionOnOrganizationAndProject(permission, organization, projectName)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s in organization %s and project %s", new Object[]{token.getUsername(), permission, organization, projectName}));
        }
    }

    public static void checkPermissionOnProject(RadarToken token, Permission permission, String projectName) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} in project {}", new Object[]{permission.toString(), token.getUsername(), projectName});
        if (!token.hasPermissionOnProject(permission, projectName)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s in project %s", new Object[]{token.getUsername(), permission, projectName}));
        }
    }

    public static void checkPermissionOnSubject(RadarToken token, Permission permission, String projectName, String subjectName) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} on subject {} in project {}", new Object[]{permission.toString(), token.getUsername(), subjectName, projectName});
        if (!token.hasPermissionOnSubject(permission, projectName, subjectName)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s on subject %s in project %s", new Object[]{token.getUsername(), permission, subjectName, projectName}));
        }
    }

    public static void checkPermissionOnSource(RadarToken token, Permission permission, String projectName, String subjectName, String sourceId) throws NotAuthorizedException {
        log.debug("Checking permission {} for user {} on source {} of subject {} in project {}", new Object[]{permission.toString(), token.getUsername(), sourceId, subjectName, projectName});
        if (!token.hasPermissionOnSource(permission, projectName, subjectName, sourceId)) {
            throw new NotAuthorizedException(String.format("Client %s does not have permission %s on source %s of subject %s in project %s", new Object[]{token.getUsername(), permission, sourceId, subjectName, projectName}));
        }
    }
}

