/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authorization;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public enum RoleAuthority implements Serializable
{
    SYS_ADMIN(Scope.GLOBAL, false),
    PROJECT_ADMIN(Scope.PROJECT, false),
    PROJECT_OWNER(Scope.PROJECT, false),
    PROJECT_AFFILIATE(Scope.PROJECT, false),
    PROJECT_ANALYST(Scope.PROJECT, false),
    PARTICIPANT(Scope.PROJECT, true),
    INACTIVE_PARTICIPANT(Scope.PROJECT, true),
    ORGANIZATION_ADMIN(Scope.ORGANIZATION, false);

    public static final String SYS_ADMIN_AUTHORITY = "ROLE_SYS_ADMIN";
    private final Scope scope;
    private final boolean isPersonal;

    private RoleAuthority(Scope scope, boolean isPersonal) {
        this.scope = scope;
        this.isPersonal = isPersonal;
    }

    public Scope scope() {
        return this.scope;
    }

    public String authority() {
        return "ROLE_" + this.name();
    }

    public boolean isPersonal() {
        return this.isPersonal;
    }

    public static RoleAuthority valueOfAuthority(String authority) {
        String upperAuthority = authority.toUpperCase(Locale.ROOT);
        if (!upperAuthority.startsWith("ROLE_")) {
            throw new IllegalArgumentException("Cannot map role without 'ROLE_' prefix");
        }
        return RoleAuthority.valueOf(upperAuthority.substring(5));
    }

    public static RoleAuthority valueOfAuthorityOrNull(String authority) {
        if (authority == null) {
            return null;
        }
        try {
            return RoleAuthority.valueOfAuthority(authority);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T extends Enum<T>> Collector<T, ?, Set<T>> toEnumSet(Class<T> clazz) {
        return Collectors.toCollection(() -> EnumSet.noneOf(clazz));
    }

    public static enum Scope {
        GLOBAL,
        ORGANIZATION,
        PROJECT;

    }
}

