/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.radarbase.auth.config.TokenValidatorConfig;
import org.radarbase.auth.exception.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenVerifierPublicKeyConfig
implements TokenValidatorConfig {
    private static final Logger log = LoggerFactory.getLogger(TokenVerifierPublicKeyConfig.class);
    public static final String LOCATION_ENV = "RADAR_IS_CONFIG_LOCATION";
    private static final String CONFIG_FILE_NAME = "radar-is.yml";
    private List<URI> publicKeyEndpoints = List.of();
    private String resourceName;

    public static TokenVerifierPublicKeyConfig readFromFileOrClasspath() {
        TokenVerifierPublicKeyConfig tokenVerifierPublicKeyConfig;
        block13: {
            URL configFile;
            String customLocation = System.getenv(LOCATION_ENV);
            if (customLocation != null) {
                log.info("RADAR_IS_CONFIG_LOCATION environment variable set, loading config from {}", (Object)customLocation);
                try {
                    configFile = new File(customLocation).toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new ConfigurationException(ex);
                }
            } else {
                log.info("RADAR_IS_CONFIG_LOCATION environment variable not set, looking for it on the classpath");
                configFile = Thread.currentThread().getContextClassLoader().getResource(CONFIG_FILE_NAME);
                if (configFile == null) {
                    throw new ConfigurationException("Cannot find radar-is.yml file in classpath. ");
                }
            }
            log.info("Config file found at {}", (Object)configFile.getPath());
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            InputStream stream = configFile.openStream();
            try {
                tokenVerifierPublicKeyConfig = (TokenVerifierPublicKeyConfig)mapper.readValue(stream, TokenVerifierPublicKeyConfig.class);
                if (stream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ConfigurationException(ex);
                }
            }
            stream.close();
        }
        return tokenVerifierPublicKeyConfig;
    }

    @Override
    public List<URI> getPublicKeyEndpoints() {
        return this.publicKeyEndpoints;
    }

    public void setPublicKeyEndpoints(List<URI> publicKeyEndpoints) {
        log.info("Token public key endpoints set to " + publicKeyEndpoints.toString());
        this.publicKeyEndpoints = publicKeyEndpoints;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenVerifierPublicKeyConfig)) {
            return false;
        }
        TokenVerifierPublicKeyConfig that = (TokenVerifierPublicKeyConfig)o;
        return Objects.equals(this.publicKeyEndpoints, that.publicKeyEndpoints) && Objects.equals(this.resourceName, that.resourceName);
    }

    public int hashCode() {
        return Objects.hash(this.publicKeyEndpoints, this.resourceName);
    }
}

