/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.token;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.radarbase.auth.authorization.Permission;
import org.radarbase.auth.authorization.RoleAuthority;
import org.radarbase.auth.token.AuthorityReference;
import org.radarbase.auth.token.RadarToken;

public abstract class AbstractRadarToken
implements RadarToken {
    protected static final String CLIENT_CREDENTIALS = "client_credentials";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasAuthority(RoleAuthority authority) {
        if (this.isClientCredentials()) return true;
        if (!this.getRoleAuthorities().stream().anyMatch(authority::equals)) return false;
        return true;
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.hasScope(permission.scope()) && (this.isClientCredentials() || this.hasAuthorityForPermission(permission));
    }

    @Override
    public boolean hasGlobalPermission(Permission permission) {
        return this.hasScope(permission.scope()) && (this.isClientCredentials() || this.hasGlobalAuthorityForPermission(permission));
    }

    @Override
    public boolean hasPermissionOnOrganization(Permission permission, String organization) {
        return this.hasScope(permission.scope()) && (this.isClientCredentials() || this.hasAuthorityForOrganization(permission, organization));
    }

    @Override
    public boolean hasPermissionOnOrganizationAndProject(Permission permission, String organization, String projectName) {
        return this.hasScope(permission.scope()) && (this.isClientCredentials() || this.hasAuthorityForOrganizationAndProject(permission, organization, projectName));
    }

    @Override
    public boolean hasPermissionOnProject(Permission permission, String projectName) {
        return this.hasScope(permission.scope()) && (this.isClientCredentials() || this.hasAuthorityForProject(permission, projectName));
    }

    @Override
    public boolean hasPermissionOnSubject(Permission permission, String projectName, String subjectName) {
        return this.hasScope(permission.scope()) && (this.isClientCredentials() || this.hasAuthorityForSubject(permission, projectName, subjectName));
    }

    @Override
    public boolean hasPermissionOnSource(Permission permission, String projectName, String subjectName, String sourceId) {
        return this.hasScope(permission.scope()) && (this.isClientCredentials() || this.hasAuthorityForSource(permission, projectName, subjectName, sourceId));
    }

    protected boolean hasScope(String scope) {
        return this.getScopes().contains(scope);
    }

    @Override
    public boolean isClientCredentials() {
        return CLIENT_CREDENTIALS.equals(this.getGrantType());
    }

    protected boolean hasAuthorityForPermission(Permission permission) {
        return Stream.concat(this.getRoles().stream().map(AuthorityReference::getRole), this.getRoleAuthorities().stream()).anyMatch(permission::isRoleAllowed);
    }

    protected boolean hasAuthorityForOrganization(Permission permission, String organization) {
        if (this.hasGlobalAuthorityForPermission(permission)) {
            return true;
        }
        if (organization == null) {
            return false;
        }
        return this.getReferentsWithPermission(RoleAuthority.Scope.ORGANIZATION, permission).anyMatch(organization::equals);
    }

    protected boolean hasAuthorityForOrganizationAndProject(Permission permission, String organization, String projectName) {
        return this.hasAuthorityForOrganization(permission, organization) || this.hasAuthorityForProject(permission, projectName);
    }

    protected boolean hasAuthorityForProject(Permission permission, String projectName, Predicate<RoleAuthority> personalRoleCondition) {
        if (this.hasGlobalAuthorityForPermission(permission)) {
            return true;
        }
        if (projectName == null) {
            return false;
        }
        return this.getAuthorityReferencesWithPermission(RoleAuthority.Scope.PROJECT, permission).anyMatch(r -> projectName.equals(r.getReferent()) && (personalRoleCondition == null || !r.getRole().isPersonal() || personalRoleCondition.test(r.getRole())));
    }

    protected boolean hasAuthorityForProject(Permission permission, String projectName) {
        return this.hasAuthorityForProject(permission, projectName, p -> permission.getOperation() == Permission.Operation.READ);
    }

    protected boolean hasAuthorityForSubject(Permission permission, String projectName, String subjectName) {
        return this.hasAuthorityForProject(permission, projectName, role -> this.getUsername().equals(subjectName));
    }

    protected boolean hasAuthorityForSource(Permission permission, String projectName, String subjectName, String sourceId) {
        return this.hasAuthorityForProject(permission, projectName, role -> this.getUsername().equals(subjectName) && this.getSources().contains(sourceId));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.getToken(), ((AbstractRadarToken)other).getToken());
    }

    public int hashCode() {
        return Objects.hashCode(this.getToken());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{scopes=" + this.getScopes() + ", username='" + this.getUsername() + "', subject='" + this.getSubject() + "', roles=" + this.getRoles() + ", sources=" + this.getSources() + ", authorities=" + this.getAuthorities() + ", grantType='" + this.getGrantType() + "', audience=" + this.getAudience() + ", issuer='" + this.getIssuer() + "', issuedAt=" + this.getIssuedAt() + ", expiresAt=" + this.getExpiresAt() + ", type='" + this.getType() + "'}";
    }
}

