/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.token;

import java.io.Serializable;
import java.util.Objects;
import org.radarbase.auth.authorization.RoleAuthority;

public class AuthorityReference
implements Serializable {
    private final String authority;
    private final String referent;
    private final RoleAuthority role;

    public AuthorityReference(String authority) {
        this(authority, null);
    }

    public AuthorityReference(RoleAuthority role) {
        this(role, null);
    }

    public AuthorityReference(RoleAuthority role, String referent) {
        this.role = Objects.requireNonNull(role);
        this.authority = role.authority();
        this.referent = referent;
    }

    public AuthorityReference(String authority, String referent) {
        this.authority = Objects.requireNonNull(authority);
        this.role = RoleAuthority.valueOfAuthorityOrNull(authority);
        this.referent = referent;
    }

    public RoleAuthority getRole() {
        return this.role;
    }

    public String getReferent() {
        return this.referent;
    }

    public String getAuthority() {
        return this.authority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorityReference that = (AuthorityReference)o;
        return Objects.equals(this.referent, that.referent) && this.authority.equals(that.authority);
    }

    public int hashCode() {
        int result = this.referent != null ? this.referent.hashCode() : 0;
        result = 31 * result + this.authority.hashCode();
        return result;
    }
}

