/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.token;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.radarbase.auth.authorization.RoleAuthority;
import org.radarbase.auth.token.AbstractRadarToken;
import org.radarbase.auth.token.AuthorityReference;

public class JwtRadarToken
extends AbstractRadarToken {
    private static final Pattern ROLE_SEPARATOR_PATTERN = Pattern.compile(":");
    public static final String AUTHORITIES_CLAIM = "authorities";
    public static final String ROLES_CLAIM = "roles";
    public static final String SCOPE_CLAIM = "scope";
    public static final String SOURCES_CLAIM = "sources";
    public static final String GRANT_TYPE_CLAIM = "grant_type";
    public static final String CLIENT_ID_CLAIM = "client_id";
    public static final String USER_NAME_CLAIM = "user_name";
    private final Set<AuthorityReference> roles;
    private final List<String> authorities;
    private final List<String> scopes;
    private final List<String> sources;
    private final String grantType;
    private final String subject;
    private final Date issuedAt;
    private final Date expiresAt;
    private final List<String> audience;
    private final String token;
    private final String issuer;
    private final String type;
    private final String clientId;
    private final DecodedJWT jwt;
    private final String username;

    public JwtRadarToken(DecodedJWT jwt) {
        this.jwt = jwt;
        this.authorities = JwtRadarToken.emptyIfNull(jwt.getClaim(AUTHORITIES_CLAIM).asList(String.class));
        this.roles = Stream.concat(this.authorities.stream().map(RoleAuthority::valueOfAuthorityOrNull).filter(r -> r != null && r.scope() == RoleAuthority.Scope.GLOBAL).map(AuthorityReference::new), this.parseRoles(jwt)).collect(Collectors.toUnmodifiableSet());
        Claim scopeClaim = jwt.getClaim(SCOPE_CLAIM);
        String scopeClaimString = scopeClaim.asString();
        if (scopeClaimString != null) {
            this.scopes = Arrays.asList(scopeClaimString.split(" "));
        } else {
            List scopeClaimList = scopeClaim.asList(String.class);
            this.scopes = Objects.requireNonNullElseGet(scopeClaimList, Collections::emptyList);
        }
        this.sources = JwtRadarToken.emptyIfNull(jwt.getClaim(SOURCES_CLAIM).asList(String.class));
        this.grantType = JwtRadarToken.emptyIfNull(jwt.getClaim(GRANT_TYPE_CLAIM).asString());
        this.subject = JwtRadarToken.emptyIfNull(jwt.getSubject());
        this.username = JwtRadarToken.emptyIfNull(jwt.getClaim(USER_NAME_CLAIM).asString());
        this.issuedAt = jwt.getIssuedAt();
        this.expiresAt = jwt.getExpiresAt();
        this.audience = JwtRadarToken.emptyIfNull(jwt.getAudience());
        this.token = JwtRadarToken.emptyIfNull(jwt.getToken());
        this.issuer = JwtRadarToken.emptyIfNull(jwt.getIssuer());
        this.type = JwtRadarToken.emptyIfNull(jwt.getType());
        this.clientId = jwt.getClaim(CLIENT_ID_CLAIM).asString();
    }

    @Override
    public Set<AuthorityReference> getRoles() {
        return this.roles;
    }

    @Override
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public List<String> getSources() {
        return this.sources;
    }

    @Override
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public Date getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public List<String> getAudience() {
        return this.audience;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClaimString(String name) {
        return this.jwt.getClaim(name).asString();
    }

    @Override
    public List<String> getClaimList(String name) {
        try {
            return JwtRadarToken.emptyIfNull(this.jwt.getClaim(name).asList(String.class));
        }
        catch (JWTDecodeException ex) {
            return List.of();
        }
    }

    private Stream<AuthorityReference> parseRoles(DecodedJWT jwt) {
        return JwtRadarToken.emptyIfNull(jwt.getClaim(ROLES_CLAIM).asList(String.class)).stream().filter(s -> s != null && !s.isBlank()).map(ROLE_SEPARATOR_PATTERN::split).map(v -> ((String[])v).length == 1 || v[1].isEmpty() ? new AuthorityReference(v[0]) : new AuthorityReference(v[1], v[0]));
    }

    private static String emptyIfNull(String string) {
        return string != null ? string : "";
    }

    private static List<String> emptyIfNull(List<String> list) {
        return Objects.requireNonNullElseGet(list, Collections::emptyList);
    }
}

