/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.token;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.radarbase.auth.authorization.Permission;
import org.radarbase.auth.authorization.RoleAuthority;
import org.radarbase.auth.token.AuthorityReference;

public interface RadarToken {
    public Set<AuthorityReference> getRoles();

    default public Stream<AuthorityReference> getAuthorityReferencesWithPermission(RoleAuthority.Scope scope, Permission permission) {
        return this.getRoles().stream().filter(r -> r.getRole().scope() == scope && permission.isRoleAllowed(r.getRole()));
    }

    default public Stream<String> getReferentsWithPermission(RoleAuthority.Scope scope, Permission permission) {
        return this.getAuthorityReferencesWithPermission(scope, permission).map(AuthorityReference::getReferent).filter(Objects::nonNull);
    }

    default public boolean hasGlobalAuthorityForPermission(Permission permission) {
        return Stream.concat(this.getAuthorities().stream().map(RoleAuthority::valueOfAuthorityOrNull), this.getRoles().stream().map(AuthorityReference::getRole)).anyMatch(r -> r != null && r.scope() == RoleAuthority.Scope.GLOBAL && permission.isRoleAllowed((RoleAuthority)r));
    }

    public List<String> getAuthorities();

    default public Set<RoleAuthority> getRoleAuthorities() {
        return this.getAuthorities().stream().map(RoleAuthority::valueOfAuthorityOrNull).filter(Objects::nonNull).collect(RoleAuthority.toEnumSet(RoleAuthority.class));
    }

    public List<String> getScopes();

    public List<String> getSources();

    public String getGrantType();

    public String getSubject();

    public String getUsername();

    public Date getIssuedAt();

    public Date getExpiresAt();

    public List<String> getAudience();

    public String getToken();

    public String getIssuer();

    public String getType();

    public String getClientId();

    public String getClaimString(String var1);

    public List<String> getClaimList(String var1);

    public boolean hasAuthority(RoleAuthority var1);

    public boolean hasPermission(Permission var1);

    public boolean hasGlobalPermission(Permission var1);

    public boolean hasPermissionOnOrganization(Permission var1, String var2);

    public boolean hasPermissionOnOrganizationAndProject(Permission var1, String var2, String var3);

    public boolean hasPermissionOnProject(Permission var1, String var2);

    public boolean hasPermissionOnSubject(Permission var1, String var2, String var3);

    public boolean hasPermissionOnSource(Permission var1, String var2, String var3, String var4);

    public boolean isClientCredentials();
}

