/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authorization;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.auth.authorization.RoleAuthority;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/radarbase/auth/authorization/AuthorityReference;", "Ljava/io/Serializable;", "role", "Lorg/radarbase/auth/authorization/RoleAuthority;", "referent", "", "(Lorg/radarbase/auth/authorization/RoleAuthority;Ljava/lang/String;)V", "authority", "(Ljava/lang/String;Ljava/lang/String;)V", "(Lorg/radarbase/auth/authorization/RoleAuthority;Ljava/lang/String;Ljava/lang/String;)V", "getAuthority", "()Ljava/lang/String;", "getReferent", "getRole", "()Lorg/radarbase/auth/authorization/RoleAuthority;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "radar-auth"})
@SourceDebugExtension(value={"SMAP\nAuthorityReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorityReference.kt\norg/radarbase/auth/authorization/AuthorityReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class AuthorityReference
implements Serializable {
    @NotNull
    private final RoleAuthority role;
    @NotNull
    private final String authority;
    @Nullable
    private final String referent;

    public AuthorityReference(@NotNull RoleAuthority role, @NotNull String authority, @Nullable String referent) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        this.role = role;
        this.authority = authority;
        this.referent = referent;
        if (!(this.role.getScope() == RoleAuthority.Scope.GLOBAL || this.referent != null)) {
            boolean bl = false;
            String string = "Non-global authority references require a referent entity";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final RoleAuthority getRole() {
        return this.role;
    }

    @NotNull
    public final String getAuthority() {
        return this.authority;
    }

    @Nullable
    public final String getReferent() {
        return this.referent;
    }

    @JvmOverloads
    public AuthorityReference(@NotNull RoleAuthority role, @Nullable String referent) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this(role, role.getAuthority(), referent);
    }

    public /* synthetic */ AuthorityReference(RoleAuthority roleAuthority, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(roleAuthority, string);
    }

    @JvmOverloads
    public AuthorityReference(@NotNull String authority, @Nullable String referent) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        this(RoleAuthority.Companion.valueOfAuthority(authority), authority, referent);
    }

    public /* synthetic */ AuthorityReference(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final RoleAuthority component1() {
        return this.role;
    }

    @NotNull
    public final String component2() {
        return this.authority;
    }

    @Nullable
    public final String component3() {
        return this.referent;
    }

    @NotNull
    public final AuthorityReference copy(@NotNull RoleAuthority role, @NotNull String authority, @Nullable String referent) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return new AuthorityReference(role, authority, referent);
    }

    public static /* synthetic */ AuthorityReference copy$default(AuthorityReference authorityReference, RoleAuthority roleAuthority, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            roleAuthority = authorityReference.role;
        }
        if ((n & 2) != 0) {
            string = authorityReference.authority;
        }
        if ((n & 4) != 0) {
            string2 = authorityReference.referent;
        }
        return authorityReference.copy(roleAuthority, string, string2);
    }

    @NotNull
    public String toString() {
        return "AuthorityReference(role=" + this.role + ", authority=" + this.authority + ", referent=" + this.referent + ")";
    }

    public int hashCode() {
        int result2 = this.role.hashCode();
        result2 = result2 * 31 + this.authority.hashCode();
        result2 = result2 * 31 + (this.referent == null ? 0 : this.referent.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthorityReference)) {
            return false;
        }
        AuthorityReference authorityReference = (AuthorityReference)other;
        if (this.role != authorityReference.role) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authority, (Object)authorityReference.authority)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.referent, (Object)authorityReference.referent);
    }

    @JvmOverloads
    public AuthorityReference(@NotNull RoleAuthority role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this(role, null, 2, null);
    }

    @JvmOverloads
    public AuthorityReference(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        this(authority, null, 2, null);
    }
}

