/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.authorization;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003JC\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0006J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0006\u0010 \u001a\u00020\u0003J\t\u0010!\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\""}, d2={"Lorg/radarbase/auth/authorization/AuthorityReferenceSet;", "", "global", "", "organizations", "", "", "projects", "personalProjects", "(ZLjava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "allProjects", "getAllProjects", "()Ljava/util/Set;", "getGlobal", "()Z", "getOrganizations", "getPersonalProjects", "getProjects", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hasAnyProject", "project", "hasAnyProjects", "hasOrganization", "organization", "hashCode", "", "isEmpty", "toString", "radar-auth"})
public final class AuthorityReferenceSet {
    private final boolean global;
    @NotNull
    private final Set<String> organizations;
    @NotNull
    private final Set<String> projects;
    @NotNull
    private final Set<String> personalProjects;

    public AuthorityReferenceSet(boolean global, @NotNull Set<String> organizations, @NotNull Set<String> projects, @NotNull Set<String> personalProjects) {
        Intrinsics.checkNotNullParameter(organizations, (String)"organizations");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Intrinsics.checkNotNullParameter(personalProjects, (String)"personalProjects");
        this.global = global;
        this.organizations = organizations;
        this.projects = projects;
        this.personalProjects = personalProjects;
    }

    public /* synthetic */ AuthorityReferenceSet(boolean bl, Set set, Set set2, Set set3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            set3 = SetsKt.emptySet();
        }
        this(bl, set, set2, set3);
    }

    public final boolean getGlobal() {
        return this.global;
    }

    @NotNull
    public final Set<String> getOrganizations() {
        return this.organizations;
    }

    @NotNull
    public final Set<String> getProjects() {
        return this.projects;
    }

    @NotNull
    public final Set<String> getPersonalProjects() {
        return this.personalProjects;
    }

    public final boolean isEmpty() {
        return !this.global && this.organizations.isEmpty() && this.projects.isEmpty();
    }

    public final boolean hasOrganization(@NotNull String organization) {
        Intrinsics.checkNotNullParameter((Object)organization, (String)"organization");
        return this.organizations.contains(organization);
    }

    @NotNull
    public final Set<String> getAllProjects() {
        return SetsKt.plus(this.projects, (Iterable)this.personalProjects);
    }

    public final boolean hasAnyProject(@NotNull String project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.projects.contains(project) || this.personalProjects.contains(project);
    }

    public final boolean hasAnyProjects() {
        return !((Collection)this.projects).isEmpty() || !((Collection)this.personalProjects).isEmpty();
    }

    public final boolean component1() {
        return this.global;
    }

    @NotNull
    public final Set<String> component2() {
        return this.organizations;
    }

    @NotNull
    public final Set<String> component3() {
        return this.projects;
    }

    @NotNull
    public final Set<String> component4() {
        return this.personalProjects;
    }

    @NotNull
    public final AuthorityReferenceSet copy(boolean global, @NotNull Set<String> organizations, @NotNull Set<String> projects, @NotNull Set<String> personalProjects) {
        Intrinsics.checkNotNullParameter(organizations, (String)"organizations");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Intrinsics.checkNotNullParameter(personalProjects, (String)"personalProjects");
        return new AuthorityReferenceSet(global, organizations, projects, personalProjects);
    }

    public static /* synthetic */ AuthorityReferenceSet copy$default(AuthorityReferenceSet authorityReferenceSet, boolean bl, Set set, Set set2, Set set3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = authorityReferenceSet.global;
        }
        if ((n & 2) != 0) {
            set = authorityReferenceSet.organizations;
        }
        if ((n & 4) != 0) {
            set2 = authorityReferenceSet.projects;
        }
        if ((n & 8) != 0) {
            set3 = authorityReferenceSet.personalProjects;
        }
        return authorityReferenceSet.copy(bl, set, set2, set3);
    }

    @NotNull
    public String toString() {
        return "AuthorityReferenceSet(global=" + this.global + ", organizations=" + this.organizations + ", projects=" + this.projects + ", personalProjects=" + this.personalProjects + ")";
    }

    public int hashCode() {
        int n = this.global ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + ((Object)this.organizations).hashCode();
        result2 = result2 * 31 + ((Object)this.projects).hashCode();
        result2 = result2 * 31 + ((Object)this.personalProjects).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthorityReferenceSet)) {
            return false;
        }
        AuthorityReferenceSet authorityReferenceSet = (AuthorityReferenceSet)other;
        if (this.global != authorityReferenceSet.global) {
            return false;
        }
        if (!Intrinsics.areEqual(this.organizations, authorityReferenceSet.organizations)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.projects, authorityReferenceSet.projects)) {
            return false;
        }
        return Intrinsics.areEqual(this.personalProjects, authorityReferenceSet.personalProjects);
    }

    public AuthorityReferenceSet() {
        this(false, null, null, null, 15, null);
    }
}

