/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.jwks;

import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.auth.exception.InvalidPublicKeyException;
import org.radarbase.auth.jwks.ECDSAJsonWebKey$;
import org.radarbase.auth.jwks.JsonWebKey;

@Serializable
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 82\u00020\u0001:\u0003789By\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011Bc\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0012J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003Jo\u0010'\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00052\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0006\u0010(\u001a\u00020)J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001J\t\u0010/\u001a\u00020\u0005H\u00d6\u0001J!\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u00c7\u0001R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014\u00a8\u0006:"}, d2={"Lorg/radarbase/auth/jwks/ECDSAJsonWebKey;", "Lorg/radarbase/auth/jwks/JsonWebKey;", "seen1", "", "alg", "", "kty", "kid", "use", "x", "y", "crv", "x5c", "", "x5t", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getAlg", "()Ljava/lang/String;", "getCrv", "getKid", "getKty", "getUse", "getX", "getX5c", "()Ljava/util/List;", "getX5t", "getY", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "curve", "Lorg/radarbase/auth/jwks/ECDSAJsonWebKey$Curve;", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "Curve", "radar-auth"})
public final class ECDSAJsonWebKey
implements JsonWebKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String alg;
    @NotNull
    private final String kty;
    @Nullable
    private final String kid;
    @NotNull
    private final String use;
    @NotNull
    private final String x;
    @NotNull
    private final String y;
    @NotNull
    private final String crv;
    @NotNull
    private final List<String> x5c;
    @Nullable
    private final String x5t;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public ECDSAJsonWebKey(@Nullable String alg, @NotNull String kty, @Nullable String kid, @NotNull String use, @NotNull String x, @NotNull String y, @NotNull String crv, @NotNull List<String> x5c, @Nullable String x5t) {
        Intrinsics.checkNotNullParameter((Object)kty, (String)"kty");
        Intrinsics.checkNotNullParameter((Object)use, (String)"use");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)crv, (String)"crv");
        Intrinsics.checkNotNullParameter(x5c, (String)"x5c");
        this.alg = alg;
        this.kty = kty;
        this.kid = kid;
        this.use = use;
        this.x = x;
        this.y = y;
        this.crv = crv;
        this.x5c = x5c;
        this.x5t = x5t;
    }

    public /* synthetic */ ECDSAJsonWebKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, List list, String string8, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = "sig";
        }
        if ((n & 0x80) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        this(string, string2, string3, string4, string5, string6, string7, list, string8);
    }

    @Override
    @Nullable
    public String getAlg() {
        return this.alg;
    }

    @Override
    @NotNull
    public String getKty() {
        return this.kty;
    }

    @Nullable
    public final String getKid() {
        return this.kid;
    }

    @NotNull
    public final String getUse() {
        return this.use;
    }

    @NotNull
    public final String getX() {
        return this.x;
    }

    @NotNull
    public final String getY() {
        return this.y;
    }

    @NotNull
    public final String getCrv() {
        return this.crv;
    }

    @Override
    @NotNull
    public List<String> getX5c() {
        return this.x5c;
    }

    @Override
    @Nullable
    public String getX5t() {
        return this.x5t;
    }

    @NotNull
    public final Curve curve() {
        Curve curve;
        if (this.getAlg() != null) {
            String string = this.getAlg().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return Curve.valueOf(string);
        }
        switch (this.crv) {
            case "P-256": {
                curve = Curve.ES256;
                break;
            }
            case "P-384": {
                curve = Curve.ES384;
                break;
            }
            case "P-512": 
            case "P-521": {
                curve = Curve.ES512;
                break;
            }
            default: {
                throw new InvalidPublicKeyException("Unknown EC crv " + this.crv);
            }
        }
        return curve;
    }

    @Nullable
    public final String component1() {
        return this.alg;
    }

    @NotNull
    public final String component2() {
        return this.kty;
    }

    @Nullable
    public final String component3() {
        return this.kid;
    }

    @NotNull
    public final String component4() {
        return this.use;
    }

    @NotNull
    public final String component5() {
        return this.x;
    }

    @NotNull
    public final String component6() {
        return this.y;
    }

    @NotNull
    public final String component7() {
        return this.crv;
    }

    @NotNull
    public final List<String> component8() {
        return this.x5c;
    }

    @Nullable
    public final String component9() {
        return this.x5t;
    }

    @NotNull
    public final ECDSAJsonWebKey copy(@Nullable String alg, @NotNull String kty, @Nullable String kid, @NotNull String use, @NotNull String x, @NotNull String y, @NotNull String crv, @NotNull List<String> x5c, @Nullable String x5t) {
        Intrinsics.checkNotNullParameter((Object)kty, (String)"kty");
        Intrinsics.checkNotNullParameter((Object)use, (String)"use");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)crv, (String)"crv");
        Intrinsics.checkNotNullParameter(x5c, (String)"x5c");
        return new ECDSAJsonWebKey(alg, kty, kid, use, x, y, crv, x5c, x5t);
    }

    public static /* synthetic */ ECDSAJsonWebKey copy$default(ECDSAJsonWebKey eCDSAJsonWebKey, String string, String string2, String string3, String string4, String string5, String string6, String string7, List list, String string8, int n, Object object) {
        if ((n & 1) != 0) {
            string = eCDSAJsonWebKey.alg;
        }
        if ((n & 2) != 0) {
            string2 = eCDSAJsonWebKey.kty;
        }
        if ((n & 4) != 0) {
            string3 = eCDSAJsonWebKey.kid;
        }
        if ((n & 8) != 0) {
            string4 = eCDSAJsonWebKey.use;
        }
        if ((n & 0x10) != 0) {
            string5 = eCDSAJsonWebKey.x;
        }
        if ((n & 0x20) != 0) {
            string6 = eCDSAJsonWebKey.y;
        }
        if ((n & 0x40) != 0) {
            string7 = eCDSAJsonWebKey.crv;
        }
        if ((n & 0x80) != 0) {
            list = eCDSAJsonWebKey.x5c;
        }
        if ((n & 0x100) != 0) {
            string8 = eCDSAJsonWebKey.x5t;
        }
        return eCDSAJsonWebKey.copy(string, string2, string3, string4, string5, string6, string7, list, string8);
    }

    @NotNull
    public String toString() {
        return "ECDSAJsonWebKey(alg=" + this.alg + ", kty=" + this.kty + ", kid=" + this.kid + ", use=" + this.use + ", x=" + this.x + ", y=" + this.y + ", crv=" + this.crv + ", x5c=" + this.x5c + ", x5t=" + this.x5t + ")";
    }

    public int hashCode() {
        int result2 = this.alg == null ? 0 : this.alg.hashCode();
        result2 = result2 * 31 + this.kty.hashCode();
        result2 = result2 * 31 + (this.kid == null ? 0 : this.kid.hashCode());
        result2 = result2 * 31 + this.use.hashCode();
        result2 = result2 * 31 + this.x.hashCode();
        result2 = result2 * 31 + this.y.hashCode();
        result2 = result2 * 31 + this.crv.hashCode();
        result2 = result2 * 31 + ((Object)this.x5c).hashCode();
        result2 = result2 * 31 + (this.x5t == null ? 0 : this.x5t.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ECDSAJsonWebKey)) {
            return false;
        }
        ECDSAJsonWebKey eCDSAJsonWebKey = (ECDSAJsonWebKey)other;
        if (!Intrinsics.areEqual((Object)this.alg, (Object)eCDSAJsonWebKey.alg)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kty, (Object)eCDSAJsonWebKey.kty)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kid, (Object)eCDSAJsonWebKey.kid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.use, (Object)eCDSAJsonWebKey.use)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.x, (Object)eCDSAJsonWebKey.x)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.y, (Object)eCDSAJsonWebKey.y)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.crv, (Object)eCDSAJsonWebKey.crv)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.x5c, eCDSAJsonWebKey.x5c)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.x5t, (Object)eCDSAJsonWebKey.x5t);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(ECDSAJsonWebKey self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.getAlg() != null) {
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getAlg());
        }
        output.encodeStringElement(serialDesc, 1, self.getKty());
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.kid != null) {
            output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.kid);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual((Object)self.use, (Object)"sig")) {
            output.encodeStringElement(serialDesc, 3, self.use);
        }
        output.encodeStringElement(serialDesc, 4, self.x);
        output.encodeStringElement(serialDesc, 5, self.y);
        output.encodeStringElement(serialDesc, 6, self.crv);
        if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : !Intrinsics.areEqual(self.getX5c(), (Object)CollectionsKt.emptyList())) {
            output.encodeSerializableElement(serialDesc, 7, (SerializationStrategy)kSerializerArray[7], self.getX5c());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.getX5t() != null) {
            output.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getX5t());
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ ECDSAJsonWebKey(int seen1, String alg, String kty, String kid, String use, String x, String y, String crv, List x5c, String x5t, SerializationConstructorMarker serializationConstructorMarker) {
        if (114 != (0x72 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)114, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.alg = (seen1 & 1) == 0 ? null : alg;
        this.kty = kty;
        this.kid = (seen1 & 4) == 0 ? null : kid;
        this.use = (seen1 & 8) == 0 ? "sig" : use;
        this.x = x;
        this.y = y;
        this.crv = crv;
        this.x5c = (seen1 & 0x80) == 0 ? CollectionsKt.emptyList() : x5c;
        this.x5t = (seen1 & 0x100) == 0 ? null : x5t;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{null, null, null, null, null, null, null, new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/radarbase/auth/jwks/ECDSAJsonWebKey$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/radarbase/auth/jwks/ECDSAJsonWebKey;", "radar-auth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ECDSAJsonWebKey> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/radarbase/auth/jwks/ECDSAJsonWebKey$Curve;", "", "ecStdName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getEcStdName", "()Ljava/lang/String;", "ES256", "ES384", "ES512", "radar-auth"})
    public static final class Curve
    extends Enum<Curve> {
        @NotNull
        private final String ecStdName;
        public static final /* enum */ Curve ES256 = new Curve("secp256r1");
        public static final /* enum */ Curve ES384 = new Curve("secp384r1");
        public static final /* enum */ Curve ES512 = new Curve("secp521r1");
        private static final /* synthetic */ Curve[] $VALUES;

        private Curve(String ecStdName) {
            this.ecStdName = ecStdName;
        }

        @NotNull
        public final String getEcStdName() {
            return this.ecStdName;
        }

        public static Curve[] values() {
            return (Curve[])$VALUES.clone();
        }

        public static Curve valueOf(String value) {
            return Enum.valueOf(Curve.class, value);
        }

        static {
            $VALUES = curveArray = new Curve[]{Curve.ES256, Curve.ES384, Curve.ES512};
        }
    }
}

