/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.jwks;

import com.auth0.jwt.algorithms.Algorithm;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.radarbase.auth.jwks.ECDSAJsonWebKey;
import org.radarbase.auth.jwks.RSAJsonWebKey;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"toAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "Ljava/security/interfaces/ECPublicKey;", "keySize", "Lorg/radarbase/auth/jwks/ECDSAJsonWebKey$Curve;", "Ljava/security/interfaces/RSAPublicKey;", "hashSize", "Lorg/radarbase/auth/jwks/RSAJsonWebKey$HashSize;", "radar-auth"})
public final class ExtensionsKt {
    @NotNull
    public static final Algorithm toAlgorithm(@NotNull RSAPublicKey $this$toAlgorithm, @NotNull RSAJsonWebKey.HashSize hashSize) {
        Algorithm algorithm;
        Intrinsics.checkNotNullParameter((Object)$this$toAlgorithm, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hashSize), (String)"hashSize");
        switch (WhenMappings.$EnumSwitchMapping$0[hashSize.ordinal()]) {
            case 1: {
                Algorithm algorithm2 = Algorithm.RSA256((RSAPublicKey)$this$toAlgorithm, null);
                algorithm = algorithm2;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm2, (String)"RSA256(this, null)");
                break;
            }
            case 2: {
                Algorithm algorithm3 = Algorithm.RSA384((RSAPublicKey)$this$toAlgorithm, null);
                algorithm = algorithm3;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm3, (String)"RSA384(this, null)");
                break;
            }
            case 3: {
                Algorithm algorithm4 = Algorithm.RSA512((RSAPublicKey)$this$toAlgorithm, null);
                algorithm = algorithm4;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm4, (String)"RSA512(this, null)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return algorithm;
    }

    public static /* synthetic */ Algorithm toAlgorithm$default(RSAPublicKey rSAPublicKey, RSAJsonWebKey.HashSize hashSize, int n, Object object) {
        if ((n & 1) != 0) {
            hashSize = RSAJsonWebKey.HashSize.RS256;
        }
        return ExtensionsKt.toAlgorithm(rSAPublicKey, hashSize);
    }

    @NotNull
    public static final Algorithm toAlgorithm(@NotNull ECPublicKey $this$toAlgorithm) {
        ECDSAJsonWebKey.Curve curve;
        Intrinsics.checkNotNullParameter((Object)$this$toAlgorithm, (String)"<this>");
        int orderLength = $this$toAlgorithm.getParams().getOrder().bitLength();
        boolean bl = 0 <= orderLength ? orderLength < 257 : false;
        if (bl) {
            curve = ECDSAJsonWebKey.Curve.ES256;
        } else {
            boolean bl2 = 257 <= orderLength ? orderLength < 385 : false;
            if (bl2) {
                curve = ECDSAJsonWebKey.Curve.ES384;
            } else {
                boolean bl3 = 385 <= orderLength ? orderLength < 522 : false;
                if (bl3) {
                    curve = ECDSAJsonWebKey.Curve.ES512;
                } else {
                    throw new IllegalArgumentException("Unknown ECDSA order length " + orderLength);
                }
            }
        }
        ECDSAJsonWebKey.Curve keySize = curve;
        return ExtensionsKt.toAlgorithm($this$toAlgorithm, keySize);
    }

    @NotNull
    public static final Algorithm toAlgorithm(@NotNull ECPublicKey $this$toAlgorithm, @NotNull ECDSAJsonWebKey.Curve keySize) {
        Algorithm algorithm;
        Intrinsics.checkNotNullParameter((Object)$this$toAlgorithm, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)keySize), (String)"keySize");
        switch (WhenMappings.$EnumSwitchMapping$1[keySize.ordinal()]) {
            case 1: {
                Algorithm algorithm2 = Algorithm.ECDSA256((ECPublicKey)$this$toAlgorithm, null);
                algorithm = algorithm2;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm2, (String)"ECDSA256(this, null)");
                break;
            }
            case 2: {
                Algorithm algorithm3 = Algorithm.ECDSA384((ECPublicKey)$this$toAlgorithm, null);
                algorithm = algorithm3;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm3, (String)"ECDSA384(this, null)");
                break;
            }
            case 3: {
                Algorithm algorithm4 = Algorithm.ECDSA512((ECPublicKey)$this$toAlgorithm, null);
                algorithm = algorithm4;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm4, (String)"ECDSA512(this, null)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return algorithm;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RSAJsonWebKey.HashSize.values().length];
            try {
                nArray[RSAJsonWebKey.HashSize.RS256.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RSAJsonWebKey.HashSize.RS384.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RSAJsonWebKey.HashSize.RS512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ECDSAJsonWebKey.Curve.values().length];
            try {
                nArray[ECDSAJsonWebKey.Curve.ES256.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ECDSAJsonWebKey.Curve.ES384.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ECDSAJsonWebKey.Curve.ES512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

