/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.jwks;

import com.auth0.jwt.algorithms.Algorithm;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.radarbase.auth.exception.InvalidPublicKeyException;
import org.radarbase.auth.exception.TokenValidationException;
import org.radarbase.auth.jwks.ECDSAJsonWebKey;
import org.radarbase.auth.jwks.ECPEMCertificateParser;
import org.radarbase.auth.jwks.ExtensionsKt;
import org.radarbase.auth.jwks.JsonWebKey;
import org.radarbase.auth.jwks.JwkAlgorithmParser;
import org.radarbase.auth.jwks.JwkParser;
import org.radarbase.auth.jwks.MPJsonWebKey;
import org.radarbase.auth.jwks.PEMCertificateParser;
import org.radarbase.auth.jwks.RSAJsonWebKey;
import org.radarbase.auth.jwks.RSAPEMCertificateParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/radarbase/auth/jwks/JwkAlgorithmParser;", "Lorg/radarbase/auth/jwks/JwkParser;", "()V", "supportedAlgorithmsForWebKeySets", "", "Lorg/radarbase/auth/jwks/PEMCertificateParser;", "(Ljava/util/List;)V", "parse", "Lcom/auth0/jwt/algorithms/Algorithm;", "key", "Lorg/radarbase/auth/jwks/JsonWebKey;", "toString", "", "radar-auth"})
@SourceDebugExtension(value={"SMAP\nJwkAlgorithmParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwkAlgorithmParser.kt\norg/radarbase/auth/jwks/JwkAlgorithmParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n288#2,2:85\n*S KotlinDebug\n*F\n+ 1 JwkAlgorithmParser.kt\norg/radarbase/auth/jwks/JwkAlgorithmParser\n*L\n39#1:85,2\n*E\n"})
public final class JwkAlgorithmParser
implements JwkParser {
    @NotNull
    private final List<PEMCertificateParser> supportedAlgorithmsForWebKeySets;

    public JwkAlgorithmParser(@NotNull List<? extends PEMCertificateParser> supportedAlgorithmsForWebKeySets) {
        Intrinsics.checkNotNullParameter(supportedAlgorithmsForWebKeySets, (String)"supportedAlgorithmsForWebKeySets");
        this.supportedAlgorithmsForWebKeySets = supportedAlgorithmsForWebKeySets;
    }

    public JwkAlgorithmParser() {
        Object[] objectArray = new PEMCertificateParser[]{new ECPEMCertificateParser(), new RSAPEMCertificateParser()};
        this(CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Algorithm parse(@NotNull JsonWebKey key) {
        Algorithm algorithm;
        Object object;
        JsonWebKey jsonWebKey;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!((Collection)key.getX5c()).isEmpty()) {
            PEMCertificateParser x5cAlgorithm;
            block13: {
                PEMCertificateParser pEMCertificateParser;
                for (PEMCertificateParser parser : (Iterable)this.supportedAlgorithmsForWebKeySets) {
                    void var7_10;
                    boolean bl = false;
                    try {
                        Algorithm algorithm2 = parser.parseAlgorithm(key.getX5c().get(0));
                    }
                    catch (Exception ex) {
                        Object var7_12 = null;
                    }
                    if ((parser = var7_10) == null) continue;
                    pEMCertificateParser = parser;
                    break block13;
                }
                pEMCertificateParser = x5cAlgorithm = null;
            }
            if (x5cAlgorithm != null) {
                return x5cAlgorithm;
            }
        }
        if ((jsonWebKey = key) instanceof MPJsonWebKey) {
            Object v1;
            Algorithm $this$firstOrNull$iv;
            block14: {
                Iterable iterable = this.supportedAlgorithmsForWebKeySets;
                boolean $i$f$firstOrNull = false;
                for (Object t : $this$firstOrNull$iv) {
                    PEMCertificateParser algorithm3 = (PEMCertificateParser)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)((MPJsonWebKey)key).getValue(), (String)algorithm3.getKeyHeader(), (boolean)false, (int)2, null)) continue;
                    v1 = t;
                    break block14;
                }
                v1 = null;
            }
            PEMCertificateParser pEMCertificateParser = v1;
            if (pEMCertificateParser == null || ($this$firstOrNull$iv = pEMCertificateParser.parseAlgorithm(((MPJsonWebKey)key).getValue())) == null) throw new TokenValidationException("Unsupported public key: " + key);
            object = $this$firstOrNull$iv;
            return object;
        }
        if (jsonWebKey instanceof RSAJsonWebKey) {
            KeyFactory keyFactory;
            try {
                KeyFactory keyFactory2 = KeyFactory.getInstance("RSA");
                Intrinsics.checkNotNullExpressionValue((Object)keyFactory2, (String)"getInstance(ALGORITHM_RSA)");
                keyFactory = keyFactory2;
                RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(new BigInteger(1, Base64.getUrlDecoder().decode(((RSAJsonWebKey)key).getN())), new BigInteger(1, Base64.getUrlDecoder().decode(((RSAJsonWebKey)key).getE())));
                PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
                Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                keyFactory = ExtensionsKt.toAlgorithm((RSAPublicKey)publicKey, ((RSAJsonWebKey)key).keySize());
            }
            catch (GeneralSecurityException e) {
                throw new InvalidPublicKeyException("Invalid public key", e);
            }
            object = keyFactory;
            return object;
        }
        if (!(jsonWebKey instanceof ECDSAJsonWebKey)) throw new NoWhenBranchMatchedException();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            ECDSAJsonWebKey.Curve keySize = ((ECDSAJsonWebKey)key).curve();
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
            ECPoint eCPoint = new ECPoint(new BigInteger(1, Base64.getUrlDecoder().decode(((ECDSAJsonWebKey)key).getX())), new BigInteger(1, Base64.getUrlDecoder().decode(((ECDSAJsonWebKey)key).getY())));
            boolean bl = false;
            algorithmParameters.init(new ECGenParameterSpec(keySize.getEcStdName()));
            ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
            ECPoint eCPoint2 = eCPoint;
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(eCPoint2, eCParameterSpec);
            PublicKey publicKey = keyFactory.generatePublic(ecPublicKeySpec);
            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            algorithm = ExtensionsKt.toAlgorithm((ECPublicKey)publicKey, ((ECDSAJsonWebKey)key).curve());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidPublicKeyException("Invalid algorithm to generate key", e);
        }
        catch (GeneralSecurityException e) {
            throw new InvalidPublicKeyException("Invalid public key", e);
        }
        object = algorithm;
        return object;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        int n = 50;
        StringBuilder $this$toString_u24lambda_u243 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$toString_u24lambda_u243.append("JwkAlgorithmParser<algorithms=");
        CollectionsKt.joinTo$default((Iterable)this.supportedAlgorithmsForWebKeySets, (Appendable)$this$toString_u24lambda_u243, (CharSequence)", ", null, null, (int)0, null, (Function1)toString.1.1.INSTANCE, (int)60, null);
        $this$toString_u24lambda_u243.append('>');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }
}

