/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.jwks;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Verification;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.cio.CIO;
import io.ktor.client.plugins.DefaultRequest;
import io.ktor.client.plugins.DefaultRequestKt;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.auth.authentication.TokenVerifier;
import org.radarbase.auth.authentication.TokenVerifierLoader;
import org.radarbase.auth.exception.TokenValidationException;
import org.radarbase.auth.jwks.JsonWebKey;
import org.radarbase.auth.jwks.JsonWebKeySet;
import org.radarbase.auth.jwks.JwkParser;
import org.radarbase.auth.jwks.JwksTokenVerifierLoader;
import org.radarbase.auth.jwt.JwtTokenVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u000e\u001a\u00020\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/radarbase/auth/jwks/JwksTokenVerifierLoader;", "Lorg/radarbase/auth/authentication/TokenVerifierLoader;", "url", "", "resourceName", "algorithmParser", "Lorg/radarbase/auth/jwks/JwkParser;", "(Ljava/lang/String;Ljava/lang/String;Lorg/radarbase/auth/jwks/JwkParser;)V", "httpClient", "Lio/ktor/client/HttpClient;", "fetch", "", "Lorg/radarbase/auth/authentication/TokenVerifier;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchPublicKeyInfo", "Lorg/radarbase/auth/jwks/JsonWebKeySet;", "toString", "Companion", "radar-auth"})
@SourceDebugExtension(value={"SMAP\nJwksTokenVerifierLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwksTokenVerifierLoader.kt\norg/radarbase/auth/jwks/JwksTokenVerifierLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1855#2,2:100\n*S KotlinDebug\n*F\n+ 1 JwksTokenVerifierLoader.kt\norg/radarbase/auth/jwks/JwksTokenVerifierLoader\n*L\n57#1:100,2\n*E\n"})
public final class JwksTokenVerifierLoader
implements TokenVerifierLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final String resourceName;
    @NotNull
    private final JwkParser algorithmParser;
    @NotNull
    private final HttpClient httpClient;
    private static final Logger logger = LoggerFactory.getLogger(JwksTokenVerifierLoader.class);

    public JwksTokenVerifierLoader(@NotNull String url, @NotNull String resourceName, @NotNull JwkParser algorithmParser) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter((Object)algorithmParser, (String)"algorithmParser");
        this.url = url;
        this.resourceName = resourceName;
        this.algorithmParser = algorithmParser;
        this.httpClient = HttpClientKt.HttpClient$default((HttpClientEngineFactory)((HttpClientEngineFactory)CIO.INSTANCE), null, (int)2, null).config(new Function1<HttpClientConfig<?>, Unit>(this){
            final /* synthetic */ JwksTokenVerifierLoader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HttpClientConfig<?> $this$config) {
                Intrinsics.checkNotNullParameter($this$config, (String)"$this$config");
                $this$config.install((HttpClientPlugin)HttpTimeout.Plugin, (Function1)httpClient.1.INSTANCE);
                $this$config.install((HttpClientPlugin)ContentNegotiation.Plugin, (Function1)httpClient.2.INSTANCE);
                DefaultRequestKt.defaultRequest($this$config, (Function1)((Function1)new Function1<DefaultRequest.DefaultRequestBuilder, Unit>(this.this$0){
                    final /* synthetic */ JwksTokenVerifierLoader this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DefaultRequest.DefaultRequestBuilder $this$defaultRequest) {
                        Intrinsics.checkNotNullParameter((Object)$this$defaultRequest, (String)"$this$defaultRequest");
                        $this$defaultRequest.url(JwksTokenVerifierLoader.access$getUrl$p(this.this$0));
                        UtilsKt.accept((HttpMessageBuilder)((HttpMessageBuilder)$this$defaultRequest), (ContentType)ContentType.Application.INSTANCE.getJson());
                    }
                }));
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super List<? extends TokenVerifier>> var1_1) {
        if (!(var1_1 instanceof fetch.1)) ** GOTO lbl-1000
        var15_2 = var1_1;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ JwksTokenVerifierLoader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetch((Continuation<? super List<? extends TokenVerifier>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.fetchPublicKeyInfo((Continuation<? super JsonWebKeySet>)$continuation);
                ** if (v0 != var16_4) goto lbl19
lbl18:
                // 1 sources

                return var16_4;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                this = (JwksTokenVerifierLoader)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    var3_5 = (JsonWebKeySet)v0;
                }
                catch (Exception ex) {
                    JwksTokenVerifierLoader.logger.warn("Failed to fetch token for {}: {}", (Object)this.url, (Object)ex.getMessage());
                    return CollectionsKt.emptyList();
                }
                keySet = var3_5;
                $this$fetch_u24lambda_u241 = var4_7 = CollectionsKt.createListBuilder((int)keySet.getKeys().size());
                $i$a$-buildList-JwksTokenVerifierLoader$fetch$2 = false;
                $this$forEach$iv = keySet.getKeys();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    key = (JsonWebKey)element$iv;
                    $i$a$-forEach-JwksTokenVerifierLoader$fetch$2$1 = false;
                    try {
                        $this$fetch_u24lambda_u241.add(org.radarbase.auth.jwks.JwksTokenVerifierLoader$Companion.toTokenVerifier$default(JwksTokenVerifierLoader.Companion, this.algorithmParser.parse(key), this.resourceName, null, 2, null));
                    }
                    catch (Exception ex) {
                        JwksTokenVerifierLoader.logger.error("Failed to parse key from {}: {}", (Object)this.url, (Object)ex.getMessage());
                    }
                }
                return CollectionsKt.build((List)var4_7);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object fetchPublicKeyInfo(Continuation<? super JsonWebKeySet> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JsonWebKeySet>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ JwksTokenVerifierLoader this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        JwksTokenVerifierLoader.access$getLogger$cp().info("Getting the JWT public key at {}", (Object)JwksTokenVerifierLoader.access$getUrl$p(this.this$0));
                        $this$request_u24default$iv = JwksTokenVerifierLoader.access$getHttpClient$p(this.this$0);
                        builder$iv = new HttpRequestBuilder();
                        $i$f$request = false;
                        this.label = 1;
                        v0 = new HttpStatement(builder$iv, $this$request_u24default$iv).execute((Continuation)this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        response = (HttpResponse)v0;
                        if (HttpStatusCodeKt.isSuccess((HttpStatusCode)response.getStatus())) break;
                        var8_9 = response.getStatus();
                        this.L$0 = var8_9;
                        this.label = 2;
                        v1 = HttpResponseKt.bodyAsText$default((HttpResponse)response, null, (Continuation)((Continuation)this), (int)1, null);
                        if (v1 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var8_9 = (HttpStatusCode)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        var9_10 = "Cannot fetch token keys (" + var8_9 + ") - " + v1;
                        throw new TokenValidationException(var9_10);
                    }
                }
                $this$body$iv = response;
                $i$f$body = false;
                $i$f$typeInfo = false;
                kType$iv$iv = Reflection.typeOf(JsonWebKeySet.class);
                reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                this.label = 3;
                v2 = $this$body$iv.getCall().bodyNullable(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(JsonWebKeySet.class), (KType)kType$iv$iv), (Continuation)this);
                if (v2 == var10_2) {
                    return var10_2;
                }
                ** GOTO lbl48
                {
                    case 3: {
                        $i$f$body = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl48:
                        // 2 sources

                        if (v2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.radarbase.auth.jwks.JsonWebKeySet");
                        }
                        return (JsonWebKeySet)v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super JsonWebKeySet> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public String toString() {
        return "MPTokenKeyAlgorithmKeyLoader<url=" + this.url + ">";
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JwtTokenVerifier toTokenVerifier(@NotNull Algorithm $this$toTokenVerifier, @NotNull String resourceName, @NotNull Function1<? super Verification, Unit> builder) {
        return Companion.toTokenVerifier($this$toTokenVerifier, resourceName, builder);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JwtTokenVerifier toTokenVerifier(@NotNull Algorithm $this$toTokenVerifier, @NotNull String resourceName) {
        return Companion.toTokenVerifier($this$toTokenVerifier, resourceName);
    }

    public static final /* synthetic */ Object access$fetchPublicKeyInfo(JwksTokenVerifierLoader $this, Continuation $completion) {
        return $this.fetchPublicKeyInfo((Continuation<? super JsonWebKeySet>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$getUrl$p(JwksTokenVerifierLoader $this) {
        return $this.url;
    }

    public static final /* synthetic */ HttpClient access$getHttpClient$p(JwksTokenVerifierLoader $this) {
        return $this.httpClient;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0019\b\u0002\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/radarbase/auth/jwks/JwksTokenVerifierLoader$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "toTokenVerifier", "Lorg/radarbase/auth/jwt/JwtTokenVerifier;", "Lcom/auth0/jwt/algorithms/Algorithm;", "resourceName", "", "builder", "Lkotlin/Function1;", "Lcom/auth0/jwt/interfaces/Verification;", "", "Lkotlin/ExtensionFunctionType;", "radar-auth"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final JwtTokenVerifier toTokenVerifier(@NotNull Algorithm $this$toTokenVerifier, @NotNull String resourceName, @NotNull Function1<? super Verification, Unit> builder) {
            Intrinsics.checkNotNullParameter((Object)$this$toTokenVerifier, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            Verification $this$toTokenVerifier_u24lambda_u240 = JWT.require((Algorithm)$this$toTokenVerifier);
            boolean bl = false;
            $this$toTokenVerifier_u24lambda_u240.withClaimPresence("scope");
            String[] stringArray = new String[]{resourceName};
            $this$toTokenVerifier_u24lambda_u240.withAudience(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)$this$toTokenVerifier_u24lambda_u240, (String)"toTokenVerifier$lambda$0");
            builder.invoke((Object)$this$toTokenVerifier_u24lambda_u240);
            JWTVerifier verifier = $this$toTokenVerifier_u24lambda_u240.build();
            String string = $this$toTokenVerifier.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"verifier");
            return new JwtTokenVerifier(string, (com.auth0.jwt.interfaces.JWTVerifier)verifier);
        }

        public static /* synthetic */ JwtTokenVerifier toTokenVerifier$default(Companion companion, Algorithm algorithm, String string, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = toTokenVerifier.1.INSTANCE;
            }
            return companion.toTokenVerifier(algorithm, string, (Function1<? super Verification, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final JwtTokenVerifier toTokenVerifier(@NotNull Algorithm $this$toTokenVerifier, @NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)$this$toTokenVerifier, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            return org.radarbase.auth.jwks.JwksTokenVerifierLoader$Companion.toTokenVerifier$default(this, $this$toTokenVerifier, resourceName, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

