/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.jwks;

import com.auth0.jwt.algorithms.Algorithm;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \r2\u00020\u0001:\u0001\rJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/radarbase/auth/jwks/PEMCertificateParser;", "", "jwtAlgorithm", "", "getJwtAlgorithm", "()Ljava/lang/String;", "keyFactoryType", "getKeyFactoryType", "keyHeader", "getKeyHeader", "parseAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "publicKey", "Companion", "radar-auth"})
public interface PEMCertificateParser {
    @NotNull
    public static final Companion Companion = org.radarbase.auth.jwks.PEMCertificateParser$Companion.$$INSTANCE;

    @NotNull
    public String getKeyFactoryType();

    @NotNull
    public String getJwtAlgorithm();

    @NotNull
    public String getKeyHeader();

    @NotNull
    public Algorithm parseAlgorithm(@NotNull String var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0002H\u0004\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/radarbase/auth/jwks/PEMCertificateParser$Companion;", "", "()V", "parsePublicKey", "T", "Ljava/security/PublicKey;", "", "keyFactoryType", "(Ljava/lang/String;Ljava/lang/String;)Ljava/security/PublicKey;", "radar-auth"})
    @SourceDebugExtension(value={"SMAP\nPEMCertificateParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PEMCertificateParser.kt\norg/radarbase/auth/jwks/PEMCertificateParser$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,58:1\n107#2:59\n79#2,22:60\n*S KotlinDebug\n*F\n+ 1 PEMCertificateParser.kt\norg/radarbase/auth/jwks/PEMCertificateParser$Companion\n*L\n46#1:59\n46#1:60,22\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T extends PublicKey> T parsePublicKey(String $this$parsePublicKey, String keyFactoryType) {
            void $this$trim$iv;
            Intrinsics.checkNotNullParameter((Object)$this$parsePublicKey, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)keyFactoryType, (String)"keyFactoryType");
            boolean $i$f$parsePublicKey = false;
            Object object = $this$parsePublicKey;
            Regex regex = new Regex("-----BEGIN ([A-Z]+ )?PUBLIC KEY-----");
            String string = "";
            object = regex.replace((CharSequence)object, string);
            regex = new Regex("-----END ([A-Z]+ )?PUBLIC KEY-----");
            string = "";
            object = regex.replace((CharSequence)object, string);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String trimmedKey = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            try {
                byte[] decodedPublicKey = Base64.getDecoder().decode(trimmedKey);
                X509EncodedKeySpec spec = new X509EncodedKeySpec(decodedPublicKey);
                KeyFactory kf = KeyFactory.getInstance(keyFactoryType);
                PublicKey publicKey = kf.generatePublic(spec);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                object = publicKey;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot parse public key with key factory type " + keyFactoryType, ex);
            }
            return (T)object;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

