/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.jwks;

import com.auth0.jwt.algorithms.Algorithm;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.radarbase.auth.jwks.ExtensionsKt;
import org.radarbase.auth.jwks.PEMCertificateParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/radarbase/auth/jwks/RSAPEMCertificateParser;", "Lorg/radarbase/auth/jwks/PEMCertificateParser;", "()V", "jwtAlgorithm", "", "getJwtAlgorithm", "()Ljava/lang/String;", "keyFactoryType", "getKeyFactoryType", "keyHeader", "getKeyHeader", "parseAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "publicKey", "radar-auth"})
@SourceDebugExtension(value={"SMAP\nRSAPEMCertificateParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RSAPEMCertificateParser.kt\norg/radarbase/auth/jwks/RSAPEMCertificateParser\n+ 2 PEMCertificateParser.kt\norg/radarbase/auth/jwks/PEMCertificateParser$Companion\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,20:1\n44#2,3:21\n47#2,7:47\n107#3:24\n79#3,22:25\n*S KotlinDebug\n*F\n+ 1 RSAPEMCertificateParser.kt\norg/radarbase/auth/jwks/RSAPEMCertificateParser\n*L\n17#1:21,3\n17#1:47,7\n17#1:24\n17#1:25,22\n*E\n"})
public final class RSAPEMCertificateParser
implements PEMCertificateParser {
    @Override
    @NotNull
    public String getKeyFactoryType() {
        return "RSA";
    }

    @Override
    @NotNull
    public String getJwtAlgorithm() {
        return "SHA256withRSA";
    }

    @Override
    @NotNull
    public String getKeyHeader() {
        return "-----BEGIN PUBLIC KEY-----";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Algorithm parseAlgorithm(@NotNull String publicKey) {
        void $this$trim$iv$iv;
        void $this$parsePublicKey$iv;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        PEMCertificateParser.Companion companion = PEMCertificateParser.Companion;
        String string = publicKey;
        String keyFactoryType$iv = this.getKeyFactoryType();
        boolean $i$f$parsePublicKey = false;
        Object object = (CharSequence)$this$parsePublicKey$iv;
        Regex regex = new Regex("-----BEGIN ([A-Z]+ )?PUBLIC KEY-----");
        String string2 = "";
        object = regex.replace((CharSequence)object, string2);
        regex = new Regex("-----END ([A-Z]+ )?PUBLIC KEY-----");
        string2 = "";
        object = regex.replace((CharSequence)object, string2);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv$iv = (CharSequence)$this$trim$iv$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv$iv = 0;
        int endIndex$iv$iv$iv = $this$trim$iv$iv$iv.length() - 1;
        boolean startFound$iv$iv$iv = false;
        while (startIndex$iv$iv$iv <= endIndex$iv$iv$iv) {
            boolean match$iv$iv$iv;
            int index$iv$iv$iv = !startFound$iv$iv$iv ? startIndex$iv$iv$iv : endIndex$iv$iv$iv;
            char it$iv = $this$trim$iv$iv$iv.charAt(index$iv$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv$iv = Intrinsics.compare((int)it$iv, (int)32) <= 0;
            if (!startFound$iv$iv$iv) {
                if (!match$iv$iv$iv) {
                    startFound$iv$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv$iv;
                continue;
            }
            if (!match$iv$iv$iv) break;
            --endIndex$iv$iv$iv;
        }
        String trimmedKey$iv = ((Object)$this$trim$iv$iv$iv.subSequence(startIndex$iv$iv$iv, endIndex$iv$iv$iv + 1)).toString();
        try {
            byte[] decodedPublicKey$iv = Base64.getDecoder().decode(trimmedKey$iv);
            X509EncodedKeySpec spec$iv = new X509EncodedKeySpec(decodedPublicKey$iv);
            KeyFactory kf$iv = KeyFactory.getInstance(keyFactoryType$iv);
            PublicKey publicKey2 = kf$iv.generatePublic(spec$iv);
            if (publicKey2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
            }
            object = (RSAPublicKey)publicKey2;
        }
        catch (Exception ex$iv) {
            throw new IllegalArgumentException("Cannot parse public key with key factory type " + keyFactoryType$iv, ex$iv);
        }
        return ExtensionsKt.toAlgorithm$default((RSAPublicKey)object, null, 1, null);
    }
}

