/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.auth.jwt;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.JWTVerifier;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.auth.authentication.TokenVerifier;
import org.radarbase.auth.authorization.AuthorityReference;
import org.radarbase.auth.authorization.RoleAuthority;
import org.radarbase.auth.token.DataRadarToken;
import org.radarbase.auth.token.RadarToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/radarbase/auth/jwt/JwtTokenVerifier;", "Lorg/radarbase/auth/authentication/TokenVerifier;", "algorithm", "", "verifier", "Lcom/auth0/jwt/interfaces/JWTVerifier;", "(Ljava/lang/String;Lcom/auth0/jwt/interfaces/JWTVerifier;)V", "toString", "verify", "Lorg/radarbase/auth/token/RadarToken;", "token", "Companion", "radar-auth"})
public final class JwtTokenVerifier
implements TokenVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String algorithm;
    @NotNull
    private final JWTVerifier verifier;
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenVerifier.class);
    @NotNull
    public static final String AUTHORITIES_CLAIM = "authorities";
    @NotNull
    public static final String ROLES_CLAIM = "roles";
    @NotNull
    public static final String SCOPE_CLAIM = "scope";
    @NotNull
    public static final String SOURCES_CLAIM = "sources";
    @NotNull
    public static final String GRANT_TYPE_CLAIM = "grant_type";
    @NotNull
    public static final String CLIENT_ID_CLAIM = "client_id";
    @NotNull
    public static final String USER_NAME_CLAIM = "user_name";

    public JwtTokenVerifier(@NotNull String algorithm, @NotNull JWTVerifier verifier) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        this.algorithm = algorithm;
        this.verifier = verifier;
    }

    @Override
    @NotNull
    public RadarToken verify(@NotNull String token) {
        RadarToken radarToken;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        try {
            DecodedJWT jwt = this.verifier.verify(token);
            logger.debug("Verified JWT header {} and payload {}", (Object)jwt.getHeader(), (Object)jwt.getPayload());
            Intrinsics.checkNotNullExpressionValue((Object)jwt, (String)"jwt");
            radarToken = Companion.toRadarToken(jwt);
        }
        catch (Throwable ex) {
            Throwable throwable = ex;
            if (throwable instanceof SignatureVerificationException) {
                logger.debug("Client presented a token with an incorrect signature.");
            } else if (throwable instanceof JWTVerificationException) {
                logger.debug("Verifier {} did not accept token: {}", this.verifier.getClass(), (Object)ex.getMessage());
            }
            throw ex;
        }
        return radarToken;
    }

    @NotNull
    public String toString() {
        return "JwtTokenVerifier(algorithm=" + this.algorithm + ")";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u0004J(\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0016*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u0004J\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/radarbase/auth/jwt/JwtTokenVerifier$Companion;", "", "()V", "AUTHORITIES_CLAIM", "", "CLIENT_ID_CLAIM", "GRANT_TYPE_CLAIM", "ROLES_CLAIM", "SCOPE_CLAIM", "SOURCES_CLAIM", "USER_NAME_CLAIM", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "parseRoles", "", "Lorg/radarbase/auth/authorization/AuthorityReference;", "", "Lcom/auth0/jwt/interfaces/Claim;", "stringClaim", "name", "stringListClaim", "", "toRadarToken", "Lorg/radarbase/auth/token/RadarToken;", "Lcom/auth0/jwt/interfaces/DecodedJWT;", "trimNotEmpty", "radar-auth"})
    @SourceDebugExtension(value={"SMAP\nJwtTokenVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenVerifier.kt\norg/radarbase/auth/jwt/JwtTokenVerifier$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1603#2,9:113\n1855#2:122\n1856#2:124\n1612#2:125\n1855#2,2:127\n1855#2,2:129\n1#3:123\n1#3:126\n*S KotlinDebug\n*F\n+ 1 JwtTokenVerifier.kt\norg/radarbase/auth/jwt/JwtTokenVerifier$Companion\n*L\n79#1:113,9\n79#1:122\n79#1:124\n79#1:125\n89#1:127,2\n95#1:129,2\n79#1:123\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RadarToken toRadarToken(@NotNull DecodedJWT $this$toRadarToken) {
            List list;
            Collection<String> collection;
            Intrinsics.checkNotNullParameter((Object)$this$toRadarToken, (String)"<this>");
            Map claims = $this$toRadarToken.getClaims();
            Intrinsics.checkNotNullExpressionValue((Object)claims, (String)"claims");
            Set<AuthorityReference> set = this.parseRoles(claims);
            Collection<String> collection2 = this.stringListClaim(claims, JwtTokenVerifier.SCOPE_CLAIM);
            if (collection2 == null || (collection2 = CollectionsKt.toSet((Iterable)collection2)) == null) {
                collection2 = collection = SetsKt.emptySet();
            }
            if ((list = this.stringListClaim(claims, JwtTokenVerifier.SOURCES_CLAIM)) == null) {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            String string = this.stringClaim(claims, JwtTokenVerifier.GRANT_TYPE_CLAIM);
            String string2 = $this$toRadarToken.getSubject();
            Instant instant = $this$toRadarToken.getIssuedAtAsInstant();
            Instant instant2 = $this$toRadarToken.getExpiresAtAsInstant();
            List list3 = $this$toRadarToken.getAudience();
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            List list4 = list3;
            String string3 = $this$toRadarToken.getToken();
            String string4 = $this$toRadarToken.getIssuer();
            String string5 = $this$toRadarToken.getType();
            String string6 = this.stringClaim(claims, JwtTokenVerifier.CLIENT_ID_CLAIM);
            String string7 = this.stringClaim(claims, JwtTokenVerifier.USER_NAME_CLAIM);
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"expiresAtAsInstant");
            return new DataRadarToken(set, (Set<String>)collection, list2, string, string2, string7, instant, instant2, list4, string3, string4, string5, string6);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<String> stringListClaim(@NotNull Map<String, ? extends Claim> $this$stringListClaim, @NotNull String name) {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            List claimList;
            List list;
            List list2;
            Intrinsics.checkNotNullParameter($this$stringListClaim, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Claim claim = $this$stringListClaim.get(name);
            if (claim == null) {
                return null;
            }
            Claim claim2 = claim;
            try {
                list2 = claim2.asList(String.class);
            }
            catch (JWTDecodeException ex) {
                list2 = null;
            }
            if ((list = (claimList = list2)) == null) {
                List list3;
                String string = claim2.asString();
                if (string != null) {
                    object = new char[1];
                    object[0] = 32;
                    list3 = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
                } else {
                    list3 = list = null;
                }
                if (list3 == null) {
                    return null;
                }
            }
            List claims = list;
            Iterable $this$mapNotNull$iv = claims;
            boolean $i$f$mapNotNull = false;
            object = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                String string2 = it;
                if (string2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                    string = Companion.trimNotEmpty(it);
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final String stringClaim(@NotNull Map<String, ? extends Claim> $this$stringClaim, @NotNull String name) {
            String string;
            Intrinsics.checkNotNullParameter($this$stringClaim, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Claim claim = $this$stringClaim.get(name);
            return claim != null && (string = claim.asString()) != null ? this.trimNotEmpty(string) : null;
        }

        private final String trimNotEmpty(String $this$trimNotEmpty) {
            String string;
            String it = string = ((Object)StringsKt.trim((CharSequence)$this$trimNotEmpty)).toString();
            boolean bl = false;
            return ((CharSequence)it).length() > 0 ? string : null;
        }

        private final Set<AuthorityReference> parseRoles(Map<String, ? extends Claim> $this$parseRoles) {
            Set set;
            block5: {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Set $this$parseRoles_u24lambda_u244 = set = SetsKt.createSetBuilder();
                boolean bl = false;
                List<String> list = Companion.stringListClaim($this$parseRoles, JwtTokenVerifier.AUTHORITIES_CLAIM);
                if (list != null) {
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RoleAuthority role;
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        RoleAuthority roleAuthority = role = RoleAuthority.Companion.valueOfAuthorityOrNull(it);
                        if ((roleAuthority != null ? roleAuthority.getScope() : null) != RoleAuthority.Scope.GLOBAL) continue;
                        $this$parseRoles_u24lambda_u244.add(new AuthorityReference(role, null, 2, null));
                    }
                }
                List<String> list2 = Companion.stringListClaim($this$parseRoles, JwtTokenVerifier.ROLES_CLAIM);
                if (list2 == null) break block5;
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String input = (String)element$iv;
                    boolean bl3 = false;
                    char[] cArray = new char[]{':'};
                    List v = StringsKt.split$default((CharSequence)input, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    try {
                        $this$parseRoles_u24lambda_u244.add(v.size() == 1 || ((CharSequence)v.get(1)).length() == 0 ? new AuthorityReference((String)v.get(0), null, 2, null) : new AuthorityReference((String)v.get(1), (String)v.get(0)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
            }
            return SetsKt.build((Set)set);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

