/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.radarbase.config.ServerConfig;
import org.radarbase.config.ServerConfigMixin;

public class YamlConfigLoader {
    public static final JsonFactory YAML_FACTORY = new YAMLFactory();
    private final ObjectMapper yamlMapper = new ObjectMapper(YAML_FACTORY);

    public YamlConfigLoader() {
        this(mapper -> {});
    }

    public YamlConfigLoader(Consumer<ObjectMapper> mapperConfigurator) {
        this.yamlMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.yamlMapper.setVisibility(this.yamlMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this.yamlMapper.addMixIn(ServerConfig.class, ServerConfigMixin.class);
        mapperConfigurator.accept(this.yamlMapper);
    }

    public <T> T load(Path file, Class<T> configClass) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            Object object = this.yamlMapper.readValue((Reader)reader, configClass);
            return (T)object;
        }
    }

    public void store(Path file, Object config) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.yamlMapper.writeValue((Writer)writer, config);
        }
    }

    public String prettyString(Object config) {
        ObjectMapper prettyPrintMapper = this.yamlMapper.copy();
        prettyPrintMapper.enable(SerializationFeature.INDENT_OUTPUT);
        prettyPrintMapper.enable(SerializationFeature.WRAP_ROOT_VALUE);
        try {
            return prettyPrintMapper.writeValueAsString(config);
        }
        catch (JsonProcessingException ex) {
            throw new UnsupportedOperationException("Cannot serialize config", ex);
        }
    }
}

