/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.stream.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificRecord;
import org.radarbase.stream.collector.AggregateListState;
import org.radarbase.stream.collector.NumericAggregateCollector;
import org.radarbase.stream.collector.NumericAggregateState;
import org.radarbase.stream.collector.RecordCollector;
import org.radarbase.util.SpecificAvroConvertible;

public class AggregateListCollector
implements RecordCollector,
SpecificAvroConvertible {
    private NumericAggregateCollector[] collectors;

    public AggregateListCollector() {
        this.collectors = null;
    }

    public AggregateListCollector(String[] fieldNames, boolean useReservoir) {
        this(fieldNames, null, useReservoir);
    }

    public AggregateListCollector(String[] fieldNames, Schema schema, boolean useReservoir) {
        this.collectors = new NumericAggregateCollector[fieldNames.length];
        for (int i = 0; i < this.collectors.length; ++i) {
            this.collectors[i] = new NumericAggregateCollector(fieldNames[i], schema, useReservoir);
        }
    }

    @Override
    public AggregateListCollector add(IndexedRecord record) {
        for (NumericAggregateCollector collector : this.collectors) {
            collector.add(record);
        }
        return this;
    }

    public AggregateListCollector add(double ... value) {
        if (this.collectors.length != value.length) {
            throw new IllegalArgumentException("The length of current input differs from the length of the value used to instantiate this collector");
        }
        for (int i = 0; i < this.collectors.length; ++i) {
            this.collectors[i].add(value[i]);
        }
        return this;
    }

    public String toString() {
        return Arrays.toString(this.collectors);
    }

    public List<NumericAggregateCollector> getCollectors() {
        return Arrays.asList(this.collectors);
    }

    @Override
    public AggregateListState toAvro() {
        AggregateListState state = new AggregateListState();
        if (this.collectors == null) {
            state.setAggregates(Collections.emptyList());
        } else {
            ArrayList<Object> aggregates = new ArrayList<Object>(this.collectors.length);
            for (NumericAggregateCollector collector : this.collectors) {
                aggregates.add(collector.toAvro());
            }
            state.setAggregates(aggregates);
        }
        return state;
    }

    @Override
    public void fromAvro(SpecificRecord record) {
        if (!(record instanceof AggregateListState)) {
            throw new IllegalArgumentException("Cannot convert incompatible Avro record");
        }
        AggregateListState aggregateList = (AggregateListState)record;
        List<Object> aggregates = aggregateList.getAggregates();
        int len = aggregates.size();
        this.collectors = new NumericAggregateCollector[len];
        for (int i = 0; i < len; ++i) {
            Object aggregate = aggregates.get(i);
            if (!(aggregate instanceof NumericAggregateState)) {
                throw new IllegalArgumentException("Cannot convert type " + record.getClass());
            }
            this.collectors[i] = new NumericAggregateCollector();
            this.collectors[i].fromAvro((SpecificRecord)aggregate);
        }
    }
}

