/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.stream.collector;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificRecord;
import org.radarbase.stream.collector.BigDecimalState;
import org.radarbase.stream.collector.NumericAggregateState;
import org.radarbase.stream.collector.RecordCollector;
import org.radarbase.stream.collector.UniformSamplingReservoir;
import org.radarbase.util.Serialization;
import org.radarbase.util.SpecificAvroConvertible;

public class NumericAggregateCollector
implements RecordCollector,
SpecificAvroConvertible {
    private String name;
    private int pos;
    private Schema.Type fieldType;
    private double min;
    private double max;
    private long count = 0L;
    private BigDecimal sum = BigDecimal.ZERO;
    private UniformSamplingReservoir reservoir;

    public NumericAggregateCollector() {
        this(null, null, false);
    }

    public NumericAggregateCollector(String fieldName, boolean useReservoir) {
        this(fieldName, null, useReservoir);
    }

    public NumericAggregateCollector(String fieldName, Schema schema, boolean useReservoir) {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.reservoir = useReservoir ? new UniformSamplingReservoir() : null;
        this.name = fieldName;
        if (schema == null) {
            this.pos = -1;
            this.fieldType = null;
        } else {
            Schema.Field field = schema.getField(fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Field " + fieldName + " does not exist in schema " + schema.getFullName());
            }
            this.pos = field.pos();
            this.fieldType = NumericAggregateCollector.getType(field);
        }
    }

    private static Schema.Type getType(Schema.Field field) {
        Schema.Type apparentType = field.schema().getType();
        if (apparentType == Schema.Type.UNION) {
            for (Schema subSchema : field.schema().getTypes()) {
                if (subSchema.getType() == Schema.Type.NULL) continue;
                apparentType = subSchema.getType();
                break;
            }
        }
        if (apparentType != Schema.Type.DOUBLE && apparentType != Schema.Type.FLOAT && apparentType != Schema.Type.INT && apparentType != Schema.Type.LONG) {
            throw new IllegalArgumentException("Field " + field.name() + " is not a number type.");
        }
        return apparentType;
    }

    @Override
    public NumericAggregateCollector add(IndexedRecord record) {
        if (this.pos == -1) {
            throw new IllegalStateException("Cannot add record without specifying a schema in the constructor.");
        }
        Number value = (Number)record.get(this.pos);
        if (value == null) {
            return this;
        }
        if (this.fieldType == Schema.Type.FLOAT) {
            return this.add(Double.parseDouble(value.toString()));
        }
        return this.add(value.doubleValue());
    }

    public NumericAggregateCollector add(float value) {
        return this.add(Serialization.floatToDouble((float)value));
    }

    public NumericAggregateCollector add(double value) {
        this.sum = this.sum.add(BigDecimal.valueOf(value));
        if (this.reservoir != null) {
            this.reservoir.add(value);
        }
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
        ++this.count;
        return this;
    }

    public String toString() {
        return "DoubleValueCollector{name=" + this.getName() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", sum=" + this.getSum() + ", mean=" + this.getMean() + ", quartile=" + this.getQuartile() + ", count=" + this.getCount() + ", reservoir=" + this.reservoir + "}";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum.doubleValue();
    }

    public long getCount() {
        return this.count;
    }

    public double getMean() {
        return this.sum.doubleValue() / (double)this.getCount();
    }

    public boolean hasReservoir() {
        return this.reservoir != null;
    }

    public List<Double> getQuartile() {
        if (!this.hasReservoir()) {
            throw new IllegalStateException("Cannot query quartiles without reservoir");
        }
        return this.reservoir.getQuartiles();
    }

    public double getInterQuartileRange() {
        List<Double> quartiles = this.getQuartile();
        return BigDecimal.valueOf(quartiles.get(2)).subtract(BigDecimal.valueOf(quartiles.get(0))).doubleValue();
    }

    public String getName() {
        return this.name;
    }

    protected UniformSamplingReservoir getReservoir() {
        return this.reservoir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericAggregateCollector that = (NumericAggregateCollector)o;
        return this.pos == that.pos && this.count == that.count && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0 && Objects.equals(this.name, that.name) && this.fieldType == that.fieldType && Objects.equals(this.sum, that.sum) && Objects.equals(this.reservoir, that.reservoir);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pos, this.fieldType, this.min, this.max, this.sum, this.reservoir);
    }

    @Override
    public SpecificRecord toAvro() {
        NumericAggregateState state = new NumericAggregateState();
        state.setCount(this.count);
        if (this.count > 0L) {
            state.setMin(this.min);
            state.setMax(this.max);
            state.setSum(new BigDecimalState(ByteBuffer.wrap(this.sum.unscaledValue().toByteArray()), this.sum.scale()));
        } else {
            state.setMin(null);
            state.setMax(null);
            state.setSum(null);
        }
        if (this.pos != -1) {
            state.setPos(this.pos);
            state.setFieldType(this.fieldType.name());
        } else {
            state.setPos(null);
            state.setFieldType(null);
        }
        state.setName(this.name);
        state.setReservoir(this.reservoir != null ? this.reservoir.toAvro() : null);
        return state;
    }

    @Override
    public void fromAvro(SpecificRecord record) {
        if (!(record instanceof NumericAggregateState)) {
            throw new IllegalArgumentException("Cannot deserialize from non NumericAggregateState");
        }
        NumericAggregateState state = (NumericAggregateState)record;
        this.name = state.getName();
        if (state.getPos() != null) {
            this.pos = state.getPos();
            this.fieldType = Schema.Type.valueOf((String)state.getFieldType());
        } else {
            this.pos = -1;
            this.fieldType = null;
        }
        this.count = state.getCount();
        if (this.count > 0L) {
            this.min = state.getMin();
            this.max = state.getMax();
            this.sum = new BigDecimal(new BigInteger(state.getSum().getIntVal().array()), state.getSum().getScale());
        } else {
            this.min = Double.MAX_VALUE;
            this.max = Double.MIN_VALUE;
            this.sum = BigDecimal.ZERO;
        }
        if (state.getReservoir() == null) {
            this.reservoir = null;
        } else {
            this.reservoir = new UniformSamplingReservoir(new double[0], 0L, 1);
            this.reservoir.fromAvro(state.getReservoir());
        }
    }
}

