/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.stream.collector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarbase.stream.collector.BigDecimalState;
import org.radarbase.stream.collector.SamplingReservoirState;

@AvroGenerated
public class NumericAggregateState
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -4736695739985929457L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NumericAggregateState\",\"namespace\":\"org.radarbase.stream.collector\",\"doc\":\"State of the NumericAggregateCollector\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of field or null if not belonging to a specific field.\",\"default\":null},{\"name\":\"pos\",\"type\":[\"null\",\"int\"],\"doc\":\"Position of field or null if not belonging to a specific field.\",\"default\":null},{\"name\":\"fieldType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Type of field or null if not belonging to a specific field.\",\"default\":null},{\"name\":\"count\",\"type\":\"long\",\"doc\":\"Number of values encountered.\"},{\"name\":\"min\",\"type\":[\"null\",\"double\"],\"doc\":\"Minimum value encountered or null if no value has been encountered.\",\"default\":null},{\"name\":\"max\",\"type\":[\"null\",\"double\"],\"doc\":\"Maximum value encountered or null if no value has been encountered.\",\"default\":null},{\"name\":\"sum\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"BigDecimalState\",\"fields\":[{\"name\":\"intVal\",\"type\":\"bytes\",\"doc\":\"java BigInteger integer value.\"},{\"name\":\"scale\",\"type\":\"int\",\"doc\":\"java BigDecimal scale.\"}]}],\"doc\":\"Sum encoded as Java BigDecimal bytes or null if no value has been encountered.\",\"default\":null},{\"name\":\"reservoir\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"SamplingReservoirState\",\"fields\":[{\"name\":\"samples\",\"type\":{\"type\":\"array\",\"items\":\"double\"},\"doc\":\"java BigInteger integer value.\"},{\"name\":\"count\",\"type\":\"long\",\"doc\":\"Number of values processed for samples.\"},{\"name\":\"maxSize\",\"type\":\"int\",\"doc\":\"Maximum size of the reservoir.\"}]}],\"doc\":\"Uniform sampling reservoir of values encountered. Null if reservoir sampling is disabled or no value has been encountered.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<NumericAggregateState> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<NumericAggregateState> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private String name;
    private Integer pos;
    private String fieldType;
    private long count;
    private Double min;
    private Double max;
    private BigDecimalState sum;
    private SamplingReservoirState reservoir;
    private static final DatumWriter<NumericAggregateState> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<NumericAggregateState> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<NumericAggregateState> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<NumericAggregateState> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<NumericAggregateState> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static NumericAggregateState fromByteBuffer(ByteBuffer b) throws IOException {
        return (NumericAggregateState)((Object)DECODER.decode(b));
    }

    public NumericAggregateState() {
    }

    public NumericAggregateState(String name, Integer pos, String fieldType, Long count, Double min, Double max, BigDecimalState sum, SamplingReservoirState reservoir) {
        this.name = name;
        this.pos = pos;
        this.fieldType = fieldType;
        this.count = count;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.reservoir = reservoir;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.pos;
            }
            case 2: {
                return this.fieldType;
            }
            case 3: {
                return this.count;
            }
            case 4: {
                return this.min;
            }
            case 5: {
                return this.max;
            }
            case 6: {
                return this.sum;
            }
            case 7: {
                return this.reservoir;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.pos = (Integer)value$;
                break;
            }
            case 2: {
                this.fieldType = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.count = (Long)value$;
                break;
            }
            case 4: {
                this.min = (Double)value$;
                break;
            }
            case 5: {
                this.max = (Double)value$;
                break;
            }
            case 6: {
                this.sum = (BigDecimalState)((Object)value$);
                break;
            }
            case 7: {
                this.reservoir = (SamplingReservoirState)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Integer getPos() {
        return this.pos;
    }

    public void setPos(Integer value) {
        this.pos = value;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String value) {
        this.fieldType = value;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long value) {
        this.count = value;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double value) {
        this.min = value;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double value) {
        this.max = value;
    }

    public BigDecimalState getSum() {
        return this.sum;
    }

    public void setSum(BigDecimalState value) {
        this.sum = value;
    }

    public SamplingReservoirState getReservoir() {
        return this.reservoir;
    }

    public void setReservoir(SamplingReservoirState value) {
        this.reservoir = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(NumericAggregateState other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.name == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.name);
        }
        if (this.pos == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.pos.intValue());
        }
        if (this.fieldType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.fieldType);
        }
        out.writeLong(this.count);
        if (this.min == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.min.doubleValue());
        }
        if (this.max == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.max.doubleValue());
        }
        if (this.sum == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.sum.customEncode(out);
        }
        if (this.reservoir == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.reservoir.customEncode(out);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.name = null;
            } else {
                this.name = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.pos = null;
            } else {
                this.pos = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fieldType = null;
            } else {
                this.fieldType = in.readString();
            }
            this.count = in.readLong();
            if (in.readIndex() != 1) {
                in.readNull();
                this.min = null;
            } else {
                this.min = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.max = null;
            } else {
                this.max = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.sum = null;
            } else {
                if (this.sum == null) {
                    this.sum = new BigDecimalState();
                }
                this.sum.customDecode(in);
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.reservoir = null;
            } else {
                if (this.reservoir == null) {
                    this.reservoir = new SamplingReservoirState();
                }
                this.reservoir.customDecode(in);
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.name = null;
                            continue block10;
                        }
                        this.name = in.readString();
                        continue block10;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.pos = null;
                            continue block10;
                        }
                        this.pos = in.readInt();
                        continue block10;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fieldType = null;
                            continue block10;
                        }
                        this.fieldType = in.readString();
                        continue block10;
                    }
                    case 3: {
                        this.count = in.readLong();
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.min = null;
                            continue block10;
                        }
                        this.min = in.readDouble();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.max = null;
                            continue block10;
                        }
                        this.max = in.readDouble();
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sum = null;
                            continue block10;
                        }
                        if (this.sum == null) {
                            this.sum = new BigDecimalState();
                        }
                        this.sum.customDecode(in);
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.reservoir = null;
                            continue block10;
                        }
                        if (this.reservoir == null) {
                            this.reservoir = new SamplingReservoirState();
                        }
                        this.reservoir.customDecode(in);
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<NumericAggregateState>
    implements RecordBuilder<NumericAggregateState> {
        private String name;
        private Integer pos;
        private String fieldType;
        private long count;
        private Double min;
        private Double max;
        private BigDecimalState sum;
        private BigDecimalState.Builder sumBuilder;
        private SamplingReservoirState reservoir;
        private SamplingReservoirState.Builder reservoirBuilder;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.pos)) {
                this.pos = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.pos);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fieldType)) {
                this.fieldType = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fieldType);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.count)) {
                this.count = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.count);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.min)) {
                this.min = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.min);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.max)) {
                this.max = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.max);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.sum))) {
                this.sum = (BigDecimalState)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sum));
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (other.hasSumBuilder()) {
                this.sumBuilder = BigDecimalState.newBuilder(other.getSumBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.reservoir))) {
                this.reservoir = (SamplingReservoirState)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.reservoir));
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (other.hasReservoirBuilder()) {
                this.reservoirBuilder = SamplingReservoirState.newBuilder(other.getReservoirBuilder());
            }
        }

        private Builder(NumericAggregateState other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.pos)) {
                this.pos = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.pos);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fieldType)) {
                this.fieldType = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fieldType);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.count)) {
                this.count = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.count);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.min)) {
                this.min = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.min);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.max)) {
                this.max = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.max);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.sum))) {
                this.sum = (BigDecimalState)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sum));
                this.fieldSetFlags()[6] = true;
            }
            this.sumBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.reservoir))) {
                this.reservoir = (SamplingReservoirState)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.reservoir));
                this.fieldSetFlags()[7] = true;
            }
            this.reservoirBuilder = null;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[0], value);
            this.name = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Integer getPos() {
            return this.pos;
        }

        public Builder setPos(Integer value) {
            this.validate(this.fields()[1], value);
            this.pos = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasPos() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearPos() {
            this.pos = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setFieldType(String value) {
            this.validate(this.fields()[2], value);
            this.fieldType = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFieldType() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFieldType() {
            this.fieldType = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public long getCount() {
            return this.count;
        }

        public Builder setCount(long value) {
            this.validate(this.fields()[3], value);
            this.count = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasCount() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearCount() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Double getMin() {
            return this.min;
        }

        public Builder setMin(Double value) {
            this.validate(this.fields()[4], value);
            this.min = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasMin() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearMin() {
            this.min = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Double getMax() {
            return this.max;
        }

        public Builder setMax(Double value) {
            this.validate(this.fields()[5], value);
            this.max = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMax() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearMax() {
            this.max = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public BigDecimalState getSum() {
            return this.sum;
        }

        public Builder setSum(BigDecimalState value) {
            this.validate(this.fields()[6], (Object)value);
            this.sumBuilder = null;
            this.sum = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSum() {
            return this.fieldSetFlags()[6];
        }

        public BigDecimalState.Builder getSumBuilder() {
            if (this.sumBuilder == null) {
                if (this.hasSum()) {
                    this.setSumBuilder(BigDecimalState.newBuilder(this.sum));
                } else {
                    this.setSumBuilder(BigDecimalState.newBuilder());
                }
            }
            return this.sumBuilder;
        }

        public Builder setSumBuilder(BigDecimalState.Builder value) {
            this.clearSum();
            this.sumBuilder = value;
            return this;
        }

        public boolean hasSumBuilder() {
            return this.sumBuilder != null;
        }

        public Builder clearSum() {
            this.sum = null;
            this.sumBuilder = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public SamplingReservoirState getReservoir() {
            return this.reservoir;
        }

        public Builder setReservoir(SamplingReservoirState value) {
            this.validate(this.fields()[7], (Object)value);
            this.reservoirBuilder = null;
            this.reservoir = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasReservoir() {
            return this.fieldSetFlags()[7];
        }

        public SamplingReservoirState.Builder getReservoirBuilder() {
            if (this.reservoirBuilder == null) {
                if (this.hasReservoir()) {
                    this.setReservoirBuilder(SamplingReservoirState.newBuilder(this.reservoir));
                } else {
                    this.setReservoirBuilder(SamplingReservoirState.newBuilder());
                }
            }
            return this.reservoirBuilder;
        }

        public Builder setReservoirBuilder(SamplingReservoirState.Builder value) {
            this.clearReservoir();
            this.reservoirBuilder = value;
            return this;
        }

        public boolean hasReservoirBuilder() {
            return this.reservoirBuilder != null;
        }

        public Builder clearReservoir() {
            this.reservoir = null;
            this.reservoirBuilder = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public NumericAggregateState build() {
            try {
                NumericAggregateState record = new NumericAggregateState();
                record.name = this.fieldSetFlags()[0] ? this.name : (String)this.defaultValue(this.fields()[0]);
                record.pos = this.fieldSetFlags()[1] ? this.pos : (Integer)this.defaultValue(this.fields()[1]);
                record.fieldType = this.fieldSetFlags()[2] ? this.fieldType : (String)this.defaultValue(this.fields()[2]);
                record.count = this.fieldSetFlags()[3] ? this.count : (Long)this.defaultValue(this.fields()[3]);
                record.min = this.fieldSetFlags()[4] ? this.min : (Double)this.defaultValue(this.fields()[4]);
                Double d = record.max = this.fieldSetFlags()[5] ? this.max : (Double)this.defaultValue(this.fields()[5]);
                if (this.sumBuilder != null) {
                    try {
                        record.sum = this.sumBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("sum"));
                        throw e;
                    }
                } else {
                    BigDecimalState bigDecimalState = record.sum = this.fieldSetFlags()[6] ? this.sum : (BigDecimalState)((Object)this.defaultValue(this.fields()[6]));
                }
                if (this.reservoirBuilder != null) {
                    try {
                        record.reservoir = this.reservoirBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("reservoir"));
                        throw e;
                    }
                } else {
                    record.reservoir = this.fieldSetFlags()[7] ? this.reservoir : (SamplingReservoirState)((Object)this.defaultValue(this.fields()[7]));
                }
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

