/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.stream.collector;

import com.fasterxml.jackson.annotation.JsonGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.avro.specific.SpecificRecord;
import org.radarbase.stream.collector.SamplingReservoirState;
import org.radarbase.util.SpecificAvroConvertible;

public class UniformSamplingReservoir
implements SpecificAvroConvertible {
    private double[] samples;
    private int maxSize;
    private long count;
    private transient int currentLength;
    private static final int MAX_SIZE_DEFAULT = 999;

    public UniformSamplingReservoir() {
        this(new double[0], 0L, 999);
    }

    public UniformSamplingReservoir(double ... allValues) {
        this(allValues, allValues.length, 999);
    }

    public UniformSamplingReservoir(double[] samples, long count, int maxSize) {
        this.initializeReservoir(samples, count, maxSize);
    }

    private void initializeReservoir(double[] initSamples, long initCount, int initMaxSize) {
        if (initSamples == null) {
            throw new IllegalArgumentException("Samples may not be null");
        }
        if (initMaxSize <= 0) {
            throw new IllegalArgumentException("Reservoir maximum size must be strictly positive");
        }
        if (initCount < (long)initSamples.length) {
            throw new IllegalArgumentException("Reservoir count must be larger or equal than number of samples.");
        }
        this.maxSize = initMaxSize;
        this.samples = new double[initMaxSize];
        this.count = initCount;
        int length = (int)Math.min((long)initSamples.length, this.count);
        if (length == 0) {
            this.currentLength = 0;
            return;
        }
        this.subsample(initSamples, length);
        Arrays.sort(this.samples, 0, this.currentLength);
    }

    private void subsample(double[] initSamples, int length) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (length > this.maxSize * 2) {
            HashSet<Integer> indexSet = new HashSet<Integer>();
            int sampleIndex = 0;
            while (sampleIndex < this.maxSize) {
                int initIndex = random.nextInt(length);
                if (!indexSet.add(initIndex)) continue;
                this.samples[sampleIndex] = initSamples[initIndex];
                ++sampleIndex;
            }
            this.currentLength = this.maxSize;
        } else if (length > this.maxSize) {
            LinkedList<Integer> allInitIndexes = new LinkedList<Integer>();
            for (int i = 0; i < length; ++i) {
                allInitIndexes.add(i);
            }
            for (int sampleIndex = 0; sampleIndex < this.maxSize; ++sampleIndex) {
                int initIndex = (Integer)allInitIndexes.remove(random.nextInt(allInitIndexes.size()));
                this.samples[sampleIndex] = initSamples[initIndex];
            }
            this.currentLength = this.maxSize;
        } else {
            System.arraycopy(initSamples, 0, this.samples, 0, length);
            this.currentLength = length;
        }
    }

    public void add(double value) {
        if (this.currentLength == this.maxSize) {
            long removeIndex = ThreadLocalRandom.current().nextLong(this.count);
            if (removeIndex < (long)this.maxSize) {
                this.removeAndAdd((int)removeIndex, value);
            }
        } else {
            this.removeAndAdd(this.currentLength, value);
            ++this.currentLength;
        }
        ++this.count;
    }

    private void removeAndAdd(int removeIndex, double value) {
        int addIndex = Arrays.binarySearch(this.samples, 0, this.currentLength, value);
        if (addIndex < 0) {
            addIndex = -addIndex - 1;
        }
        if (removeIndex < addIndex) {
            if (removeIndex < --addIndex) {
                System.arraycopy(this.samples, removeIndex + 1, this.samples, removeIndex, addIndex - removeIndex);
            }
        } else if (removeIndex > addIndex) {
            System.arraycopy(this.samples, addIndex, this.samples, addIndex + 1, removeIndex - addIndex);
        }
        this.samples[addIndex] = value;
    }

    public List<Double> getQuartiles() {
        ArrayList<Double> quartiles = new ArrayList<Double>(3);
        switch (this.currentLength) {
            case 0: {
                quartiles.add(Double.NaN);
                quartiles.add(Double.NaN);
                quartiles.add(Double.NaN);
                break;
            }
            case 1: {
                quartiles.add(this.samples[0]);
                quartiles.add(this.samples[0]);
                quartiles.add(this.samples[0]);
                break;
            }
            default: {
                for (int i = 1; i <= 3; ++i) {
                    double pos = (double)(i * (this.currentLength + 1)) * 0.25;
                    int intPos = (int)pos;
                    if (intPos == 0) {
                        quartiles.add(this.samples[0]);
                        continue;
                    }
                    if (intPos == this.currentLength) {
                        quartiles.add(this.samples[this.currentLength - 1]);
                        continue;
                    }
                    double diff = pos - (double)intPos;
                    double base = this.samples[intPos - 1];
                    quartiles.add(base + diff * (this.samples[intPos] - base));
                }
            }
        }
        return quartiles;
    }

    @JsonGetter
    public List<Double> getSamples() {
        ArrayList<Double> doubleList = new ArrayList<Double>(this.currentLength);
        for (int i = 0; i < this.currentLength; ++i) {
            doubleList.add(this.samples[i]);
        }
        return doubleList;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniformSamplingReservoir that = (UniformSamplingReservoir)o;
        return this.count == that.count && this.maxSize == that.maxSize && Arrays.equals(this.samples, that.samples);
    }

    public int hashCode() {
        return Objects.hash(this.samples, this.maxSize, this.count);
    }

    public String toString() {
        return "UniformSamplingReservoir{samples=" + Arrays.toString(this.samples) + ", maxSize=" + this.maxSize + ", count=" + this.count + "}";
    }

    @Override
    public SamplingReservoirState toAvro() {
        SamplingReservoirState state = new SamplingReservoirState();
        state.setCount(this.count);
        state.setMaxSize(this.maxSize);
        int length = (int)Math.min((long)this.maxSize, this.count);
        ArrayList<Double> sampleList = new ArrayList<Double>(length);
        for (int i = 0; i < length; ++i) {
            sampleList.add(this.samples[i]);
        }
        state.setSamples(sampleList);
        return state;
    }

    @Override
    public void fromAvro(SpecificRecord record) {
        if (!(record instanceof SamplingReservoirState)) {
            throw new IllegalArgumentException("Cannot initialize from non-samplingreservoirstate");
        }
        SamplingReservoirState state = (SamplingReservoirState)record;
        List<Double> stateSamples = state.getSamples();
        if (stateSamples == null) {
            throw new IllegalArgumentException("Samples may not be null");
        }
        double[] newSamples = new double[stateSamples.size()];
        for (int i = 0; i < newSamples.length; ++i) {
            newSamples[i] = stateSamples.get(i);
        }
        this.initializeReservoir(newSamples, state.getCount(), state.getMaxSize());
    }
}

