/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.util;

import java.util.Deque;
import java.util.LinkedList;

public class RollingTimeAverage {
    private final long window;
    private TimeCount firstTime;
    private double total;
    private final Deque<TimeCount> deque;

    public RollingTimeAverage(long timeWindowMillis) {
        this.window = timeWindowMillis;
        this.total = 0.0;
        this.firstTime = null;
        this.deque = new LinkedList<TimeCount>();
    }

    public boolean hasAverage() {
        return this.firstTime != null;
    }

    public void add(double x) {
        if (this.firstTime == null) {
            this.firstTime = new TimeCount(x);
        } else {
            this.deque.addLast(new TimeCount(x));
        }
        this.total += x;
    }

    public void increment() {
        this.add(1.0);
    }

    public double getAverage() {
        if (!this.hasAverage()) {
            throw new IllegalStateException("Cannot get average without values");
        }
        long now = System.currentTimeMillis();
        long currentWindowStart = now - this.window;
        while (!this.deque.isEmpty() && this.deque.getFirst().time < currentWindowStart) {
            this.total -= this.firstTime.value;
            this.firstTime = this.deque.removeFirst();
        }
        if (this.deque.isEmpty() || this.firstTime.time >= currentWindowStart) {
            return 1000.0 * this.total / (double)(now - this.firstTime.time);
        }
        long time = this.deque.getLast().time - currentWindowStart;
        double removedRate = (currentWindowStart - this.firstTime.time) / (this.deque.getFirst().time - this.firstTime.time);
        double removedValue = this.firstTime.value + this.deque.getFirst().value * removedRate;
        double value = (this.total - removedValue) / (double)time;
        return 1000.0 * value;
    }

    public int getCount() {
        return (int)Math.round(this.getAverage());
    }

    private static class TimeCount {
        private final double value;
        private final long time;

        TimeCount(double value) {
            this.value = value;
            this.time = System.currentTimeMillis();
        }
    }
}

